/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.coverage.report.impl.html.fs;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import jetbrains.coverage.report.impl.IOUtil;
import jetbrains.coverage.report.impl.html.fs.FileSystem;
import org.jetbrains.annotations.NotNull;

public class ZipFileSystem
implements FileSystem,
Closeable {
    private final File myBase;
    private final ZipOutputStream myZos;
    private final AtomicBoolean myIsWriting = new AtomicBoolean(false);
    private final Set<String> myFiles = new TreeSet<String>();

    public ZipFileSystem(@NotNull File output) throws IOException {
        this.myBase = output.getParentFile();
        IOUtil.createDir(this.myBase);
        this.myZos = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(output)));
    }

    @NotNull
    public OutputStream openFile(@NotNull File path2) throws IOException {
        String rel = IOUtil.makeRelative(this.myBase, path2);
        if (!this.myFiles.add(rel)) {
            System.err.println(this.getClass().getCanonicalName() + ": Attepting to write to " + rel + " second time. Fake output stream will be returned to avoid error");
            return new OutputStream(){

                public void write(int b) throws IOException {
                }
            };
        }
        if (!this.myIsWriting.compareAndSet(false, true)) {
            throw new IOException("Failed to open more than one writer into zip");
        }
        this.myZos.putNextEntry(new ZipEntry(rel));
        return new OutputStream(){

            public void write(int b) throws IOException {
                ZipFileSystem.this.myZos.write(b);
            }

            public void write(byte[] b) throws IOException {
                ZipFileSystem.this.myZos.write(b);
            }

            public void write(byte[] b, int off, int len) throws IOException {
                ZipFileSystem.this.myZos.write(b, off, len);
            }

            public void close() throws IOException {
                try {
                    ZipFileSystem.this.myZos.closeEntry();
                }
                finally {
                    ZipFileSystem.this.myIsWriting.set(false);
                }
            }
        };
    }

    public void close() throws IOException {
        this.myZos.close();
    }
}

