/*
 * Decompiled with CFR 0.152.
 */
package io.github.surpsg.deltacoverage.report.textual;

import io.github.surpsg.deltacoverage.report.ReportBound;
import io.github.surpsg.deltacoverage.report.ReportType;
import io.github.surpsg.deltacoverage.report.textual.RawCoverageData;
import io.github.surpsg.deltacoverage.report.textual.RawCoverageDataProvider;
import io.github.surpsg.deltacoverage.report.textual.TextualReportFacade;
import io.github.surpsg.deltacoverage.report.textual.TextualReportRenderer;
import io.github.surpsg.deltacoverage.report.textual.TextualReportRendererFactory;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u001bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u0011J\u0012\u0010\u0014\u001a\u00020\u0015*\b\u0012\u0004\u0012\u00020\u00150\u0007H\u0002J\f\u0010\u0016\u001a\u00020\u0004*\u00020\u0017H\u0002J\u0014\u0010\u0018\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0019\u001a\u00020\nH\u0002J\u001a\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007*\u00020\u00152\u0006\u0010\u0010\u001a\u00020\u0011H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/github/surpsg/deltacoverage/report/textual/TextualReportFacade;", "", "()V", "BRANCHES_H", "", "CLASS_H", "HEADERS", "", "LINES_H", "MAX_CLASS_COLUMN_LENGTH", "", "NA_VALUE", "PERCENT_MULTIPLIER", "SHRINK_PLACEHOLDER", "SOURCE_H", "buildTitle", "buildContext", "Lio/github/surpsg/deltacoverage/report/textual/TextualReportFacade$BuildContext;", "generateReport", "", "computeTotal", "Lio/github/surpsg/deltacoverage/report/textual/RawCoverageData;", "formatToPercentage", "", "shrinkClassName", "maxLength", "toValuesCollection", "BuildContext", "delta-coverage-core"})
@SourceDebugExtension(value={"SMAP\nTextualReportFacade.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextualReportFacade.kt\nio/github/surpsg/deltacoverage/report/textual/TextualReportFacade\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ExtraStandard.kt\nio/github/surpsg/deltacoverage/lib/kotlin/ExtraStandardKt\n*L\n1#1,138:1\n1054#2:139\n1549#2:140\n1620#2,2:141\n1622#2:148\n1789#2,3:149\n3#3,5:143\n*S KotlinDebug\n*F\n+ 1 TextualReportFacade.kt\nio/github/surpsg/deltacoverage/report/textual/TextualReportFacade\n*L\n30#1:139\n48#1:140\n48#1:141,2\n48#1:148\n70#1:149,3\n54#1:143,5\n*E\n"})
public final class TextualReportFacade {
    @NotNull
    public static final TextualReportFacade INSTANCE = new TextualReportFacade();
    private static final int MAX_CLASS_COLUMN_LENGTH = 100;
    @NotNull
    private static final String SHRINK_PLACEHOLDER = "...";
    private static final int PERCENT_MULTIPLIER = 100;
    @NotNull
    private static final String NA_VALUE = "";
    @NotNull
    private static final String SOURCE_H = "Source";
    @NotNull
    private static final String CLASS_H = "Class";
    @NotNull
    private static final String LINES_H = "Lines";
    @NotNull
    private static final String BRANCHES_H = "Branches";
    @NotNull
    private static final List<String> HEADERS;

    private TextualReportFacade() {
    }

    /*
     * WARNING - void declaration
     */
    public final void generateReport(@NotNull BuildContext buildContext2) {
        void $this$sortedByDescending$iv;
        Intrinsics.checkNotNullParameter(buildContext2, "buildContext");
        List<RawCoverageData> rawCoverageData = buildContext2.getCoverageDataProvider().obtainData();
        Iterable iterable = rawCoverageData;
        boolean $i$f$sortedByDescending = false;
        List coverageDataValues2 = SequencesKt.toList(SequencesKt.map(CollectionsKt.asSequence(CollectionsKt.sortedWith($this$sortedByDescending$iv, new Comparator(){

            public final int compare(T a, T b) {
                RawCoverageData it = (RawCoverageData)b;
                boolean bl = false;
                Comparable comparable = Double.valueOf(it.getLinesRatio());
                it = (RawCoverageData)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues(comparable2, it.getLinesRatio());
            }
        })), (Function1)new Function1<RawCoverageData, List<? extends String>>(buildContext2){
            final /* synthetic */ BuildContext $buildContext;
            {
                this.$buildContext = $buildContext;
                super(1);
            }

            @NotNull
            public final List<String> invoke(@NotNull RawCoverageData it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return TextualReportFacade.access$toValuesCollection(TextualReportFacade.INSTANCE, it, this.$buildContext);
            }
        }));
        TextualReportRendererFactory.INSTANCE.getBy(buildContext2.getReportType()).render(TextualReportRenderer.Context.Companion.invoke((Function1<? super TextualReportRenderer.Context.Builder, Unit>)new Function1<TextualReportRenderer.Context.Builder, Unit>(buildContext2, rawCoverageData, coverageDataValues2){
            final /* synthetic */ BuildContext $buildContext;
            final /* synthetic */ List<RawCoverageData> $rawCoverageData;
            final /* synthetic */ List<List<String>> $coverageDataValues;
            {
                this.$buildContext = $buildContext;
                this.$rawCoverageData = $rawCoverageData;
                this.$coverageDataValues = $coverageDataValues;
                super(1);
            }

            public final void invoke(@NotNull TextualReportRenderer.Context.Builder $this$invoke) {
                Intrinsics.checkNotNullParameter($this$invoke, "$this$invoke");
                $this$invoke.setOutput(this.$buildContext.getOutputStream());
                $this$invoke.setTitle(TextualReportFacade.access$buildTitle(TextualReportFacade.INSTANCE, this.$buildContext));
                $this$invoke.setHeaders(TextualReportFacade.access$getHEADERS$p());
                $this$invoke.setFooter(TextualReportFacade.access$toValuesCollection(TextualReportFacade.INSTANCE, TextualReportFacade.access$computeTotal(TextualReportFacade.INSTANCE, this.$rawCoverageData), this.$buildContext));
                $this$invoke.setRows(this.$coverageDataValues);
            }
        }));
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> toValuesCollection(RawCoverageData $this$toValuesCollection, BuildContext buildContext2) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = HEADERS;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string;
            void header;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            switch (header) {
                case "Source": {
                    string = $this$toValuesCollection.getSource();
                    break;
                }
                case "Lines": {
                    string = INSTANCE.formatToPercentage($this$toValuesCollection.getLinesRatio());
                    break;
                }
                case "Class": {
                    void $this$applyIf$iv;
                    String string3 = $this$toValuesCollection.getAClass();
                    boolean condition$iv = buildContext2.getShrinkLongClassName();
                    boolean $i$f$applyIf = false;
                    if (condition$iv) {
                        void $this$toValuesCollection_u24lambda_u242_u24lambda_u241 = $this$applyIf$iv;
                        boolean bl2 = false;
                        string = INSTANCE.shrinkClassName((String)$this$toValuesCollection_u24lambda_u242_u24lambda_u241, 100);
                        break;
                    }
                    string = $this$applyIf$iv;
                    break;
                }
                case "Branches": {
                    if ($this$toValuesCollection.getBranchesTotal() == 0) {
                        string = NA_VALUE;
                        break;
                    }
                    string = INSTANCE.formatToPercentage($this$toValuesCollection.getBranchesRatio());
                    break;
                }
                default: {
                    throw new IllegalStateException(("Unknown header: " + (String)header).toString());
                }
            }
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final RawCoverageData computeTotal(List<RawCoverageData> $this$computeTotal) {
        void $this$fold$iv;
        Iterable iterable = $this$computeTotal;
        RawCoverageData initial$iv = RawCoverageData.Companion.newBlank(computeTotal.1.INSTANCE);
        boolean $i$f$fold = false;
        RawCoverageData accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void p1;
            RawCoverageData rawCoverageData = (RawCoverageData)element$iv;
            RawCoverageData p0 = accumulator$iv;
            boolean bl = false;
            accumulator$iv = p0.merge((RawCoverageData)p1);
        }
        return accumulator$iv;
    }

    private final String formatToPercentage(double $this$formatToPercentage) {
        float percents = (float)$this$formatToPercentage * (float)100;
        String pattern = percents % 1.0f == 0.0f ? "%.0f" : "%.2f";
        StringBuilder stringBuilder = new StringBuilder();
        String string = pattern;
        Object[] objectArray = new Object[]{Float.valueOf(percents)};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue(string2, "format(...)");
        return stringBuilder.append(string2).append('%').toString();
    }

    private final String shrinkClassName(String $this$shrinkClassName, int maxLength) {
        String string;
        if ($this$shrinkClassName.length() > maxLength) {
            int startIndex = $this$shrinkClassName.length() - maxLength + 3;
            IntRange keepRange = RangesKt.until(startIndex, $this$shrinkClassName.length());
            string = SHRINK_PLACEHOLDER + StringsKt.substring($this$shrinkClassName, keepRange);
        } else {
            string = $this$shrinkClassName;
        }
        return string;
    }

    private final String buildTitle(BuildContext buildContext2) {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[buildContext2.getReportBound().ordinal()]) {
            case 1: {
                string = "Delta Coverage Stats";
                break;
            }
            case 2: {
                string = "Total Coverage Stats";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    public static final /* synthetic */ List access$toValuesCollection(TextualReportFacade $this, RawCoverageData $receiver, BuildContext buildContext2) {
        return $this.toValuesCollection($receiver, buildContext2);
    }

    public static final /* synthetic */ String access$buildTitle(TextualReportFacade $this, BuildContext buildContext2) {
        return $this.buildTitle(buildContext2);
    }

    public static final /* synthetic */ List access$getHEADERS$p() {
        return HEADERS;
    }

    public static final /* synthetic */ RawCoverageData access$computeTotal(TextualReportFacade $this, List $receiver) {
        return $this.computeTotal($receiver);
    }

    static {
        String[] stringArray = new String[]{SOURCE_H, CLASS_H, LINES_H, BRANCHES_H};
        HEADERS = CollectionsKt.listOf(stringArray);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0002\u0017\u0018B/\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0019"}, d2={"Lio/github/surpsg/deltacoverage/report/textual/TextualReportFacade$BuildContext;", "", "reportType", "Lio/github/surpsg/deltacoverage/report/ReportType;", "reportBound", "Lio/github/surpsg/deltacoverage/report/ReportBound;", "coverageDataProvider", "Lio/github/surpsg/deltacoverage/report/textual/RawCoverageDataProvider;", "outputStream", "Ljava/io/OutputStream;", "shrinkLongClassName", "", "(Lio/github/surpsg/deltacoverage/report/ReportType;Lio/github/surpsg/deltacoverage/report/ReportBound;Lio/github/surpsg/deltacoverage/report/textual/RawCoverageDataProvider;Ljava/io/OutputStream;Z)V", "getCoverageDataProvider", "()Lio/github/surpsg/deltacoverage/report/textual/RawCoverageDataProvider;", "getOutputStream", "()Ljava/io/OutputStream;", "getReportBound", "()Lio/github/surpsg/deltacoverage/report/ReportBound;", "getReportType", "()Lio/github/surpsg/deltacoverage/report/ReportType;", "getShrinkLongClassName", "()Z", "Builder", "Companion", "delta-coverage-core"})
    public static final class BuildContext {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final ReportType reportType;
        @NotNull
        private final ReportBound reportBound;
        @NotNull
        private final RawCoverageDataProvider coverageDataProvider;
        @NotNull
        private final OutputStream outputStream;
        private final boolean shrinkLongClassName;

        private BuildContext(ReportType reportType, ReportBound reportBound, RawCoverageDataProvider coverageDataProvider, OutputStream outputStream, boolean shrinkLongClassName) {
            this.reportType = reportType;
            this.reportBound = reportBound;
            this.coverageDataProvider = coverageDataProvider;
            this.outputStream = outputStream;
            this.shrinkLongClassName = shrinkLongClassName;
            ReportType[] reportTypeArray = new ReportType[]{ReportType.CONSOLE, ReportType.MARKDOWN};
            Set<ReportType> supportedTypes = SetsKt.setOf(reportTypeArray);
            if (!supportedTypes.contains((Object)this.reportType)) {
                boolean bl = false;
                String string = "Supports only " + supportedTypes + " types";
                throw new IllegalArgumentException(string.toString());
            }
        }

        @NotNull
        public final ReportType getReportType() {
            return this.reportType;
        }

        @NotNull
        public final ReportBound getReportBound() {
            return this.reportBound;
        }

        @NotNull
        public final RawCoverageDataProvider getCoverageDataProvider() {
            return this.coverageDataProvider;
        }

        @NotNull
        public final OutputStream getOutputStream() {
            return this.outputStream;
        }

        public final boolean getShrinkLongClassName() {
            return this.shrinkLongClassName;
        }

        public /* synthetic */ BuildContext(ReportType reportType, ReportBound reportBound, RawCoverageDataProvider coverageDataProvider, OutputStream outputStream, boolean shrinkLongClassName, DefaultConstructorMarker $constructor_marker) {
            this(reportType, reportBound, coverageDataProvider, outputStream, shrinkLongClassName);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010!\u001a\u00020\"R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\u0016X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u0006#"}, d2={"Lio/github/surpsg/deltacoverage/report/textual/TextualReportFacade$BuildContext$Builder;", "", "()V", "coverageDataProvider", "Lio/github/surpsg/deltacoverage/report/textual/RawCoverageDataProvider;", "getCoverageDataProvider", "()Lio/github/surpsg/deltacoverage/report/textual/RawCoverageDataProvider;", "setCoverageDataProvider", "(Lio/github/surpsg/deltacoverage/report/textual/RawCoverageDataProvider;)V", "outputStream", "Ljava/io/OutputStream;", "getOutputStream", "()Ljava/io/OutputStream;", "setOutputStream", "(Ljava/io/OutputStream;)V", "reportBound", "Lio/github/surpsg/deltacoverage/report/ReportBound;", "getReportBound", "()Lio/github/surpsg/deltacoverage/report/ReportBound;", "setReportBound", "(Lio/github/surpsg/deltacoverage/report/ReportBound;)V", "reportType", "Lio/github/surpsg/deltacoverage/report/ReportType;", "getReportType", "()Lio/github/surpsg/deltacoverage/report/ReportType;", "setReportType", "(Lio/github/surpsg/deltacoverage/report/ReportType;)V", "shrinkLongClassName", "", "getShrinkLongClassName", "()Z", "setShrinkLongClassName", "(Z)V", "build", "Lio/github/surpsg/deltacoverage/report/textual/TextualReportFacade$BuildContext;", "delta-coverage-core"})
        public static final class Builder {
            public ReportType reportType;
            public ReportBound reportBound;
            public RawCoverageDataProvider coverageDataProvider;
            public OutputStream outputStream;
            private boolean shrinkLongClassName;

            @NotNull
            public final ReportType getReportType() {
                ReportType reportType = this.reportType;
                if (reportType != null) {
                    return reportType;
                }
                Intrinsics.throwUninitializedPropertyAccessException("reportType");
                return null;
            }

            public final void setReportType(@NotNull ReportType reportType) {
                Intrinsics.checkNotNullParameter((Object)reportType, "<set-?>");
                this.reportType = reportType;
            }

            @NotNull
            public final ReportBound getReportBound() {
                ReportBound reportBound = this.reportBound;
                if (reportBound != null) {
                    return reportBound;
                }
                Intrinsics.throwUninitializedPropertyAccessException("reportBound");
                return null;
            }

            public final void setReportBound(@NotNull ReportBound reportBound) {
                Intrinsics.checkNotNullParameter((Object)reportBound, "<set-?>");
                this.reportBound = reportBound;
            }

            @NotNull
            public final RawCoverageDataProvider getCoverageDataProvider() {
                RawCoverageDataProvider rawCoverageDataProvider = this.coverageDataProvider;
                if (rawCoverageDataProvider != null) {
                    return rawCoverageDataProvider;
                }
                Intrinsics.throwUninitializedPropertyAccessException("coverageDataProvider");
                return null;
            }

            public final void setCoverageDataProvider(@NotNull RawCoverageDataProvider rawCoverageDataProvider) {
                Intrinsics.checkNotNullParameter(rawCoverageDataProvider, "<set-?>");
                this.coverageDataProvider = rawCoverageDataProvider;
            }

            @NotNull
            public final OutputStream getOutputStream() {
                OutputStream outputStream = this.outputStream;
                if (outputStream != null) {
                    return outputStream;
                }
                Intrinsics.throwUninitializedPropertyAccessException("outputStream");
                return null;
            }

            public final void setOutputStream(@NotNull OutputStream outputStream) {
                Intrinsics.checkNotNullParameter(outputStream, "<set-?>");
                this.outputStream = outputStream;
            }

            public final boolean getShrinkLongClassName() {
                return this.shrinkLongClassName;
            }

            public final void setShrinkLongClassName(boolean bl) {
                this.shrinkLongClassName = bl;
            }

            @NotNull
            public final BuildContext build() {
                return new BuildContext(this.getReportType(), this.getReportBound(), this.getCoverageDataProvider(), this.getOutputStream(), this.shrinkLongClassName, null);
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0017\u0010\u0005\u001a\u0013\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\u0002\b\tH\u0086\u0002\u00a8\u0006\n"}, d2={"Lio/github/surpsg/deltacoverage/report/textual/TextualReportFacade$BuildContext$Companion;", "", "()V", "invoke", "Lio/github/surpsg/deltacoverage/report/textual/TextualReportFacade$BuildContext;", "block", "Lkotlin/Function1;", "Lio/github/surpsg/deltacoverage/report/textual/TextualReportFacade$BuildContext$Builder;", "", "Lkotlin/ExtensionFunctionType;", "delta-coverage-core"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final BuildContext invoke(@NotNull Function1<? super Builder, Unit> block) {
                Intrinsics.checkNotNullParameter(block, "block");
                Builder builder = new Builder();
                block.invoke(builder);
                return builder.build();
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ReportBound.values().length];
            try {
                nArray[ReportBound.DELTA_REPORT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReportBound.FULL_REPORT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

