/*
 * Decompiled with CFR 0.152.
 */
package io.github.surpsg.deltacoverage.report.intellij.verifier;

import com.intellij.rt.coverage.verify.TargetProcessor;
import com.intellij.rt.coverage.verify.Verifier;
import com.intellij.rt.coverage.verify.api.Counter;
import io.github.surpsg.deltacoverage.config.CoverageEntity;
import io.github.surpsg.deltacoverage.report.intellij.verifier.CoverageRuleWithThreshold;
import io.github.surpsg.deltacoverage.report.intellij.verifier.CoverageVerifier;
import io.github.surpsg.deltacoverage.report.intellij.verifier.ViolationResolveContext;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\f\u0010\u001a\u001a\u00020\u001b*\u00020\u000fH\u0002J\f\u0010\u001c\u001a\u00020\u001d*\u00020\u0014H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001f"}, d2={"Lio/github/surpsg/deltacoverage/report/intellij/verifier/CoverageViolationsCollector;", "Lcom/intellij/rt/coverage/verify/TargetProcessor$Consumer;", "rule", "Lio/github/surpsg/deltacoverage/report/intellij/verifier/CoverageRuleWithThreshold;", "(Lio/github/surpsg/deltacoverage/report/intellij/verifier/CoverageRuleWithThreshold;)V", "foundViolations", "", "Lio/github/surpsg/deltacoverage/report/intellij/verifier/CoverageVerifier$Violation;", "violations", "", "getViolations", "()Ljava/util/List;", "addViolation", "", "counter", "Lcom/intellij/rt/coverage/verify/Verifier$CollectedCoverage$Counter;", "buildViolationResolveContext", "Lio/github/surpsg/deltacoverage/report/intellij/verifier/ViolationResolveContext;", "collectedCoverageCounter", "coverageEntity", "Lio/github/surpsg/deltacoverage/config/CoverageEntity;", "consume", "name", "", "coverage", "Lcom/intellij/rt/coverage/verify/Verifier$CollectedCoverage;", "calculateTotal", "", "toVerifierCounter", "Lcom/intellij/rt/coverage/verify/api/Counter;", "Companion", "delta-coverage-core"})
public final class CoverageViolationsCollector
implements TargetProcessor.Consumer {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final CoverageRuleWithThreshold rule;
    @NotNull
    private final List<CoverageVerifier.Violation> foundViolations;
    @NotNull
    private final List<CoverageVerifier.Violation> violations;
    @NotNull
    private static final Logger log;

    public CoverageViolationsCollector(@NotNull CoverageRuleWithThreshold rule) {
        Intrinsics.checkNotNullParameter(rule, "rule");
        this.rule = rule;
        this.foundViolations = new ArrayList();
        this.violations = this.foundViolations;
    }

    @NotNull
    public final List<CoverageVerifier.Violation> getViolations() {
        return this.violations;
    }

    @Override
    public void consume(@NotNull String name, @NotNull Verifier.CollectedCoverage coverage) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(coverage, "coverage");
        Verifier.CollectedCoverage.Counter counter = this.toVerifierCounter(this.rule.getCoverageEntity()).getCounter(coverage);
        Intrinsics.checkNotNullExpressionValue(counter, "getCounter(...)");
        Verifier.CollectedCoverage.Counter counter2 = counter;
        ViolationResolveContext violationResolveContext = this.buildViolationResolveContext(counter2, this.rule.getCoverageEntity());
        if (violationResolveContext.isIgnoredByThreshold()) {
            Object[] objectArray = new Object[]{violationResolveContext.getCoverageEntity(), violationResolveContext.getThresholdCount(), violationResolveContext.getTotalCount()};
            log.info("Coverage violation of {} was ignored because threshold={} but total={}", objectArray);
        } else {
            this.addViolation(counter2);
        }
    }

    private final void addViolation(Verifier.CollectedCoverage.Counter counter) {
        BigDecimal bigDecimal = this.rule.getValueType().getValue(counter);
        if (bigDecimal == null) {
            return;
        }
        BigDecimal actualValue = bigDecimal;
        if (actualValue.compareTo(this.rule.getMin()) < 0) {
            ((Collection)this.foundViolations).add(new CoverageVerifier.Violation(this.rule.getCoverageEntity().name(), this.rule.getMin().doubleValue(), actualValue.doubleValue()));
        }
    }

    private final ViolationResolveContext buildViolationResolveContext(Verifier.CollectedCoverage.Counter collectedCoverageCounter, CoverageEntity coverageEntity) {
        ViolationResolveContext violationResolveContext;
        Integer n = this.rule.getThreshold();
        if (n != null) {
            int threshold = ((Number)n).intValue();
            boolean bl = false;
            violationResolveContext = new ViolationResolveContext(coverageEntity, threshold, this.calculateTotal(collectedCoverageCounter));
        } else {
            violationResolveContext = ViolationResolveContext.Companion.getNO_IGNORE_VIOLATION_CONTEXT();
        }
        return violationResolveContext;
    }

    private final long calculateTotal(Verifier.CollectedCoverage.Counter $this$calculateTotal) {
        return $this$calculateTotal.missed + $this$calculateTotal.covered;
    }

    private final Counter toVerifierCounter(CoverageEntity $this$toVerifierCounter) {
        Counter counter;
        switch (WhenMappings.$EnumSwitchMapping$0[$this$toVerifierCounter.ordinal()]) {
            case 1: {
                counter = Counter.INSTRUCTION;
                break;
            }
            case 2: {
                counter = Counter.BRANCH;
                break;
            }
            case 3: {
                counter = Counter.LINE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return counter;
    }

    static {
        Logger logger = LoggerFactory.getLogger(CoverageViolationsCollector.class);
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        log = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lio/github/surpsg/deltacoverage/report/intellij/verifier/CoverageViolationsCollector$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "delta-coverage-core"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CoverageEntity.values().length];
            try {
                nArray[CoverageEntity.INSTRUCTION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CoverageEntity.BRANCH.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CoverageEntity.LINE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

