/*
 * Decompiled with CFR 0.152.
 */
package io.github.surpsg.deltacoverage.report;

import io.github.surpsg.deltacoverage.CoverageEngine;
import io.github.surpsg.deltacoverage.config.DeltaCoverageConfig;
import io.github.surpsg.deltacoverage.diff.DiffSource;
import io.github.surpsg.deltacoverage.diff.DiffSourceKt;
import io.github.surpsg.deltacoverage.report.DeltaReportGeneratorFacade;
import io.github.surpsg.deltacoverage.report.ReportContext;
import io.github.surpsg.deltacoverage.report.intellij.IntellijDeltaReportGeneratorFacade;
import io.github.surpsg.deltacoverage.report.jacoco.JacocoDeltaReportGeneratorFacade;
import java.io.File;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lio/github/surpsg/deltacoverage/report/DeltaReportFacadeFactory;", "", "()V", "buildFacade", "Lio/github/surpsg/deltacoverage/report/DeltaReportGeneratorFacade;", "projectRoot", "Ljava/io/File;", "coverageEngine", "Lio/github/surpsg/deltacoverage/CoverageEngine;", "deltaCoverageConfig", "Lio/github/surpsg/deltacoverage/config/DeltaCoverageConfig;", "delta-coverage-core"})
public final class DeltaReportFacadeFactory {
    @NotNull
    public static final DeltaReportFacadeFactory INSTANCE = new DeltaReportFacadeFactory();

    private DeltaReportFacadeFactory() {
    }

    @NotNull
    public final DeltaReportGeneratorFacade buildFacade(@NotNull File projectRoot, @NotNull CoverageEngine coverageEngine, @NotNull DeltaCoverageConfig deltaCoverageConfig) {
        DeltaReportGeneratorFacade deltaReportGeneratorFacade;
        Intrinsics.checkNotNullParameter(projectRoot, "projectRoot");
        Intrinsics.checkNotNullParameter((Object)coverageEngine, "coverageEngine");
        Intrinsics.checkNotNullParameter(deltaCoverageConfig, "deltaCoverageConfig");
        DiffSource diffSource = DiffSourceKt.diffSourceFactory(projectRoot, deltaCoverageConfig.getDiffSourceConfig());
        ReportContext reportContext = new ReportContext(diffSource, deltaCoverageConfig);
        switch (WhenMappings.$EnumSwitchMapping$0[coverageEngine.ordinal()]) {
            case 1: {
                deltaReportGeneratorFacade = new JacocoDeltaReportGeneratorFacade(reportContext);
                break;
            }
            case 2: {
                deltaReportGeneratorFacade = new IntellijDeltaReportGeneratorFacade(reportContext);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return deltaReportGeneratorFacade;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CoverageEngine.values().length];
            try {
                nArray[CoverageEngine.JACOCO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CoverageEngine.INTELLIJ.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

