/*
 * Decompiled with CFR 0.152.
 */
package io.github.surpsg.deltacoverage.gradle.sources;

import io.github.surpsg.deltacoverage.CoverageEngine;
import io.github.surpsg.deltacoverage.gradle.DeltaCoverageConfiguration;
import io.github.surpsg.deltacoverage.gradle.sources.SourceType;
import io.github.surpsg.deltacoverage.gradle.sources.filter.SourceFilter;
import io.github.surpsg.deltacoverage.gradle.sources.lookup.SourcesAutoLookup;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.model.ObjectFactory;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0001\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0003\u0012\u0013\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J \u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002J\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u0015"}, d2={"Lio/github/surpsg/deltacoverage/gradle/sources/SourcesResolver;", "", "()V", "getDeltaPluginConfiguredSource", "Lorg/gradle/api/file/FileCollection;", "sourceType", "Lio/github/surpsg/deltacoverage/gradle/sources/SourceType;", "deltaCoverageConfiguration", "Lio/github/surpsg/deltacoverage/gradle/DeltaCoverageConfiguration;", "obtainFilterSource", "context", "Lio/github/surpsg/deltacoverage/gradle/sources/SourcesResolver$Context;", "provider", "Lio/github/surpsg/deltacoverage/gradle/sources/SourcesResolver$Provider;", "resolvedSources", "resolve", "throwMissedConfigurationException", "", "Companion", "Context", "Provider", "delta-coverage-gradle"})
public final class SourcesResolver {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger log;

    @NotNull
    public final FileCollection resolve(@NotNull Context context) {
        Pair<Provider, FileCollection> pair;
        Intrinsics.checkNotNullParameter(context, "context");
        SourceType sourceType = context.getSourceType();
        FileCollection deltaPluginConfiguredSource = this.getDeltaPluginConfiguredSource(context.getSourceType(), context.getConfig());
        if (deltaPluginConfiguredSource == null) {
            log.debug("{} is not set manually. Attempting to autoconfigure from {} coverage plugin...", (Object)context.getSourceType(), (Object)context.getProvider().getPluginName());
            pair = TuplesKt.to(context.getProvider(), context.getSourcesAutoLookup().lookup(sourceType));
        } else {
            pair = TuplesKt.to(Provider.DELTA_COVERAGE, deltaPluginConfiguredSource);
        }
        Pair<Provider, FileCollection> pair2 = pair;
        Provider provider = pair2.component1();
        FileCollection resolvedSources = pair2.component2();
        if (resolvedSources.isEmpty()) {
            this.throwMissedConfigurationException(provider, sourceType);
            throw new KotlinNothingValueException();
        }
        Object[] objectArray = new Object[]{sourceType.getSourceConfigurationPath(), sourceType.resourceName(provider), provider.getPluginName()};
        log.debug("{}({}) files were configured from {}", objectArray);
        return this.obtainFilterSource(context, provider, resolvedSources);
    }

    private final FileCollection obtainFilterSource(Context context, Provider provider, FileCollection resolvedSources) {
        SourceFilter.InputSource sourcesToFilter = new SourceFilter.InputSource(resolvedSources, provider, context.getSourceType());
        return SourceFilter.Companion.build(context.getConfig(), context.getSourceType()).filter(sourcesToFilter);
    }

    private final Void throwMissedConfigurationException(Provider provider, SourceType sourceType) {
        String errorMessage = provider == Provider.DELTA_COVERAGE ? '\'' + sourceType.getSourceConfigurationPath() + "' file collection is empty." : '\'' + sourceType.getSourceConfigurationPath() + "' is not configured.";
        throw new IllegalStateException(errorMessage.toString());
    }

    private final FileCollection getDeltaPluginConfiguredSource(SourceType sourceType, DeltaCoverageConfiguration deltaCoverageConfiguration) {
        FileCollection fileCollection;
        switch (WhenMappings.$EnumSwitchMapping$0[sourceType.ordinal()]) {
            case 1: {
                fileCollection = deltaCoverageConfiguration.getClassesDirs();
                break;
            }
            case 2: {
                fileCollection = deltaCoverageConfiguration.getSrcDirs();
                break;
            }
            case 3: {
                fileCollection = deltaCoverageConfiguration.getCoverageBinaryFiles();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return fileCollection;
    }

    static {
        Logger logger = LoggerFactory.getLogger(SourcesResolver.class);
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        log = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lio/github/surpsg/deltacoverage/gradle/sources/SourcesResolver$Companion;", "", "()V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "delta-coverage-gradle"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0001\u0015B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0016"}, d2={"Lio/github/surpsg/deltacoverage/gradle/sources/SourcesResolver$Context;", "", "sourcesAutoLookup", "Lio/github/surpsg/deltacoverage/gradle/sources/lookup/SourcesAutoLookup;", "sourceType", "Lio/github/surpsg/deltacoverage/gradle/sources/SourceType;", "builder", "Lio/github/surpsg/deltacoverage/gradle/sources/SourcesResolver$Context$Builder;", "(Lio/github/surpsg/deltacoverage/gradle/sources/lookup/SourcesAutoLookup;Lio/github/surpsg/deltacoverage/gradle/sources/SourceType;Lio/github/surpsg/deltacoverage/gradle/sources/SourcesResolver$Context$Builder;)V", "config", "Lio/github/surpsg/deltacoverage/gradle/DeltaCoverageConfiguration;", "getConfig", "()Lio/github/surpsg/deltacoverage/gradle/DeltaCoverageConfiguration;", "provider", "Lio/github/surpsg/deltacoverage/gradle/sources/SourcesResolver$Provider;", "getProvider", "()Lio/github/surpsg/deltacoverage/gradle/sources/SourcesResolver$Provider;", "getSourceType", "()Lio/github/surpsg/deltacoverage/gradle/sources/SourceType;", "getSourcesAutoLookup", "()Lio/github/surpsg/deltacoverage/gradle/sources/lookup/SourcesAutoLookup;", "Builder", "delta-coverage-gradle"})
    public static final class Context {
        @NotNull
        private final SourcesAutoLookup sourcesAutoLookup;
        @NotNull
        private final SourceType sourceType;
        @NotNull
        private final Builder builder;

        private Context(SourcesAutoLookup sourcesAutoLookup, SourceType sourceType, Builder builder) {
            this.sourcesAutoLookup = sourcesAutoLookup;
            this.sourceType = sourceType;
            this.builder = builder;
        }

        @NotNull
        public final SourcesAutoLookup getSourcesAutoLookup() {
            return this.sourcesAutoLookup;
        }

        @NotNull
        public final SourceType getSourceType() {
            return this.sourceType;
        }

        @NotNull
        public final DeltaCoverageConfiguration getConfig() {
            return this.builder.getConfig();
        }

        @NotNull
        public final Provider getProvider() {
            Object object = this.builder.getConfig().getCoverage().getEngine().get();
            Intrinsics.checkNotNullExpressionValue(object, "get(...)");
            return Provider.Companion.fromEngine((CoverageEngine)((Object)object));
        }

        public /* synthetic */ Context(SourcesAutoLookup sourcesAutoLookup, SourceType sourceType, Builder builder, DefaultConstructorMarker $constructor_marker) {
            this(sourcesAutoLookup, sourceType, builder);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lio/github/surpsg/deltacoverage/gradle/sources/SourcesResolver$Context$Builder;", "", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "project", "Lorg/gradle/api/Project;", "config", "Lio/github/surpsg/deltacoverage/gradle/DeltaCoverageConfiguration;", "(Lorg/gradle/api/model/ObjectFactory;Lorg/gradle/api/Project;Lio/github/surpsg/deltacoverage/gradle/DeltaCoverageConfiguration;)V", "getConfig", "()Lio/github/surpsg/deltacoverage/gradle/DeltaCoverageConfiguration;", "getProject", "()Lorg/gradle/api/Project;", "build", "Lio/github/surpsg/deltacoverage/gradle/sources/SourcesResolver$Context;", "sourceType", "Lio/github/surpsg/deltacoverage/gradle/sources/SourceType;", "Companion", "delta-coverage-gradle"})
        public static final class Builder {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @NotNull
            private final ObjectFactory objectFactory;
            @NotNull
            private final Project project;
            @NotNull
            private final DeltaCoverageConfiguration config;

            private Builder(ObjectFactory objectFactory, Project project, DeltaCoverageConfiguration config) {
                this.objectFactory = objectFactory;
                this.project = project;
                this.config = config;
            }

            @NotNull
            public final Project getProject() {
                return this.project;
            }

            @NotNull
            public final DeltaCoverageConfiguration getConfig() {
                return this.config;
            }

            @NotNull
            public final Context build(@NotNull SourceType sourceType) {
                Intrinsics.checkNotNullParameter((Object)sourceType, "sourceType");
                Object object = this.config.getCoverage().getEngine().get();
                Intrinsics.checkNotNullExpressionValue(object, "get(...)");
                SourcesAutoLookup sourceAutoLookup = SourcesAutoLookup.Companion.build((CoverageEngine)((Object)object), new SourcesAutoLookup.Context(this.project, this.config, this.objectFactory));
                return new Context(sourceAutoLookup, sourceType, this, null);
            }

            public /* synthetic */ Builder(ObjectFactory objectFactory, Project project, DeltaCoverageConfiguration config, DefaultConstructorMarker $constructor_marker) {
                this(objectFactory, project, config);
            }

            @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lio/github/surpsg/deltacoverage/gradle/sources/SourcesResolver$Context$Builder$Companion;", "", "()V", "newBuilder", "Lio/github/surpsg/deltacoverage/gradle/sources/SourcesResolver$Context$Builder;", "project", "Lorg/gradle/api/Project;", "objectFactory", "Lorg/gradle/api/model/ObjectFactory;", "config", "Lio/github/surpsg/deltacoverage/gradle/DeltaCoverageConfiguration;", "delta-coverage-gradle"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final Builder newBuilder(@NotNull Project project, @NotNull ObjectFactory objectFactory, @NotNull DeltaCoverageConfiguration config) {
                    Intrinsics.checkNotNullParameter(project, "project");
                    Intrinsics.checkNotNullParameter(objectFactory, "objectFactory");
                    Intrinsics.checkNotNullParameter(config, "config");
                    return new Builder(objectFactory, project, config, null);
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u0000 \n2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\nB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\u000b"}, d2={"Lio/github/surpsg/deltacoverage/gradle/sources/SourcesResolver$Provider;", "", "pluginName", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getPluginName", "()Ljava/lang/String;", "JACOCO", "KOVER", "DELTA_COVERAGE", "Companion", "delta-coverage-gradle"})
    public static final class Provider
    extends Enum<Provider> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String pluginName;
        public static final /* enum */ Provider JACOCO;
        public static final /* enum */ Provider KOVER;
        public static final /* enum */ Provider DELTA_COVERAGE;
        private static final /* synthetic */ Provider[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Provider(String pluginName) {
            this.pluginName = pluginName;
        }

        @NotNull
        public final String getPluginName() {
            return this.pluginName;
        }

        public static Provider[] values() {
            return (Provider[])$VALUES.clone();
        }

        public static Provider valueOf(String value) {
            return Enum.valueOf(Provider.class, value);
        }

        @NotNull
        public static EnumEntries<Provider> getEntries() {
            return $ENTRIES;
        }

        static {
            JACOCO = new Provider("JaCoCo");
            KOVER = new Provider("Kover");
            DELTA_COVERAGE = new Provider("Delta-Coverage");
            $VALUES = providerArray = new Provider[]{Provider.JACOCO, Provider.KOVER, Provider.DELTA_COVERAGE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lio/github/surpsg/deltacoverage/gradle/sources/SourcesResolver$Provider$Companion;", "", "()V", "fromEngine", "Lio/github/surpsg/deltacoverage/gradle/sources/SourcesResolver$Provider;", "engine", "Lio/github/surpsg/deltacoverage/CoverageEngine;", "delta-coverage-gradle"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Provider fromEngine(@NotNull CoverageEngine engine) {
                Provider provider;
                Intrinsics.checkNotNullParameter((Object)engine, "engine");
                switch (WhenMappings.$EnumSwitchMapping$0[engine.ordinal()]) {
                    case 1: {
                        provider = JACOCO;
                        break;
                    }
                    case 2: {
                        provider = KOVER;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return provider;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }

            @Metadata(mv={1, 9, 0}, k=3, xi=48)
            public final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[CoverageEngine.values().length];
                    try {
                        nArray[CoverageEngine.JACOCO.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[CoverageEngine.INTELLIJ.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SourceType.values().length];
            try {
                nArray[SourceType.CLASSES.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SourceType.SOURCES.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SourceType.COVERAGE_BINARIES.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

