/*
 * Decompiled with CFR 0.152.
 */
package io.github.surpsg.deltacoverage.diff;

import io.github.surpsg.deltacoverage.config.DiffSourceConfig;
import io.github.surpsg.deltacoverage.diff.DiffSource;
import io.github.surpsg.deltacoverage.diff.FileDiffSource;
import io.github.surpsg.deltacoverage.diff.GitDiffSource;
import io.github.surpsg.deltacoverage.diff.UrlDiffSource;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"DEFAULT_PATCH_FILE_NAME", "", "diffSourceFactory", "Lio/github/surpsg/deltacoverage/diff/DiffSource;", "projectRoot", "Ljava/io/File;", "diffSourceConfig", "Lio/github/surpsg/deltacoverage/config/DiffSourceConfig;", "delta-coverage-core"})
public final class DiffSourceKt {
    @NotNull
    public static final String DEFAULT_PATCH_FILE_NAME = "diff.patch";

    @NotNull
    public static final DiffSource diffSourceFactory(@NotNull File projectRoot, @NotNull DiffSourceConfig diffSourceConfig) {
        DiffSource diffSource;
        Intrinsics.checkNotNullParameter(projectRoot, "projectRoot");
        Intrinsics.checkNotNullParameter(diffSourceConfig, "diffSourceConfig");
        if (!StringsKt.isBlank(diffSourceConfig.getFile())) {
            diffSource = new FileDiffSource(diffSourceConfig.getFile());
        } else if (!StringsKt.isBlank(diffSourceConfig.getUrl())) {
            diffSource = new UrlDiffSource(diffSourceConfig.getUrl());
        } else if (!StringsKt.isBlank(diffSourceConfig.getDiffBase())) {
            diffSource = new GitDiffSource(projectRoot, diffSourceConfig.getDiffBase());
        } else {
            throw new IllegalStateException("Expected Git configuration or file or URL diff source but all are blank".toString());
        }
        return diffSource;
    }
}

