/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.verify.api;

import com.intellij.rt.coverage.verify.Verifier;
import java.math.BigDecimal;
import java.math.RoundingMode;

public enum ValueType {
    MISSED,
    COVERED,
    MISSED_RATE,
    COVERED_RATE;


    public BigDecimal getValue(Verifier.CollectedCoverage.Counter counter) {
        switch (this) {
            case MISSED: {
                return new BigDecimal(counter.missed);
            }
            case COVERED: {
                return new BigDecimal(counter.covered);
            }
            case MISSED_RATE: {
                BigDecimal missed = new BigDecimal(counter.missed);
                BigDecimal total = new BigDecimal(counter.covered + counter.missed);
                if (total.equals(BigDecimal.ZERO)) {
                    return null;
                }
                return missed.divide(total, 6, RoundingMode.HALF_UP);
            }
            case COVERED_RATE: {
                BigDecimal covered = new BigDecimal(counter.covered);
                BigDecimal total = new BigDecimal(counter.covered + counter.missed);
                if (total.equals(BigDecimal.ZERO)) {
                    return null;
                }
                return covered.divide(total, 6, RoundingMode.HALF_UP);
            }
        }
        throw new RuntimeException("Unexpected value " + (Object)((Object)this));
    }
}

