/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.util;

import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.util.ClassListSection;
import com.intellij.rt.coverage.util.CoverageIOUtil;
import com.intellij.rt.coverage.util.ErrorReporter;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;

public class UncoveredBranchesSection
extends ClassListSection {
    public int getId() {
        return 1;
    }

    public int getVersion() {
        return 0;
    }

    public boolean isEngaged(ProjectData projectData) {
        return projectData.isBranchCoverage();
    }

    protected void loadClass(DataInputStream in, ClassData classData, int version) throws IOException {
        for (Object object : classData.getLines()) {
            LineData line2 = (LineData)object;
            if (line2 == null || line2.getHits() > 0) continue;
            int jumpsNumber = CoverageIOUtil.readINT(in);
            for (int jumpId = 0; jumpId < jumpsNumber; ++jumpId) {
                line2.addJump(jumpId);
            }
            int switchesNumber = CoverageIOUtil.readINT(in);
            for (int switchId = 0; switchId < switchesNumber; ++switchId) {
                int keysLength = CoverageIOUtil.readINT(in);
                try {
                    int[] keys2 = new int[keysLength];
                    int k = 0;
                    while (k < keysLength) {
                        int n = k++;
                        keys2[n] = n;
                    }
                    line2.addSwitch(switchId, keys2);
                    continue;
                }
                catch (OutOfMemoryError e) {
                    ErrorReporter.error("OOM during " + classData + " class loading from report, cannot create switch with " + keysLength + " keys");
                    throw e;
                }
            }
            line2.fillArrays();
        }
    }

    protected void saveClass(ClassData classData, DataOutput out, int index) throws IOException {
        LineData lineData;
        int line2;
        LineData[] lines = (LineData[])classData.getLines();
        if (lines == null) {
            return;
        }
        for (line2 = 0; line2 < lines.length && ((lineData = lines[line2]) == null || lineData.getHits() != 0); ++line2) {
        }
        if (line2 == lines.length) {
            return;
        }
        CoverageIOUtil.writeINT(out, index);
        while (line2 < lines.length) {
            lineData = lines[line2];
            if (lineData != null && lineData.getHits() <= 0) {
                CoverageIOUtil.writeINT(out, lineData.jumpsCount());
                CoverageIOUtil.writeINT(out, lineData.switchesCount());
                for (int i = 0; i < lineData.switchesCount(); ++i) {
                    CoverageIOUtil.writeINT(out, lineData.getSwitchData(i).getHits().length);
                }
            }
            ++line2;
        }
    }
}

