/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.report.util;

import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.report.util.FileLocator;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SourceFileLocator
extends FileLocator {
    private final Map<String, List<File>> mySourceFiles = new HashMap<String, List<File>>();

    public SourceFileLocator(List<File> roots, ProjectData projectData) {
        super(roots);
        this.locateProjectSourceFiles(projectData);
    }

    @Override
    public List<File> locate(String fqName) {
        List<File> result = this.mySourceFiles.get(fqName);
        if (result != null) {
            return result;
        }
        return Collections.emptyList();
    }

    private void locateProjectSourceFiles(ProjectData projectData) {
        HashMap<String, List<String>> lostSources = new HashMap<String, List<String>>();
        for (ClassData classData : projectData.getClassesCollection()) {
            if (classData == null) continue;
            String className = classData.getName();
            String fileName = classData.getSource();
            if (fileName == null || className == null) continue;
            int packageIndex = className.lastIndexOf(46);
            List<File> candidates = this.locateFile(packageIndex < 0 ? "" : className.substring(0, packageIndex), fileName);
            if (!candidates.isEmpty()) {
                this.mySourceFiles.put(className, candidates);
                continue;
            }
            ArrayList<String> classes = (ArrayList<String>)lostSources.get(fileName);
            if (classes == null) {
                classes = new ArrayList<String>();
                lostSources.put(fileName, classes);
            }
            classes.add(className);
        }
        this.searchForLostSources(lostSources);
    }

    private void searchForLostSources(Map<String, List<String>> lostSources) {
        if (lostSources.isEmpty()) {
            return;
        }
        for (File root : this.myRoots) {
            ArrayList<File> stack = new ArrayList<File>();
            stack.add(root);
            while (!stack.isEmpty()) {
                File[] children;
                File file = (File)stack.remove(stack.size() - 1);
                if (file.isFile()) {
                    this.checkSourceForClass(lostSources, file);
                    continue;
                }
                if (!file.isDirectory() || (children = file.listFiles()) == null) continue;
                stack.addAll(Arrays.asList(children));
            }
        }
    }

    private void checkSourceForClass(Map<String, List<String>> lostSources, File file) {
        List<String> classes = lostSources.get(file.getName());
        if (classes == null) {
            return;
        }
        for (String className : classes) {
            List<File> classSources = this.mySourceFiles.get(className);
            if (classSources == null) {
                classSources = new ArrayList<File>();
                this.mySourceFiles.put(className, classSources);
            }
            classSources.add(file);
        }
    }
}

