/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.report.data;

import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.offline.RawHitsReport;
import com.intellij.rt.coverage.util.CoverageReport;
import com.intellij.rt.coverage.util.ErrorReporter;
import com.intellij.rt.coverage.util.ProjectDataLoader;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.Nullable;

public class BinaryReport {
    private final File myDataFile;
    private final File mySourceMapFile;
    private byte myIsRawReport = (byte)2;

    public BinaryReport(File dataFile, @Nullable File sourceMapFile) {
        this.myDataFile = dataFile;
        this.mySourceMapFile = sourceMapFile;
    }

    public File getDataFile() {
        return this.myDataFile;
    }

    public boolean isRawHitsReport() {
        if (this.myIsRawReport <= 1) {
            return this.myIsRawReport == 1;
        }
        boolean isRaw = false;
        try {
            isRaw = RawHitsReport.isRawHitsFile(this.myDataFile);
        }
        catch (IOException e) {
            ErrorReporter.warn("Failed to check raw report file", e);
        }
        this.myIsRawReport = isRaw ? (byte)1 : 0;
        return isRaw;
    }

    @Nullable
    public File getSourceMapFile() {
        return this.mySourceMapFile;
    }

    public ProjectData loadData() {
        ProjectData data = ProjectDataLoader.load(this.myDataFile);
        if (this.mySourceMapFile != null) {
            try {
                CoverageReport.loadAndApplySourceMap(data, this.mySourceMapFile);
            }
            catch (IOException e) {
                ErrorReporter.warn("Error in processing source map file", e);
            }
        }
        return data;
    }
}

