/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters.branches;

import com.intellij.rt.coverage.instrumentation.data.InstrumentationData;
import com.intellij.rt.coverage.instrumentation.data.Key;
import com.intellij.rt.coverage.instrumentation.filters.lines.CoverageFilter;
import org.jetbrains.coverage.org.objectweb.asm.Label;

public class NotNullAssertionsFilter
extends CoverageFilter {
    private static final byte SEEN_NOTHING = 0;
    private static final byte DUP_SEEN = 1;
    private static final byte IFNONNULL_SEEN = 2;
    private static final byte PARAM_CONST_SEEN = 3;
    private static final byte ASSERTIONS_DISABLED_STATE = 5;
    private byte myState = 0;
    private boolean myHasLines;

    /*
     * WARNING - void declaration
     */
    public void visitLineNumber(int line2, Label start) {
        void var2_2;
        void var1_1;
        super.visitLineNumber((int)var1_1, (Label)var2_2);
        this.myHasLines = true;
    }

    /*
     * WARNING - void declaration
     */
    public void visitJumpInsn(int opcode, Label label) {
        void var1_1;
        super.visitJumpInsn(opcode, label);
        if (!this.myHasLines) {
            return;
        }
        if (this.myState == 5 && opcode == 154) {
            void var2_2;
            this.myState = 0;
            if (this.myContext.getJump((Label)var2_2) != null) {
                this.myContext.removeLastJump();
            }
        }
        if (this.myState == 1 && var1_1 == 199) {
            this.myState = (byte)2;
            return;
        }
        this.myState = 0;
    }

    /*
     * WARNING - void declaration
     */
    public void visitInsn(int opcode) {
        void var1_1;
        super.visitInsn(opcode);
        if (!this.myHasLines) {
            return;
        }
        if (opcode == 89) {
            this.myState = 1;
            return;
        }
        if (this.myState == 2 && (opcode >= 3 && opcode <= 8 || opcode == 16 || var1_1 == 17)) {
            this.myState = (byte)3;
            return;
        }
        this.myState = 0;
    }

    /*
     * WARNING - void declaration
     */
    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        void var3_3;
        void var1_1;
        void var2_2;
        super.visitFieldInsn(opcode, (String)var2_2, name, desc);
        if (!this.myHasLines) {
            return;
        }
        if (var1_1 == 178 && var3_3.equals("$assertionsDisabled")) {
            this.myState = (byte)5;
            return;
        }
        this.myState = 0;
    }

    /*
     * WARNING - void declaration
     */
    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        void var2_2;
        void var3_3;
        void var1_1;
        super.visitMethodInsn(opcode, owner, name, desc, itf);
        if (!this.myHasLines) {
            return;
        }
        if (this.myState == 3 && var1_1 == 184 && var3_3.startsWith("$$$reportNull$$$") && this.myContext.get(Key.CLASS_INTERNAL_NAME).equals(var2_2)) {
            this.myContext.removeLastJump();
        }
        this.myState = 0;
    }

    /*
     * WARNING - void declaration
     */
    public void visitLookupSwitchInsn(Label dflt, int[] keys2, Label[] labels) {
        void var3_3;
        void var2_2;
        void var1_1;
        super.visitLookupSwitchInsn((Label)var1_1, (int[])var2_2, (Label[])var3_3);
        this.setSeenNothingState();
    }

    /*
     * WARNING - void declaration
     */
    public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        void var3_3;
        void var2_2;
        void var1_1;
        super.visitTableSwitchInsn((int)var1_1, (int)var2_2, (Label)var3_3, labels);
        this.setSeenNothingState();
    }

    /*
     * WARNING - void declaration
     */
    public void visitIntInsn(int opcode, int operand) {
        void var2_2;
        void var1_1;
        super.visitIntInsn((int)var1_1, (int)var2_2);
        this.setSeenNothingState();
    }

    /*
     * WARNING - void declaration
     */
    public void visitVarInsn(int opcode, int var) {
        void var2_2;
        void var1_1;
        super.visitVarInsn((int)var1_1, (int)var2_2);
        this.setSeenNothingState();
    }

    /*
     * WARNING - void declaration
     */
    public void visitTypeInsn(int opcode, String type) {
        void var2_2;
        void var1_1;
        super.visitTypeInsn((int)var1_1, (String)var2_2);
        this.setSeenNothingState();
    }

    /*
     * WARNING - void declaration
     */
    public void visitLdcInsn(Object cst) {
        void var1_1;
        super.visitLdcInsn(var1_1);
        this.setSeenNothingState();
    }

    /*
     * WARNING - void declaration
     */
    public void visitIincInsn(int var, int increment) {
        void var2_2;
        void var1_1;
        super.visitIincInsn((int)var1_1, (int)var2_2);
        this.setSeenNothingState();
    }

    /*
     * WARNING - void declaration
     */
    public void visitMultiANewArrayInsn(String desc, int dims) {
        void var2_2;
        void var1_1;
        super.visitMultiANewArrayInsn((String)var1_1, (int)var2_2);
        this.setSeenNothingState();
    }

    private void setSeenNothingState() {
        if (this.myHasLines) {
            this.myState = 0;
        }
    }

    public boolean isApplicable(InstrumentationData context) {
        return true;
    }
}

