/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.util.CoverageIOUtil;
import com.intellij.rt.coverage.util.ErrorReporter;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CoverageArgs {
    public File dataFile;
    public boolean testTracking;
    public boolean calcUnloaded;
    public boolean mergeData;
    public boolean branchCoverage;
    public File sourceMap;
    public List<Pattern> includePatterns = new ArrayList<Pattern>();
    public List<Pattern> excludePatterns = new ArrayList<Pattern>();
    public List<Pattern> annotationsToIgnore = new ArrayList<Pattern>();

    CoverageArgs() {
    }

    /*
     * WARNING - void declaration
     */
    public static CoverageArgs fromString(String argsString) throws IllegalArgumentException {
        void var1_3;
        String string;
        String[] args2;
        File file = new File(argsString);
        if (file.isFile()) {
            try {
                args2 = CoverageArgs.readArgsFromFile(file);
            }
            catch (IOException e) {
                void var0_1;
                void var2_2;
                throw new IllegalArgumentException("Failed to read arguments from file: " + var2_2.getAbsolutePath(), (Throwable)var0_1);
            }
        } else {
            args2 = CoverageArgs.tokenize(string);
        }
        if (args2.length < 5) {
            throw new IllegalArgumentException("At least 5 arguments expected but " + args2.length + " found.\n'" + string + "'\nExpected arguments are:\n0) data file to save coverage result\n1) a flag to enable tracking per test coverage\n2) a flag to calculate coverage for unloaded classes\n3) a flag to use data file as initial coverage, also use it if several parallel processes are to write into one file\n4) a flag to run line coverage or branch coverage otherwise\n");
        }
        return CoverageArgs.fromString((String[])var1_3);
    }

    /*
     * WARNING - void declaration
     */
    private static CoverageArgs fromString(String[] args2) throws IllegalArgumentException {
        void var1_1;
        CoverageArgs result = new CoverageArgs();
        new CoverageArgs().dataFile = new File(args2[0]);
        result.testTracking = Boolean.parseBoolean(args2[1]);
        result.calcUnloaded = Boolean.parseBoolean(args2[2]);
        result.mergeData = Boolean.parseBoolean(args2[3]);
        result.branchCoverage = !Boolean.parseBoolean(args2[4]);
        ErrorReporter.suggestBasePath(result.dataFile.getParent());
        int i = 5;
        if (args2.length > 5 && Boolean.parseBoolean(args2[5])) {
            result.sourceMap = new File(args2[6]);
            i = 7;
        }
        if ((i = CoverageArgs.readPatterns(result.includePatterns, i, args2, "include")) < args2.length && "-exclude".equals(args2[i])) {
            i = CoverageArgs.readPatterns(result.excludePatterns, i + 1, args2, "exclude");
        }
        if (i < args2.length && "-excludeAnnotations".equals(args2[i])) {
            String[] stringArray;
            void var2_2;
            CoverageArgs.readPatterns(result.annotationsToIgnore, (int)(var2_2 + true), stringArray, "exclude annotations");
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static String[] tokenize(String argumentString) {
        void var1_1;
        StringBuilder stringBuilder;
        ArrayList<void> tokenizedArgs = new ArrayList<void>();
        StringBuilder currentArg = new StringBuilder();
        block4: for (int i = 0; i < argumentString.length(); ++i) {
            char c = argumentString.charAt(i);
            switch (c) {
                case ' ': 
                case ',': {
                    String arg = currentArg.toString();
                    if (!arg.isEmpty()) {
                        tokenizedArgs.add((void)stringBuilder);
                    }
                    stringBuilder = new StringBuilder();
                    continue block4;
                }
                case '\"': {
                    char d;
                    while (++i < argumentString.length() && (d = argumentString.charAt(i)) != '\"') {
                        stringBuilder.append(d);
                    }
                    continue block4;
                }
                default: {
                    void var4_5;
                    stringBuilder.append((char)var4_5);
                }
            }
        }
        String arg = stringBuilder.toString();
        if (!arg.isEmpty()) {
            void var3_4;
            tokenizedArgs.add(var3_4);
        }
        return var1_1.toArray(new String[0]);
    }

    /*
     * WARNING - void declaration
     */
    private static String[] readArgsFromFile(File file) throws IOException {
        void var1_2;
        ArrayList<String> result = new ArrayList<String>();
        BufferedReader reader = null;
        try {
            File file2;
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file2), "UTF-8"));
            while (reader.ready()) {
                result.add(reader.readLine());
            }
        }
        catch (Throwable throwable) {
            void var2_3;
            CoverageIOUtil.close((Closeable)var2_3);
            throw throwable;
        }
        CoverageIOUtil.close(reader);
        return var1_2.toArray(new String[0]);
    }

    /*
     * WARNING - void declaration
     */
    private static int readPatterns(List<Pattern> patterns, int i, String[] args2, String name) throws IllegalArgumentException {
        void var1_2;
        while (i < args2.length && !args2[i].startsWith("-")) {
            try {
                patterns.add(Pattern.compile(args2[i]));
            }
            catch (PatternSyntaxException ex) {
                void var0_1;
                throw new IllegalArgumentException("Problem occurred with " + name + " pattern " + args2[i] + ". This may cause no tests run and no coverage collected", (Throwable)var0_1);
            }
            ++i;
        }
        return (int)var1_2;
    }
}

