/*
 * Decompiled with CFR 0.152.
 */
package io.github.springboot.httpclient5.core.configure.async;

import io.github.springboot.httpclient5.core.config.HttpClient5Config;
import io.github.springboot.httpclient5.core.config.model.AsyncConnectionManagerConfigProperties;
import io.github.springboot.httpclient5.core.configure.ConfigurableConnPoolControl;
import io.github.springboot.httpclient5.core.configure.PoolingHttpClientConnectionManagerPostConfigurer;
import java.util.Set;
import java.util.concurrent.Future;
import lombok.Generated;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.TlsConfig;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.nio.AsyncConnectionEndpoint;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.function.Resolver;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.pool.PoolStats;
import org.apache.hc.core5.reactor.ConnectionInitiator;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class HttpAsyncClientConnectionManagerConfigurer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpAsyncClientConnectionManagerConfigurer.class);
    @Autowired
    private HttpClient5Config config;
    @Autowired
    private ObjectProvider<PoolingHttpClientConnectionManagerPostConfigurer> cmConfigurers;

    @Bean
    public PoolingAsyncClientConnectionManager defaultAsyncConnectionManager(@Autowired(required=false) ObjectProvider<SchemePortResolver> schemePortResolverProvider) {
        AsyncConnectionManagerConfigProperties pool = this.config.getAsyncPool();
        schemePortResolverProvider.ifAvailable(pool::setSchemePortResolver);
        if (pool.getDefaultConnectionConfig() != null) {
            pool.setDefaultConnectionConfig(pool.getDefaultConnectionConfig().build());
        }
        log.debug("Connection Manager is {}", (Object)pool);
        PoolingAsyncClientConnectionManager connectionManager = pool.build();
        PoolingAsyncClientConnectionManagerWrapper wrapper = new PoolingAsyncClientConnectionManagerWrapper(connectionManager);
        this.cmConfigurers.orderedStream().forEach(c -> c.configure(wrapper, true));
        return connectionManager;
    }

    public static class PoolingAsyncClientConnectionManagerWrapper
    implements ConfigurableConnPoolControl {
        private final PoolingAsyncClientConnectionManager internal;

        @Generated
        public PoolingAsyncClientConnectionManagerWrapper(PoolingAsyncClientConnectionManager internal) {
            this.internal = internal;
        }

        @Generated
        public void close() {
            this.internal.close();
        }

        @Generated
        public void close(CloseMode closeMode) {
            this.internal.close(closeMode);
        }

        @Generated
        public Future<AsyncConnectionEndpoint> lease(String id, HttpRoute route, Object state, Timeout requestTimeout, FutureCallback<AsyncConnectionEndpoint> callback) {
            return this.internal.lease(id, route, state, requestTimeout, callback);
        }

        @Generated
        public void release(AsyncConnectionEndpoint endpoint, Object state, TimeValue keepAlive) {
            this.internal.release(endpoint, state, keepAlive);
        }

        @Generated
        public Future<AsyncConnectionEndpoint> connect(AsyncConnectionEndpoint endpoint, ConnectionInitiator connectionInitiator, Timeout timeout, Object attachment, HttpContext context, FutureCallback<AsyncConnectionEndpoint> callback) {
            return this.internal.connect(endpoint, connectionInitiator, timeout, attachment, context, callback);
        }

        @Generated
        public void upgrade(AsyncConnectionEndpoint endpoint, Object attachment, HttpContext context, FutureCallback<AsyncConnectionEndpoint> callback) {
            this.internal.upgrade(endpoint, attachment, context, callback);
        }

        @Generated
        public void upgrade(AsyncConnectionEndpoint endpoint, Object attachment, HttpContext context) {
            this.internal.upgrade(endpoint, attachment, context);
        }

        @Generated
        public Set<HttpRoute> getRoutes() {
            return this.internal.getRoutes();
        }

        @Generated
        public void setMaxTotal(int max) {
            this.internal.setMaxTotal(max);
        }

        @Generated
        public int getMaxTotal() {
            return this.internal.getMaxTotal();
        }

        @Generated
        public void setDefaultMaxPerRoute(int max) {
            this.internal.setDefaultMaxPerRoute(max);
        }

        @Generated
        public int getDefaultMaxPerRoute() {
            return this.internal.getDefaultMaxPerRoute();
        }

        @Generated
        public void setMaxPerRoute(HttpRoute route, int max) {
            this.internal.setMaxPerRoute(route, max);
        }

        @Generated
        public int getMaxPerRoute(HttpRoute route) {
            return this.internal.getMaxPerRoute(route);
        }

        @Generated
        public void closeIdle(TimeValue idletime) {
            this.internal.closeIdle(idletime);
        }

        @Generated
        public void closeExpired() {
            this.internal.closeExpired();
        }

        @Generated
        public PoolStats getTotalStats() {
            return this.internal.getTotalStats();
        }

        @Generated
        public PoolStats getStats(HttpRoute route) {
            return this.internal.getStats(route);
        }

        @Override
        @Generated
        public void setDefaultConnectionConfig(ConnectionConfig config) {
            this.internal.setDefaultConnectionConfig(config);
        }

        @Override
        @Generated
        public void setConnectionConfigResolver(Resolver<HttpRoute, ConnectionConfig> connectionConfigResolver) {
            this.internal.setConnectionConfigResolver(connectionConfigResolver);
        }

        @Generated
        public void setDefaultTlsConfig(TlsConfig config) {
            this.internal.setDefaultTlsConfig(config);
        }

        @Generated
        public void setTlsConfigResolver(Resolver<HttpHost, TlsConfig> tlsConfigResolver) {
            this.internal.setTlsConfigResolver(tlsConfigResolver);
        }

        @Deprecated
        @Generated
        public TimeValue getValidateAfterInactivity() {
            return this.internal.getValidateAfterInactivity();
        }

        @Deprecated
        @Generated
        public void setValidateAfterInactivity(TimeValue validateAfterInactivity) {
            this.internal.setValidateAfterInactivity(validateAfterInactivity);
        }

        @Generated
        public boolean isClosed() {
            return this.internal.isClosed();
        }
    }
}

