/*
 * Decompiled with CFR 0.152.
 */
package io.github.springboot.httpclient5.core.configure;

import io.github.springboot.httpclient5.core.config.HttpClient5Config;
import io.github.springboot.httpclient5.core.config.model.DefaultConfigConfigurer;
import io.github.springboot.httpclient5.core.configure.ConfigurableConnPoolControl;
import io.github.springboot.httpclient5.core.configure.PoolingHttpClientConnectionManagerPostConfigurer;
import io.github.springboot.httpclient5.core.utils.ThreadFactoryUtils;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ConnectionManagerCleaner
implements PoolingHttpClientConnectionManagerPostConfigurer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ConnectionManagerCleaner.class);
    private final HttpClient5Config config;
    private ConfigurableConnPoolControl cm;
    private List<ScheduledFuture<?>> cleanerTasks = new ArrayList();
    private ScheduledExecutorService executor;
    @Autowired
    private ThreadFactoryUtils threadFactoryUtils;

    @PostConstruct
    public void init() {
        ConnectionManagerCleaner connectionManagerCleaner = this;
        this.executor = new ScheduledThreadPoolExecutor(1, connectionManagerCleaner.threadFactoryUtils.getThreadFactory());
    }

    @PreDestroy
    public void dispose() {
        this.cleanerTasks.forEach(t -> t.cancel(false));
        this.executor.shutdown();
    }

    @Override
    public void configure(ConfigurableConnPoolControl cm, boolean asyncPool) {
        this.cm = cm;
        DefaultConfigConfigurer poolProperties = asyncPool ? this.config.getAsyncPool() : this.config.getPool();
        long delay = poolProperties.getConnectionIdleTimeout().convert(TimeUnit.MILLISECONDS) / 10L;
        this.cleanerTasks.add(this.executor.scheduleWithFixedDelay(this::clean, delay, delay, TimeUnit.MILLISECONDS));
    }

    protected void clean() {
        try {
            if (this.cm != null) {
                log.trace("run IdleConnectionMonitor - Closing expired and idle connections more than {}", (Object)this.config.getPool().getConnectionIdleTimeout());
                this.cm.closeExpired();
                this.cm.closeIdle(this.config.getPool().getConnectionIdleTimeout());
            } else {
                log.trace("run IdleConnectionMonitor - Http Client Connection manager is not initialised");
            }
        }
        catch (Exception e) {
            log.warn("run IdleConnectionMonitor - Exception occurred. msg={}, e={}", (Object)e.getMessage(), (Object)e);
        }
    }

    @Generated
    public ConnectionManagerCleaner(HttpClient5Config config) {
        this.config = config;
    }
}

