/*
 * Decompiled with CFR 0.152.
 */
package io.github.springboot.httpclient5.core.config.model;

import java.util.Arrays;
import java.util.Base64;
import lombok.Generated;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.core5.http.protocol.HttpContext;

public class SimplePredefinedCredentialsProvider
implements CredentialsProvider {
    private static final String PREEMPTIVE_PREFIX = "PREEMPTIVE(";
    private static final String BASIC_PREFIX = "BASIC(";
    private String credentialAsString;
    private boolean preemptive;

    public SimplePredefinedCredentialsProvider(String credentialAsString) {
        this.credentialAsString = credentialAsString;
        this.preemptive = credentialAsString.startsWith(PREEMPTIVE_PREFIX);
    }

    public String toBase64Encoded() {
        return Base64.getEncoder().encodeToString(this.removePrefixes(this.credentialAsString).getBytes());
    }

    public Credentials getCredentials(AuthScope authScope, HttpContext context) {
        String[] parts = this.removePrefixes(this.credentialAsString).split(":");
        return new UsernamePasswordCredentials(parts[0], parts[1].toCharArray());
    }

    private String removePrefixes(String s) {
        StringBuilder c = new StringBuilder(s.trim());
        Arrays.asList(BASIC_PREFIX, PREEMPTIVE_PREFIX).forEach(prefix -> {
            if (c.indexOf((String)prefix) == 0) {
                c.delete(0, prefix.length());
                c.delete(c.length() - 1, c.length());
            }
        });
        return c.toString();
    }

    @Generated
    public static SimplePredefinedCredentialsProviderBuilder builder() {
        return new SimplePredefinedCredentialsProviderBuilder();
    }

    @Generated
    public SimplePredefinedCredentialsProviderBuilder toBuilder() {
        return new SimplePredefinedCredentialsProviderBuilder().credentialAsString(this.credentialAsString).preemptive(this.preemptive);
    }

    @Generated
    public String getCredentialAsString() {
        return this.credentialAsString;
    }

    @Generated
    public boolean isPreemptive() {
        return this.preemptive;
    }

    @Generated
    public void setCredentialAsString(String credentialAsString) {
        this.credentialAsString = credentialAsString;
    }

    @Generated
    public void setPreemptive(boolean preemptive) {
        this.preemptive = preemptive;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimplePredefinedCredentialsProvider)) {
            return false;
        }
        SimplePredefinedCredentialsProvider other = (SimplePredefinedCredentialsProvider)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isPreemptive() != other.isPreemptive()) {
            return false;
        }
        String this$credentialAsString = this.getCredentialAsString();
        String other$credentialAsString = other.getCredentialAsString();
        return !(this$credentialAsString == null ? other$credentialAsString != null : !this$credentialAsString.equals(other$credentialAsString));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SimplePredefinedCredentialsProvider;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPreemptive() ? 79 : 97);
        String $credentialAsString = this.getCredentialAsString();
        result = result * 59 + ($credentialAsString == null ? 43 : $credentialAsString.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SimplePredefinedCredentialsProvider(credentialAsString=" + this.getCredentialAsString() + ", preemptive=" + this.isPreemptive() + ")";
    }

    @Generated
    public SimplePredefinedCredentialsProvider() {
    }

    @Generated
    public SimplePredefinedCredentialsProvider(String credentialAsString, boolean preemptive) {
        this.credentialAsString = credentialAsString;
        this.preemptive = preemptive;
    }

    @Generated
    public static class SimplePredefinedCredentialsProviderBuilder {
        @Generated
        private String credentialAsString;
        @Generated
        private boolean preemptive;

        @Generated
        SimplePredefinedCredentialsProviderBuilder() {
        }

        @Generated
        public SimplePredefinedCredentialsProviderBuilder credentialAsString(String credentialAsString) {
            this.credentialAsString = credentialAsString;
            return this;
        }

        @Generated
        public SimplePredefinedCredentialsProviderBuilder preemptive(boolean preemptive) {
            this.preemptive = preemptive;
            return this;
        }

        @Generated
        public SimplePredefinedCredentialsProvider build() {
            return new SimplePredefinedCredentialsProvider(this.credentialAsString, this.preemptive);
        }

        @Generated
        public String toString() {
            return "SimplePredefinedCredentialsProvider.SimplePredefinedCredentialsProviderBuilder(credentialAsString=" + this.credentialAsString + ", preemptive=" + this.preemptive + ")";
        }
    }
}

