/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Modifier;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.AnnotationDeclaration;
import com.github.javaparser.ast.body.AnnotationMemberDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.EnumDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.RecordDeclaration;
import com.github.javaparser.ast.nodeTypes.NodeWithModifiers;
import com.google.common.collect.ImmutableSet;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserNodeMutator;
import eu.solven.cleanthat.engine.java.refactorer.NodeAndSymbolSolver;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnnecessaryModifier
extends AJavaparserNodeMutator {
    private static final Logger log = LoggerFactory.getLogger(UnnecessaryModifier.class);

    public String minimalJavaVersion() {
        return "1";
    }

    public Set<String> getTags() {
        return ImmutableSet.of((Object)"ExplicitToImplicit");
    }

    public boolean isDraft() {
        return false;
    }

    public Optional<String> getPmdId() {
        return Optional.of("UnnecessaryModifier");
    }

    public String pmdUrl() {
        return "https://pmd.github.io/latest/pmd_rules_java_codestyle.html#unnecessarymodifier";
    }

    public Optional<String> getCheckstyleId() {
        return Optional.of("RedundantModifier");
    }

    public String checkstyleUrl() {
        return "https://checkstyle.sourceforge.io/config_modifier.html#RedundantModifier";
    }

    public Optional<String> getSonarId() {
        return Optional.of("RSPEC-2333");
    }

    public Optional<String> getJSparrowId() {
        return Optional.of("RemoveModifiersInInterfaceProperties");
    }

    public String jSparrowUrl() {
        return "https://jsparrow.github.io/rules/remove-modifiers-in-interface-properties.html";
    }

    @Override
    protected boolean processNotRecursively(NodeAndSymbolSolver<?> nodeAndSymbolSolver) {
        return Optional.ofNullable(nodeAndSymbolSolver.getNode()).filter(Modifier.class::isInstance).map(Modifier.class::cast).map(modifier -> this.isRedundant((Modifier)modifier) && this.removeModifier((Modifier)modifier)).orElse(false);
    }

    private boolean isRedundant(Modifier modifier) {
        return modifier.getParentNode().map(parentNode -> {
            switch (modifier.getKeyword()) {
                case ABSTRACT: {
                    return this.isImplicitlyAbstract((Node)parentNode);
                }
                case FINAL: {
                    return this.isImplicitlyFinal((Node)parentNode);
                }
                case PUBLIC: {
                    return this.isImplicitlyPublic((Node)parentNode);
                }
                case STATIC: {
                    return this.isImplicitlyStatic((Node)parentNode);
                }
            }
            return false;
        }).orElse(false);
    }

    private boolean isImplicitlyAbstract(Node node) {
        return this.isInterfaceLike(node) || (node instanceof MethodDeclaration || node instanceof AnnotationMemberDeclaration) && node.getParentNode().filter(this::isInterfaceLike).isPresent();
    }

    private boolean isImplicitlyFinal(Node node) {
        return node instanceof RecordDeclaration || node instanceof FieldDeclaration && node.getParentNode().filter(this::isInterfaceLike).isPresent() || node instanceof MethodDeclaration && ((MethodDeclaration)node).isPrivate();
    }

    private boolean isImplicitlyPublic(Node node) {
        return node.getParentNode().filter(this::isInterfaceLike).isPresent();
    }

    private boolean isImplicitlyStatic(Node node) {
        return this.isInterfaceLike(node) || node instanceof EnumDeclaration || node instanceof RecordDeclaration || (node instanceof ClassOrInterfaceDeclaration || node instanceof FieldDeclaration) && node.getParentNode().filter(this::isInterfaceLike).isPresent();
    }

    private boolean isInterfaceLike(Node node) {
        if (node instanceof AnnotationDeclaration) {
            return true;
        }
        if (node instanceof ClassOrInterfaceDeclaration) {
            return ((ClassOrInterfaceDeclaration)node).isInterface();
        }
        return false;
    }

    private boolean removeModifier(Modifier modifier) {
        NodeWithModifiers nodeWithModifiers = (NodeWithModifiers)modifier.getParentNode().get();
        ArrayList mutableModifiers = new ArrayList(nodeWithModifiers.getModifiers());
        if (!mutableModifiers.remove(modifier)) {
            throw new IllegalStateException("Issue removing " + modifier + " from " + mutableModifiers);
        }
        nodeWithModifiers.setModifiers(new Modifier.Keyword[0]);
        NodeList asNodeList = new NodeList(mutableModifiers);
        nodeWithModifiers.setModifiers(asNodeList);
        return true;
    }
}

