/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.google.common.collect.ImmutableSet;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserExprMutator;
import eu.solven.cleanthat.engine.java.refactorer.NodeAndSymbolSolver;
import eu.solven.cleanthat.engine.java.refactorer.helpers.MethodCallExprHelpers;
import java.util.Optional;
import java.util.Set;

public class StringToString
extends AJavaparserExprMutator {
    private static final String METHOD_TO_STRING = "toString";

    public String minimalJavaVersion() {
        return "1";
    }

    public boolean isDraft() {
        return false;
    }

    public Set<String> getTags() {
        return ImmutableSet.of((Object)"String");
    }

    public Optional<String> getPmdId() {
        return Optional.of("StringToString");
    }

    public String pmdUrl() {
        return "https://pmd.github.io/latest/pmd_rules_java_performance.html#stringtostring";
    }

    public Optional<String> getJSparrowId() {
        return Optional.of("RemoveToStringOnString");
    }

    public String jSparrowUrl() {
        return "https://jsparrow.github.io/rules/remove-to-string-on-string.html";
    }

    @Override
    protected boolean processExpression(NodeAndSymbolSolver<Expression> expr) {
        if (!expr.getNode().isMethodCallExpr()) {
            return false;
        }
        MethodCallExpr methodCall = expr.getNode().asMethodCallExpr();
        String methodCallIdentifier = methodCall.getName().getIdentifier();
        if (!METHOD_TO_STRING.equals(methodCallIdentifier)) {
            return false;
        }
        Optional optParent = methodCall.getParentNode();
        if (methodCall.getScope().isEmpty() || optParent.isEmpty()) {
            return false;
        }
        Optional optScope = methodCall.getScope();
        if (!MethodCallExprHelpers.scopeHasRequiredType(expr.editNode(optScope), String.class)) {
            return false;
        }
        Expression scope = (Expression)optScope.get();
        return this.tryReplace(expr, (Node)scope);
    }
}

