/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.LiteralStringValueExpr;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.google.common.collect.ImmutableSet;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserExprMutator;
import eu.solven.cleanthat.engine.java.refactorer.NodeAndSymbolSolver;
import eu.solven.cleanthat.engine.java.refactorer.helpers.MethodCallExprHelpers;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringReplaceAllWithQuotableInput
extends AJavaparserExprMutator {
    private static final Logger LOGGER = LoggerFactory.getLogger(StringReplaceAllWithQuotableInput.class);
    private static final String IS_REGEX_SPECIAL_CHAR = ".\\+*?[^]$(){}=!<>|:-";
    private static final String IS_NOT_REGEX = ".\\+*?[^]$(){}=!<>|:-".chars().mapToObj(c -> "\\" + Character.toString((char)c)).collect(Collectors.joining("", "[^", "]"));
    private static final String IS_ESCAPED_REGEX_CHAR = "(?:\\\\\\\\(?:[^\\w]|_|\\\\\\\\))";
    private static final String IS_QUOTE_REGEX = "(?:" + IS_NOT_REGEX + "|(?:\\\\\\\\(?:[^\\w]|_|\\\\\\\\)))*";
    private static final Pattern IS_QUOTE = Pattern.compile(IS_QUOTE_REGEX);

    public String minimalJavaVersion() {
        return "1.4";
    }

    public Set<String> getTags() {
        return ImmutableSet.of((Object)"String");
    }

    public Optional<String> getSonarId() {
        return Optional.of("RSPEC-5361");
    }

    @Override
    protected boolean processExpression(NodeAndSymbolSolver<Expression> expr) {
        if (!expr.getNode().isMethodCallExpr()) {
            return false;
        }
        MethodCallExpr methodCall = expr.getNode().asMethodCallExpr();
        if (!"replaceAll".equals(methodCall.getNameAsString())) {
            return false;
        }
        if (methodCall.getArguments().size() != 2) {
            return false;
        }
        if (!MethodCallExprHelpers.scopeHasRequiredType(expr.editNode(methodCall.getScope()), String.class)) {
            return false;
        }
        if (!MethodCallExprHelpers.scopeHasRequiredType(expr.editNode(methodCall.getArgument(0)), String.class)) {
            return false;
        }
        if (!methodCall.getArgument(0).isLiteralStringValueExpr()) {
            return false;
        }
        LiteralStringValueExpr literalRegex = methodCall.getArgument(0).asLiteralStringValueExpr();
        String regex = literalRegex.getValue();
        if (!StringReplaceAllWithQuotableInput.isQuotableRegex(regex)) {
            return false;
        }
        String regexAsQuote = regex.replaceAll("(?:\\\\\\\\([^\\w]|\\\\\\\\))", "$1");
        literalRegex.setValue(regexAsQuote);
        methodCall.setName("replace");
        return true;
    }

    public static boolean isQuotableRegex(String regex) {
        return IS_QUOTE.matcher(regex).matches();
    }

    static {
        LOGGER.debug("Regex matching quotable regex: {}", (Object)IS_QUOTE_REGEX);
    }
}

