/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.mutators;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import eu.solven.cleanthat.engine.java.refactorer.AJavaparserExprMutator;
import eu.solven.cleanthat.engine.java.refactorer.NodeAndSymbolSolver;
import eu.solven.cleanthat.engine.java.refactorer.helpers.MethodCallExprHelpers;
import java.util.Optional;
import java.util.Set;

public class GuavaImmutableMapBuilderOverVarargs
extends AJavaparserExprMutator {
    private static final int ARG_PER_ENTRY = 2;
    private static final int MINIMAL_ENTRY_TO_TRIGGER = 2;
    private static final boolean CAN_MANAGE_GENERIC_TYPES = false;

    public String minimalJavaVersion() {
        return "11";
    }

    public Set<String> getTags() {
        return ImmutableSet.of((Object)"Guava", (Object)"Varargs");
    }

    @Override
    protected boolean processExpression(NodeAndSymbolSolver<Expression> expr) {
        if (!expr.getNode().isMethodCallExpr()) {
            return false;
        }
        MethodCallExpr methodCall = expr.getNode().asMethodCallExpr();
        String methodCallIdentifier = methodCall.getName().getIdentifier();
        if (!"of".equals(methodCallIdentifier)) {
            return false;
        }
        if (methodCall.getScope().isEmpty()) {
            return false;
        }
        if (methodCall.getArguments().size() % 2 != 0) {
            return false;
        }
        if (methodCall.getArguments().size() < 4) {
            return false;
        }
        Optional optScope = methodCall.getScope();
        if (optScope.isEmpty() || !((Expression)optScope.get()).isNameExpr() || !MethodCallExprHelpers.scopeHasRequiredType(expr.editNode(optScope), ImmutableMap.class)) {
            return false;
        }
        MethodCallExpr builder = new MethodCallExpr((Expression)optScope.get(), "builder");
        for (int i = 0; i < methodCall.getArguments().size() / 2; ++i) {
            builder = new MethodCallExpr((Expression)builder, "put", new NodeList((Node[])new Expression[]{methodCall.getArgument(2 * i), methodCall.getArgument(2 * i + 1)}));
        }
        return this.tryReplace((Node)methodCall, (Node)new MethodCallExpr((Expression)builder, "build"));
    }
}

