/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.engine.java.refactorer.helpers;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.Parameter;
import com.github.javaparser.ast.expr.AssignExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.LambdaExpr;
import com.github.javaparser.ast.expr.SimpleName;
import com.github.javaparser.ast.expr.UnaryExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.nodeTypes.NodeWithThrownExceptions;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.BreakStmt;
import com.github.javaparser.ast.stmt.ContinueStmt;
import com.github.javaparser.ast.stmt.ReturnStmt;
import com.github.javaparser.ast.stmt.Statement;
import com.github.javaparser.ast.type.Type;
import com.github.javaparser.ast.type.UnknownType;
import com.github.javaparser.resolution.types.ResolvedType;
import eu.solven.cleanthat.engine.java.refactorer.helpers.ResolvedTypeHelpers;
import java.util.Optional;

public class LambdaExprHelpers {
    protected LambdaExprHelpers() {
    }

    public static Optional<LambdaExpr> makeLambdaExpr(SimpleName simpleName, Statement statement) {
        if (statement.isBlockStmt()) {
            return LambdaExprHelpers.makeLambdaExpr(simpleName, statement.asBlockStmt());
        }
        if (statement.isExpressionStmt()) {
            return LambdaExprHelpers.makeLambdaExpr(simpleName, statement.asExpressionStmt().getExpression());
        }
        return Optional.empty();
    }

    public static Optional<LambdaExpr> makeLambdaExpr(SimpleName simpleName, BlockStmt statement) {
        if (!LambdaExprHelpers.canBePushedInLambdaExpr((Node)statement)) {
            return Optional.empty();
        }
        Parameter parameter = new Parameter((Type)new UnknownType(), simpleName);
        return Optional.of(new LambdaExpr(parameter, statement.asBlockStmt()));
    }

    public static Optional<LambdaExpr> makeLambdaExpr(SimpleName simpleName, Expression expression) {
        if (!LambdaExprHelpers.canBePushedInLambdaExpr((Node)expression)) {
            return Optional.empty();
        }
        Parameter parameter = new Parameter((Type)new UnknownType(), simpleName);
        return Optional.of(new LambdaExpr(parameter, expression));
    }

    private static boolean canBePushedInLambdaExpr(Node node) {
        if (LambdaExprHelpers.hasOuterAssignExpr(node)) {
            return false;
        }
        if (node.findFirst(ReturnStmt.class).isPresent()) {
            return false;
        }
        if (node.findFirst(ContinueStmt.class).isPresent()) {
            return false;
        }
        if (node.findFirst(BreakStmt.class).isPresent()) {
            return false;
        }
        return !LambdaExprHelpers.nodeThrowsExplicitException(node);
    }

    private static boolean nodeThrowsExplicitException(Node node) {
        Optional optFirstAncestorWithExceptions = node.findAncestor(new Class[]{NodeWithThrownExceptions.class});
        if (optFirstAncestorWithExceptions.isEmpty()) {
            return false;
        }
        Optional<Object> firstUnknownOrExplicitException = ((NodeWithThrownExceptions)optFirstAncestorWithExceptions.get()).getThrownExceptions().stream().filter(Type.class::isInstance).map(t -> (Type)t).filter(t -> {
            Optional<ResolvedType> optResolved = ResolvedTypeHelpers.optResolvedType((Type)t);
            if (optResolved.isEmpty()) {
                return true;
            }
            if (ResolvedTypeHelpers.typeIsAssignable(optResolved, RuntimeException.class.getName())) {
                return false;
            }
            return !ResolvedTypeHelpers.typeIsAssignable(optResolved, Error.class.getName());
        }).findFirst();
        return firstUnknownOrExplicitException.isPresent();
    }

    public static boolean hasOuterAssignExpr(Node node) {
        Optional optOuterAssignExpr = node.findFirst(AssignExpr.class, assignExpr -> {
            Expression assigned = assignExpr.getTarget();
            return node.findFirst(VariableDeclarationExpr.class, variableDeclExpr -> variableDeclExpr.getVariables().stream().filter(declared -> declared.getNameAsExpression().equals((Object)assigned)).findAny().isPresent()).isEmpty();
        });
        if (optOuterAssignExpr.isPresent()) {
            return true;
        }
        Optional optOuterUnaryExpr = node.findFirst(UnaryExpr.class, unaryExpr -> {
            if (unaryExpr.getOperator() != UnaryExpr.Operator.POSTFIX_DECREMENT && unaryExpr.getOperator() != UnaryExpr.Operator.POSTFIX_INCREMENT && unaryExpr.getOperator() != UnaryExpr.Operator.PREFIX_DECREMENT && unaryExpr.getOperator() != UnaryExpr.Operator.PREFIX_INCREMENT) {
                return false;
            }
            Expression assigned = unaryExpr.getExpression();
            return node.findFirst(VariableDeclarationExpr.class, variableDeclExpr -> variableDeclExpr.getVariables().stream().filter(declared -> declared.getNameAsExpression().equals((Object)assigned)).findAny().isPresent()).isEmpty();
        });
        return optOuterUnaryExpr.isPresent();
    }

    public static boolean changeName(LambdaExpr mapLambdaExpr, SimpleName newName) {
        if (mapLambdaExpr.getParameters().size() != 1) {
            return false;
        }
        Parameter parameter = new Parameter((Type)new UnknownType(), newName);
        LambdaExpr newlambda = new LambdaExpr(new NodeList((Node[])new Parameter[]{parameter}), mapLambdaExpr.getBody(), mapLambdaExpr.isEnclosingParameters());
        mapLambdaExpr.replace((Node)newlambda);
        return true;
    }
}

