/*
 * Decompiled with CFR 0.152.
 */
package eu.solven.cleanthat.any_language;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.solven.cleanthat.any_language.ICodeCleaner;
import eu.solven.cleanthat.codeprovider.CodeProviderDecoratingWriter;
import eu.solven.cleanthat.codeprovider.CodeProviderHelpers;
import eu.solven.cleanthat.codeprovider.ICodeProvider;
import eu.solven.cleanthat.codeprovider.ICodeProviderWriter;
import eu.solven.cleanthat.codeprovider.IListOnlyModifiedFiles;
import eu.solven.cleanthat.config.ICleanthatConfigConstants;
import eu.solven.cleanthat.config.ICleanthatConfigInitializer;
import eu.solven.cleanthat.config.RepoInitializerResult;
import eu.solven.cleanthat.config.pojo.CleanthatRepositoryProperties;
import eu.solven.cleanthat.formatter.CodeFormatResult;
import eu.solven.cleanthat.formatter.ICodeProviderFormatter;
import eu.solven.cleanthat.github.CleanthatConfigHelper;
import eu.solven.cleanthat.utils.ResultOrError;
import eu.solven.pepper.collection.PepperMapHelper;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ACodeCleaner
implements ICodeCleaner {
    private static final Logger LOGGER = LoggerFactory.getLogger(ACodeCleaner.class);
    final Collection<ObjectMapper> objectMappers;
    final ICleanthatConfigInitializer configInitializer;
    final ICodeProviderFormatter formatterProvider;

    public ACodeCleaner(Collection<ObjectMapper> objectMappers, ICleanthatConfigInitializer configInitializer, ICodeProviderFormatter formatterProvider) {
        this.objectMappers = objectMappers;
        this.configInitializer = configInitializer;
        this.formatterProvider = formatterProvider;
    }

    protected Collection<ObjectMapper> getObjectMappers() {
        return this.objectMappers;
    }

    public CodeFormatResult formatCode(CleanthatRepositoryProperties properties, ICodeProviderWriter pr, boolean dryRun) {
        return this.formatterProvider.formatCode(properties, pr, dryRun);
    }

    public ResultOrError<CleanthatRepositoryProperties, String> loadAndCheckConfiguration(ICodeProvider codeProvider) {
        CleanthatRepositoryProperties properties;
        Optional<Map<String, ?>> optPrConfig = this.safeConfig(codeProvider);
        if (optPrConfig.isEmpty()) {
            LOGGER.info("There is no configuration ({}) on {}", (Object)ICleanthatConfigConstants.PATHES_CLEANTHAT, (Object)codeProvider);
            return ResultOrError.error((Object)"No configuration");
        }
        Optional version = PepperMapHelper.getOptionalString(optPrConfig.get(), (Object)"syntax_version", (Object[])new Object[0]);
        if (version.isEmpty()) {
            LOGGER.warn("No version on configuration applying to PR {}", (Object)codeProvider);
            return ResultOrError.error((Object)"No syntax_version in configuration");
        }
        if (!"2023-01-09".equals(version.get())) {
            LOGGER.warn("Version '{}' on configuration is not supported {}(only syntax_version='2023-01-09')", version.get(), (Object)codeProvider);
            return ResultOrError.error((Object)"Invalid syntax_version in configuration");
        }
        Map<String, ?> prConfig = optPrConfig.get();
        try {
            properties = this.prepareConfiguration(prConfig);
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("The configuration file seems invalid", e);
        }
        return ResultOrError.result((Object)properties);
    }

    public static boolean isLimittedSetOfFiles(ICodeProvider codeProvider) {
        return codeProvider instanceof IListOnlyModifiedFiles || codeProvider instanceof CodeProviderDecoratingWriter && ((CodeProviderDecoratingWriter)codeProvider).getDecorated() instanceof IListOnlyModifiedFiles;
    }

    @Override
    public CodeFormatResult formatCodeGivenConfig(String eventKey, ICodeProviderWriter codeProvider, boolean dryRun) {
        ResultOrError<CleanthatRepositoryProperties, String> optResult = this.loadAndCheckConfiguration((ICodeProvider)codeProvider);
        if (optResult.getOptError().isPresent()) {
            throw new IllegalStateException("Issue with configuration: " + (String)optResult.getOptError().get());
        }
        CleanthatRepositoryProperties properties = (CleanthatRepositoryProperties)optResult.getOptResult().get();
        if (ACodeCleaner.isLimittedSetOfFiles((ICodeProvider)codeProvider)) {
            LOGGER.info("About to clean a limitted set of files");
        } else {
            LOGGER.info("About to clean the whole repo");
        }
        return this.formatCode(properties, codeProvider, dryRun);
    }

    protected void migrateConfigurationCode(CleanthatRepositoryProperties properties) {
        LOGGER.debug("TODO Migration (if necessary) of configuration: {}", (Object)properties);
    }

    protected CleanthatRepositoryProperties prepareConfiguration(Map<String, ?> prConfig) {
        ObjectMapper objectMapper = this.objectMappers.iterator().next();
        return CleanthatConfigHelper.parseConfig((ObjectMapper)objectMapper, prConfig);
    }

    protected Optional<Map<String, ?>> safeConfig(ICodeProvider codeProvider) {
        try {
            return new CodeProviderHelpers(this.objectMappers).unsafeConfig(codeProvider);
        }
        catch (RuntimeException e) {
            LOGGER.warn("Issue loading the configuration", (Throwable)e);
            return Optional.empty();
        }
    }

    protected RepoInitializerResult generateDefaultConfiguration(ICodeProvider codeProvider, boolean isPrivateRepo, String eventKey) {
        return this.configInitializer.prepareFile(codeProvider, isPrivateRepo, eventKey);
    }
}

