/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.smali;

import com.android.tools.smali.dexlib2.Opcodes;
import com.android.tools.smali.dexlib2.writer.builder.DexBuilder;
import com.android.tools.smali.dexlib2.writer.io.DexDataStore;
import com.android.tools.smali.dexlib2.writer.io.MemoryDataStore;
import com.android.tools.smali.smali.SmaliOptions;
import com.android.tools.smali.smali.smaliFlexLexer;
import com.android.tools.smali.smali.smaliParser;
import com.android.tools.smali.smali.smaliTreeWalker;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTreeNodeStream;
import org.antlr.runtime.tree.TreeNodeStream;

public class SmaliUtils {
    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] assemble(File smaliFile, SmaliOptions options) throws IOException {
        StringBuilder errors = new StringBuilder();
        try (FileInputStream fis = new FileInputStream(smaliFile);){
            byte[] byArray;
            try (InputStreamReader reader = new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8);){
                smaliFlexLexer lexer = new smaliFlexLexer((Reader)reader, options.apiLevel);
                lexer.setSourceFile(smaliFile);
                CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
                ParserWrapper parser = new ParserWrapper((TokenStream)tokens, errors);
                parser.setVerboseErrors(options.verboseErrors);
                parser.setAllowOdex(options.allowOdexOpcodes);
                parser.setApiLevel(options.apiLevel);
                smaliParser.smali_file_return parseResult = parser.smali_file();
                if (parser.getNumberOfSyntaxErrors() > 0 || lexer.getNumberOfSyntaxErrors() > 0) {
                    throw new RuntimeException("Smali parse error: " + errors);
                }
                CommonTreeNodeStream treeStream = new CommonTreeNodeStream((Object)parseResult.getTree());
                treeStream.setTokenStream((TokenStream)tokens);
                DexBuilder dexBuilder = new DexBuilder(Opcodes.forApi((int)options.apiLevel));
                TreeWalkerWrapper dexGen = new TreeWalkerWrapper((TreeNodeStream)treeStream, errors);
                dexGen.setApiLevel(options.apiLevel);
                dexGen.setVerboseErrors(options.verboseErrors);
                dexGen.setDexBuilder(dexBuilder);
                dexGen.smali_file();
                if (dexGen.getNumberOfSyntaxErrors() > 0) {
                    throw new RuntimeException("Smali compile error: " + errors);
                }
                MemoryDataStore dataStore = new MemoryDataStore();
                dexBuilder.writeTo((DexDataStore)dataStore);
                byArray = dataStore.getData();
            }
            return byArray;
        }
        catch (RecognitionException e) {
            throw new RuntimeException("Smali process error: " + errors, e);
        }
    }

    private static final class TreeWalkerWrapper
    extends smaliTreeWalker {
        private final StringBuilder errors;

        public TreeWalkerWrapper(TreeNodeStream input, StringBuilder errors) {
            super(input);
            this.errors = errors;
        }

        public void emitErrorMessage(String msg) {
            this.errors.append('\n').append(msg);
        }
    }

    private static final class ParserWrapper
    extends smaliParser {
        private final StringBuilder errors;

        public ParserWrapper(TokenStream input, StringBuilder errors) {
            super(input);
            this.errors = errors;
        }

        public void emitErrorMessage(String msg) {
            this.errors.append('\n').append(msg);
        }
    }
}

