/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.smali;

import com.android.tools.smali.smali.Smali;
import com.android.tools.smali.smali.SmaliOptions;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmaliConvert
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(SmaliConvert.class);
    @Nullable
    private Path tmpDex;

    public boolean execute(List<Path> input) {
        List<Path> smaliFiles = this.filterSmaliFiles(input);
        if (smaliFiles.isEmpty()) {
            return false;
        }
        LOG.debug("Compiling smali files: {}", (Object)smaliFiles.size());
        try {
            this.tmpDex = Files.createTempFile("jadx-", ".dex", new FileAttribute[0]);
            if (SmaliConvert.compileSmali(this.tmpDex, smaliFiles)) {
                return true;
            }
        }
        catch (Exception e) {
            LOG.error("Smali process error", (Throwable)e);
        }
        this.close();
        return false;
    }

    private static boolean compileSmali(Path output, List<Path> inputFiles) throws IOException {
        SmaliOptions options = new SmaliOptions();
        options.outputDexFile = output.toAbsolutePath().toString();
        options.verboseErrors = true;
        options.apiLevel = 27;
        List inputFileNames = inputFiles.stream().map(p -> p.toAbsolutePath().toString()).distinct().collect(Collectors.toList());
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            boolean result = SmaliConvert.collectSystemErrors(out, () -> Smali.assemble((SmaliOptions)options, (List)inputFileNames));
            if (!result) {
                LOG.error("Smali compilation error:\n{}", (Object)out);
            }
            boolean bl = result;
            return bl;
        }
    }

    /*
     * Loose catch block
     */
    private static boolean collectSystemErrors(OutputStream out, Callable<Boolean> exec) {
        PrintStream systemErr = System.err;
        try {
            PrintStream err = new PrintStream(out);
            System.setErr(err);
            try {
                boolean bl = exec.call();
                err.close();
                return bl;
            }
            catch (Exception e) {
                e.printStackTrace(err);
                boolean bl = false;
                err.close();
                System.setErr(systemErr);
                return bl;
                {
                    catch (Throwable throwable) {
                        try {
                            err.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
            }
        }
        finally {
            System.setErr(systemErr);
        }
    }

    private List<Path> filterSmaliFiles(List<Path> input) {
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:**.smali");
        return input.stream().filter(matcher::matches).collect(Collectors.toList());
    }

    public List<Path> getDexFiles() {
        if (this.tmpDex == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.tmpDex);
    }

    @Override
    public void close() {
        try {
            if (this.tmpDex != null) {
                Files.deleteIfExists(this.tmpDex);
            }
        }
        catch (Exception e) {
            LOG.error("Failed to remove tmp dex file: {}", (Object)this.tmpDex, (Object)e);
        }
    }
}

