/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.tools.resolvers;

import jadx.plugins.tools.resolvers.IJadxPluginResolver;
import jadx.plugins.tools.resolvers.file.LocalFileResolver;
import jadx.plugins.tools.resolvers.github.GithubReleaseResolver;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ResolversRegistry {
    private static final Map<String, IJadxPluginResolver> RESOLVERS_MAP = new HashMap<String, IJadxPluginResolver>();

    private static void register(IJadxPluginResolver resolver) {
        RESOLVERS_MAP.put(resolver.id(), resolver);
    }

    public static IJadxPluginResolver getResolver(String locationId) {
        Objects.requireNonNull(locationId);
        int sep = locationId.indexOf(58);
        if (sep <= 0) {
            throw new IllegalArgumentException("Malformed locationId: " + locationId);
        }
        return ResolversRegistry.getById(locationId.substring(0, sep));
    }

    public static IJadxPluginResolver getById(String resolverId) {
        IJadxPluginResolver resolver = RESOLVERS_MAP.get(resolverId);
        if (resolver == null) {
            throw new IllegalArgumentException("Unknown resolverId: " + resolverId);
        }
        return resolver;
    }

    static {
        ResolversRegistry.register(new LocalFileResolver());
        ResolversRegistry.register(new GithubReleaseResolver());
    }
}

