/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.tools;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import jadx.api.plugins.utils.ZipSecurity;
import jadx.core.utils.files.FileUtils;
import jadx.plugins.tools.data.JadxPluginListCache;
import jadx.plugins.tools.data.JadxPluginMetadata;
import jadx.plugins.tools.resolvers.github.GithubTools;
import jadx.plugins.tools.resolvers.github.LocationInfo;
import jadx.plugins.tools.resolvers.github.data.Asset;
import jadx.plugins.tools.resolvers.github.data.Release;
import jadx.plugins.tools.utils.PluginFiles;
import jadx.plugins.tools.utils.PluginUtils;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class JadxPluginsList {
    private static final JadxPluginsList INSTANCE = new JadxPluginsList();
    private static final Type LIST_TYPE = new TypeToken<List<JadxPluginMetadata>>(){}.getType();
    private static final Type CACHE_TYPE = new TypeToken<JadxPluginListCache>(){}.getType();
    @Nullable
    private JadxPluginListCache loadedList;

    public static JadxPluginsList getInstance() {
        return INSTANCE;
    }

    private JadxPluginsList() {
    }

    public synchronized void get(Consumer<List<JadxPluginMetadata>> consumer) {
        if (this.loadedList != null) {
            consumer.accept(this.loadedList.getList());
            return;
        }
        JadxPluginListCache listCache = this.loadCache();
        if (listCache != null) {
            consumer.accept(listCache.getList());
        }
        Release release = this.fetchLatestRelease();
        if (listCache == null || !listCache.getVersion().equals(release.getName())) {
            JadxPluginListCache updatedList = this.fetchBundle(release);
            this.saveCache(updatedList);
            consumer.accept(updatedList.getList());
        }
    }

    public List<JadxPluginMetadata> get() {
        AtomicReference holder = new AtomicReference();
        this.get(holder::set);
        return (List)holder.get();
    }

    @Nullable
    private JadxPluginListCache loadCache() {
        if (!Files.isRegularFile(PluginFiles.PLUGINS_LIST_CACHE, new LinkOption[0])) {
            return null;
        }
        try {
            String jsonStr = FileUtils.readFile((Path)PluginFiles.PLUGINS_LIST_CACHE);
            return (JadxPluginListCache)JadxPluginsList.buildGson().fromJson(jsonStr, CACHE_TYPE);
        }
        catch (Exception e) {
            return null;
        }
    }

    private void saveCache(JadxPluginListCache listCache) {
        try {
            String jsonStr = JadxPluginsList.buildGson().toJson((Object)listCache, CACHE_TYPE);
            FileUtils.writeFile((Path)PluginFiles.PLUGINS_LIST_CACHE, (String)jsonStr);
        }
        catch (Exception e) {
            throw new RuntimeException("Error saving file: " + PluginFiles.PLUGINS_LIST_CACHE, e);
        }
        this.loadedList = listCache;
    }

    private static Gson buildGson() {
        return new GsonBuilder().setPrettyPrinting().create();
    }

    private Release fetchLatestRelease() {
        LocationInfo latest = new LocationInfo("jadx-decompiler", "jadx-plugins-list", "list", null);
        Release release = GithubTools.fetchRelease(latest);
        List<Asset> assets = release.getAssets();
        if (assets.isEmpty()) {
            throw new RuntimeException("Release don't have assets");
        }
        return release;
    }

    private JadxPluginListCache fetchBundle(Release release) {
        Asset listAsset = release.getAssets().get(0);
        Path tmpListFile = FileUtils.createTempFile((String)"list.zip");
        PluginUtils.downloadFile(listAsset.getDownloadUrl(), tmpListFile);
        JadxPluginListCache listCache = new JadxPluginListCache();
        listCache.setVersion(release.getName());
        listCache.setList(JadxPluginsList.loadListBundle(tmpListFile));
        return listCache;
    }

    private static List<JadxPluginMetadata> loadListBundle(Path tmpListFile) {
        Gson gson = new Gson();
        ArrayList<JadxPluginMetadata> entries = new ArrayList<JadxPluginMetadata>();
        ZipSecurity.readZipEntries((File)tmpListFile.toFile(), (entry, in) -> {
            if (entry.getName().endsWith(".json")) {
                try (InputStreamReader reader = new InputStreamReader((InputStream)in);){
                    entries.addAll((Collection)gson.fromJson((Reader)reader, LIST_TYPE));
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to read plugins list entry: " + entry.getName());
                }
            }
        });
        return entries;
    }
}

