/*
 * Decompiled with CFR 0.152.
 */
package jadx.plugins.input.java.data;

import jadx.api.plugins.input.data.ICallSite;
import jadx.api.plugins.input.data.IFieldRef;
import jadx.api.plugins.input.data.IMethodHandle;
import jadx.api.plugins.input.data.IMethodRef;
import jadx.api.plugins.input.data.MethodHandleType;
import jadx.api.plugins.input.data.annotations.EncodedType;
import jadx.api.plugins.input.data.annotations.EncodedValue;
import jadx.api.plugins.input.data.impl.CallSite;
import jadx.api.plugins.input.data.impl.FieldRefHandle;
import jadx.api.plugins.input.data.impl.MethodRefHandle;
import jadx.plugins.input.java.JavaClassReader;
import jadx.plugins.input.java.data.ClassOffsets;
import jadx.plugins.input.java.data.ConstantType;
import jadx.plugins.input.java.data.DataReader;
import jadx.plugins.input.java.data.JavaClassData;
import jadx.plugins.input.java.data.JavaFieldData;
import jadx.plugins.input.java.data.JavaMethodRef;
import jadx.plugins.input.java.data.attributes.JavaAttrType;
import jadx.plugins.input.java.data.attributes.types.JavaBootstrapMethodsAttr;
import jadx.plugins.input.java.data.attributes.types.data.RawBootstrapMethod;
import jadx.plugins.input.java.utils.DescriptorParser;
import jadx.plugins.input.java.utils.JavaClassParseException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConstPoolReader {
    private final JavaClassReader clsReader;
    private final JavaClassData clsData;
    private final DataReader data;
    private final ClassOffsets offsets;

    public ConstPoolReader(JavaClassReader clsReader, JavaClassData javaClassData, DataReader data, ClassOffsets offsets) {
        this.clsReader = clsReader;
        this.clsData = javaClassData;
        this.data = data;
        this.offsets = offsets;
    }

    @Nullable
    public String getClass(int idx) {
        this.jumpToData(idx);
        int nameIdx = this.data.readU2();
        return this.fixType(this.getUtf8(nameIdx));
    }

    public IFieldRef getFieldRef(int idx) {
        this.jumpToData(idx);
        int clsIdx = this.data.readU2();
        int nameTypeIdx = this.data.readU2();
        this.jumpToData(nameTypeIdx);
        int nameIdx = this.data.readU2();
        int typeIdx = this.data.readU2();
        JavaFieldData fieldData = new JavaFieldData();
        fieldData.setParentClassType(this.getClass(clsIdx));
        fieldData.setName(this.getUtf8(nameIdx));
        fieldData.setType(this.getUtf8(typeIdx));
        return fieldData;
    }

    public String getFieldType(int idx) {
        this.jumpToData(idx);
        this.data.skip(2);
        int nameTypeIdx = this.data.readU2();
        this.jumpToData(nameTypeIdx);
        this.data.skip(2);
        int typeIdx = this.data.readU2();
        return this.getUtf8(typeIdx);
    }

    public IMethodRef getMethodRef(int idx) {
        this.jumpToData(idx);
        int clsIdx = this.data.readU2();
        int nameTypeIdx = this.data.readU2();
        this.jumpToData(nameTypeIdx);
        int nameIdx = this.data.readU2();
        int descIdx = this.data.readU2();
        JavaMethodRef mthRef = new JavaMethodRef();
        mthRef.initUniqId(this.clsReader, idx, true);
        mthRef.setParentClassType(this.getClass(clsIdx));
        mthRef.setName(this.getUtf8(nameIdx));
        mthRef.setDescr(this.getUtf8(descIdx));
        return mthRef;
    }

    public ICallSite getCallSite(int idx) {
        ConstantType constType = this.jumpToConst(idx);
        switch (constType) {
            case INVOKE_DYNAMIC: {
                int bootstrapMthIdx = this.data.readU2();
                int nameAndTypeIdx = this.data.readU2();
                this.jumpToData(nameAndTypeIdx);
                int nameIdx = this.data.readU2();
                int descIdx = this.data.readU2();
                return this.resolveMethodCallSite(bootstrapMthIdx, nameIdx, descIdx);
            }
            case DYNAMIC: {
                throw new JavaClassParseException("Field call site not yet implemented");
            }
        }
        throw new JavaClassParseException("Unexpected tag type for call site: " + constType);
    }

    private CallSite resolveMethodCallSite(int bootstrapMthIdx, int nameIdx, int descIdx) {
        JavaBootstrapMethodsAttr bootstrapMethodsAttr = this.clsData.loadAttribute(this.data, JavaAttrType.BOOTSTRAP_METHODS);
        if (bootstrapMethodsAttr == null) {
            throw new JavaClassParseException("Unexpected missing BootstrapMethods attribute");
        }
        RawBootstrapMethod rawBootstrapMethod = bootstrapMethodsAttr.getList().get(bootstrapMthIdx);
        ArrayList<EncodedValue> values = new ArrayList<EncodedValue>(6);
        values.add(new EncodedValue(EncodedType.ENCODED_METHOD_HANDLE, (Object)this.getMethodHandle(rawBootstrapMethod.getMethodHandleIdx())));
        values.add(new EncodedValue(EncodedType.ENCODED_STRING, (Object)this.getUtf8(nameIdx)));
        values.add(new EncodedValue(EncodedType.ENCODED_METHOD_TYPE, (Object)DescriptorParser.parseToMethodProto(this.getUtf8(descIdx))));
        for (int argConstIdx : rawBootstrapMethod.getArgs()) {
            values.add(this.readAsEncodedValue(argConstIdx));
        }
        return new CallSite(values);
    }

    private IMethodHandle getMethodHandle(int idx) {
        this.jumpToData(idx);
        int kind = this.data.readU1();
        int refIdx = this.data.readU2();
        MethodHandleType handleType = this.convertMethodHandleKind(kind);
        if (handleType.isField()) {
            return new FieldRefHandle(handleType, this.getFieldRef(refIdx));
        }
        return new MethodRefHandle(handleType, this.getMethodRef(refIdx));
    }

    private MethodHandleType convertMethodHandleKind(int kind) {
        switch (kind) {
            case 1: {
                return MethodHandleType.STATIC_PUT;
            }
            case 2: {
                return MethodHandleType.STATIC_GET;
            }
            case 3: {
                return MethodHandleType.INSTANCE_PUT;
            }
            case 4: {
                return MethodHandleType.INSTANCE_GET;
            }
            case 5: {
                return MethodHandleType.INVOKE_INSTANCE;
            }
            case 6: {
                return MethodHandleType.INVOKE_STATIC;
            }
            case 7: {
                return MethodHandleType.INVOKE_DIRECT;
            }
            case 8: {
                return MethodHandleType.INVOKE_CONSTRUCTOR;
            }
            case 9: {
                return MethodHandleType.INVOKE_INTERFACE;
            }
        }
        throw new IllegalArgumentException("Unknown method handle type: " + kind);
    }

    public String getUtf8(int idx) {
        if (idx == 0) {
            return null;
        }
        this.jumpToData(idx);
        return this.readString();
    }

    public ConstantType jumpToConst(int idx) {
        this.jumpToTag(idx);
        return ConstantType.getTypeByTag(this.data.readU1());
    }

    public String readString() {
        int len = this.data.readU2();
        byte[] bytes = this.data.readBytes(len);
        return this.parseString(bytes);
    }

    public int readU2() {
        return this.data.readU2();
    }

    public int readU4() {
        return this.data.readU4();
    }

    public long readU8() {
        return this.data.readU8();
    }

    public int getInt(int idx) {
        this.jumpToData(idx);
        return this.data.readS4();
    }

    public long getLong(int idx) {
        this.jumpToData(idx);
        return this.data.readS8();
    }

    public double getDouble(int idx) {
        this.jumpToData(idx);
        return Double.longBitsToDouble(this.data.readU8());
    }

    public float getFloat(int idx) {
        this.jumpToData(idx);
        return Float.intBitsToFloat(this.data.readU4());
    }

    public EncodedValue readAsEncodedValue(int idx) {
        ConstantType constantType = this.jumpToConst(idx);
        switch (constantType) {
            case UTF8: {
                return new EncodedValue(EncodedType.ENCODED_STRING, (Object)this.readString());
            }
            case STRING: {
                return new EncodedValue(EncodedType.ENCODED_STRING, (Object)this.getUtf8(this.readU2()));
            }
            case INTEGER: {
                return new EncodedValue(EncodedType.ENCODED_INT, (Object)this.data.readS4());
            }
            case FLOAT: {
                return new EncodedValue(EncodedType.ENCODED_FLOAT, (Object)Float.valueOf(Float.intBitsToFloat(this.data.readU4())));
            }
            case LONG: {
                return new EncodedValue(EncodedType.ENCODED_LONG, (Object)this.data.readS8());
            }
            case DOUBLE: {
                return new EncodedValue(EncodedType.ENCODED_DOUBLE, (Object)Double.longBitsToDouble(this.data.readU8()));
            }
            case CLASS: {
                return new EncodedValue(EncodedType.ENCODED_TYPE, (Object)this.getClass(idx));
            }
            case METHOD_TYPE: {
                return new EncodedValue(EncodedType.ENCODED_METHOD_TYPE, (Object)DescriptorParser.parseToMethodProto(this.getUtf8(this.readU2())));
            }
            case METHOD_HANDLE: {
                return new EncodedValue(EncodedType.ENCODED_METHOD_HANDLE, (Object)this.getMethodHandle(idx));
            }
        }
        throw new JavaClassParseException("Can't encode constant " + constantType + " as encoded value");
    }

    @NotNull
    private String parseString(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private String fixType(String clsName) {
        switch (clsName.charAt(0)) {
            case '[': {
                return clsName;
            }
            case 'L': 
            case 'T': {
                if (!clsName.endsWith(";")) break;
                return clsName;
            }
        }
        return "L" + clsName + ";";
    }

    private void jumpToData(int idx) {
        this.data.absPos(this.offsets.getOffsetOfConstEntry(idx));
    }

    private void jumpToTag(int idx) {
        this.data.absPos(this.offsets.getOffsetOfConstEntry(idx) - 1);
    }
}

