/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.action;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import jadx.core.utils.GsonUtils;
import jadx.gui.treemodel.JNode;
import jadx.gui.ui.action.ActionModel;
import jadx.gui.ui.action.JNodeAction;
import jadx.gui.ui.codearea.CodeArea;

public class JsonPrettifyAction
extends JNodeAction {
    private static final long serialVersionUID = -2682529369671695550L;
    private static final Gson GSON = GsonUtils.buildGson();

    public JsonPrettifyAction(CodeArea codeArea) {
        super(ActionModel.JSON_PRETTIFY, codeArea);
    }

    @Override
    public void runAction(JNode node) {
        String originString = this.getCodeArea().getCodeInfo().getCodeStr();
        JsonElement je = JsonParser.parseString((String)originString);
        String prettyString = GSON.toJson(je);
        this.getCodeArea().setText(prettyString);
    }

    @Override
    public boolean isActionEnabled(JNode node) {
        return true;
    }
}

