/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.action;

import jadx.api.JavaClass;
import jadx.api.JavaField;
import jadx.api.JavaMethod;
import jadx.api.metadata.annotations.VarNode;
import jadx.core.codegen.TypeGen;
import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.utils.StringUtils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JField;
import jadx.gui.treemodel.JMethod;
import jadx.gui.treemodel.JNode;
import jadx.gui.ui.action.ActionModel;
import jadx.gui.ui.action.JNodeAction;
import jadx.gui.ui.codearea.CodeArea;
import jadx.gui.ui.dialog.MethodsDialog;
import jadx.gui.utils.NLS;
import jadx.gui.utils.UiUtils;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FridaAction
extends JNodeAction {
    private static final Logger LOG = LoggerFactory.getLogger(FridaAction.class);
    private static final long serialVersionUID = -3084073927621269039L;

    public FridaAction(CodeArea codeArea) {
        super(ActionModel.FRIDA_COPY, codeArea);
    }

    @Override
    public void runAction(JNode node) {
        try {
            this.generateFridaSnippet(node);
        }
        catch (Exception e) {
            LOG.error("Failed to generate Frida code snippet", (Throwable)e);
            JOptionPane.showMessageDialog(this.getCodeArea().getMainWindow(), e.getLocalizedMessage(), NLS.str("error_dialog.title"), 0);
        }
    }

    @Override
    public boolean isActionEnabled(JNode node) {
        return node instanceof JMethod || node instanceof JClass || node instanceof JField;
    }

    private void generateFridaSnippet(JNode node) {
        if (node instanceof JMethod) {
            String fridaSnippet = this.generateMethodSnippet((JMethod)node);
            this.copySnipped(fridaSnippet);
        } else if (node instanceof JField) {
            String fridaSnippet = this.generateFieldSnippet((JField)node);
            this.copySnipped(fridaSnippet);
        } else if (node instanceof JClass) {
            SwingUtilities.invokeLater(() -> this.showMethodSelectionDialog((JClass)node));
        } else {
            throw new JadxRuntimeException("Unsupported node type: " + String.valueOf(node != null ? node.getClass() : "null"));
        }
    }

    private void copySnipped(String fridaSnippet) {
        if (!StringUtils.isEmpty((String)fridaSnippet)) {
            LOG.info("Frida snippet:\n{}", (Object)fridaSnippet);
            UiUtils.copyToClipboard(fridaSnippet);
        }
    }

    private String generateMethodSnippet(JMethod jMth) {
        String classSnippet = this.generateClassSnippet(jMth.getJParent());
        String methodSnippet = this.getMethodSnippet(jMth.getJavaMethod(), jMth.getJParent());
        return String.format("%s\n%s", classSnippet, methodSnippet);
    }

    private String generateMethodSnippet(JavaMethod javaMethod, JClass jc) {
        return this.getMethodSnippet(javaMethod, jc);
    }

    private String getMethodSnippet(JavaMethod javaMethod, JClass jc) {
        Object overload;
        String newMethodName;
        String methodName;
        MethodNode mth = javaMethod.getMethodNode();
        MethodInfo methodInfo = mth.getMethodInfo();
        if (methodInfo.isConstructor()) {
            newMethodName = methodName = "$init";
        } else {
            methodName = StringEscapeUtils.escapeEcmaScript((String)methodInfo.getName());
            newMethodName = StringEscapeUtils.escapeEcmaScript((String)methodInfo.getAlias());
        }
        if (this.isOverloaded(mth).booleanValue()) {
            String overloadArgs = methodInfo.getArgumentsTypes().stream().map(this::parseArgType).collect(Collectors.joining(", "));
            overload = ".overload(" + overloadArgs + ")";
        } else {
            overload = "";
        }
        List argNames = mth.collectArgNodes().stream().map(VarNode::getName).collect(Collectors.toList());
        String args = String.join((CharSequence)", ", argNames);
        Object logArgs = argNames.isEmpty() ? "" : ": " + argNames.stream().map(arg -> arg + "=${" + arg + "}").collect(Collectors.joining(", "));
        String shortClassName = mth.getParentClass().getAlias();
        if (methodInfo.isConstructor() || methodInfo.getReturnType() == ArgType.VOID) {
            return shortClassName + "[\"" + methodName + "\"]" + (String)overload + ".implementation = function (" + args + ") {\n    console.log(`" + shortClassName + "." + newMethodName + " is called" + (String)logArgs + "`);\n    this[\"" + methodName + "\"](" + args + ");\n};";
        }
        return shortClassName + "[\"" + methodName + "\"]" + (String)overload + ".implementation = function (" + args + ") {\n    console.log(`" + shortClassName + "." + newMethodName + " is called" + (String)logArgs + "`);\n    let result = this[\"" + methodName + "\"](" + args + ");\n    console.log(`" + shortClassName + "." + newMethodName + " result=${result}`);\n    return result;\n};";
    }

    private String generateClassSnippet(JClass jc) {
        JavaClass javaClass = jc.getCls();
        String rawClassName = StringEscapeUtils.escapeEcmaScript((String)javaClass.getRawName());
        String shortClassName = javaClass.getName();
        return String.format("var %s = Java.use(\"%s\");", shortClassName, rawClassName);
    }

    private void showMethodSelectionDialog(JClass jc) {
        JavaClass javaClass = jc.getCls();
        new MethodsDialog(this.getCodeArea().getMainWindow(), javaClass.getMethods(), result -> {
            String fridaSnippet = this.generateClassAllMethodSnippet(jc, (List<JavaMethod>)result);
            this.copySnipped(fridaSnippet);
        });
    }

    private String generateClassAllMethodSnippet(JClass jc, List<JavaMethod> methodList) {
        StringBuilder result = new StringBuilder();
        String classSnippet = this.generateClassSnippet(jc);
        result.append(classSnippet).append("\n");
        for (JavaMethod javaMethod : methodList) {
            result.append(this.generateMethodSnippet(javaMethod, jc)).append("\n");
        }
        return result.toString();
    }

    private String generateFieldSnippet(JField jf) {
        JavaField javaField = jf.getJavaField();
        Object rawFieldName = StringEscapeUtils.escapeEcmaScript((String)javaField.getRawName());
        String fieldName = javaField.getName();
        List methodNodes = javaField.getFieldNode().getParentClass().getMethods();
        for (MethodNode methodNode : methodNodes) {
            if (!methodNode.getName().equals(rawFieldName)) continue;
            rawFieldName = "_" + (String)rawFieldName;
            break;
        }
        JClass jc = jf.getRootClass();
        String classSnippet = this.generateClassSnippet(jc);
        return String.format("%s\n%s = %s.%s.value;", classSnippet, fieldName, jc.getName(), rawFieldName);
    }

    public Boolean isOverloaded(MethodNode methodNode) {
        return methodNode.getParentClass().getMethods().stream().anyMatch(m -> m.getName().equals(methodNode.getName()) && !Objects.equals(methodNode.getMethodInfo().getShortId(), m.getMethodInfo().getShortId()));
    }

    private String parseArgType(ArgType x) {
        String typeStr = x.isArray() ? TypeGen.signature((ArgType)x).replace("/", ".") : x.toString();
        return "'" + typeStr + "'";
    }
}

