/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.events.services;

import jadx.api.JadxDecompiler;
import jadx.api.JavaNode;
import jadx.api.data.ICodeRename;
import jadx.api.data.impl.JadxCodeData;
import jadx.api.plugins.events.JadxEvents;
import jadx.api.plugins.events.types.NodeRenamedByUser;
import jadx.core.utils.Utils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.gui.jobs.TaskStatus;
import jadx.gui.settings.JadxProject;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JNode;
import jadx.gui.treemodel.JRenameNode;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.codearea.ClassCodeContentPanel;
import jadx.gui.ui.codearea.CodeArea;
import jadx.gui.ui.panel.ContentPanel;
import jadx.gui.ui.tab.TabbedPane;
import jadx.gui.utils.CacheObject;
import jadx.gui.utils.JNodeCache;
import jadx.gui.utils.NLS;
import jadx.gui.utils.UiUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenameService {
    private static final Logger LOG = LoggerFactory.getLogger(RenameService.class);
    private final MainWindow mainWindow;

    public static void init(MainWindow mainWindow) {
        RenameService renameService = new RenameService(mainWindow);
        mainWindow.events().global().addListener(JadxEvents.NODE_RENAMED_BY_USER, renameService::process);
    }

    private RenameService(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
    }

    private void process(NodeRenamedByUser event) {
        try {
            LOG.debug("Applying rename event: {}", (Object)event);
            JRenameNode node = this.getRenameNode(event);
            this.updateCodeRenames(set -> this.processRename(node, event, (Set<ICodeRename>)set));
            this.refreshState(node);
        }
        catch (Exception e) {
            LOG.error("Rename failed", (Throwable)e);
            UiUtils.errorMessage(this.mainWindow, "Rename failed:\n" + Utils.getStackTrace((Throwable)e));
        }
    }

    @NotNull
    private JRenameNode getRenameNode(NodeRenamedByUser event) {
        JNode node;
        Object renameNode = event.getRenameNode();
        if (renameNode instanceof JRenameNode) {
            return (JRenameNode)renameNode;
        }
        JadxDecompiler decompiler = this.mainWindow.getWrapper().getDecompiler();
        JavaNode javaNode = decompiler.getJavaNodeByRef(event.getNode());
        if (javaNode != null && (node = this.mainWindow.getCacheObject().getNodeCache().makeFrom(javaNode)) instanceof JRenameNode) {
            return (JRenameNode)((Object)node);
        }
        throw new JadxRuntimeException("Failed to resolve node: " + String.valueOf(event.getNode()));
    }

    private void processRename(JRenameNode node, NodeRenamedByUser event, Set<ICodeRename> renames) {
        ICodeRename rename = node.buildCodeRename(event.getNewName(), renames);
        renames.remove(rename);
        if (event.isResetName() || event.getNewName().isEmpty()) {
            node.removeAlias();
        } else {
            renames.add(rename);
        }
    }

    private void updateCodeRenames(Consumer<Set<ICodeRename>> updater) {
        JadxProject project = this.mainWindow.getProject();
        JadxCodeData codeData = project.getCodeData();
        if (codeData == null) {
            codeData = new JadxCodeData();
        }
        HashSet set = new HashSet(codeData.getRenames());
        updater.accept(set);
        ArrayList list = new ArrayList(set);
        Collections.sort(list);
        codeData.setRenames(list);
        project.setCodeData(codeData);
    }

    private void refreshState(JRenameNode node) {
        ArrayList<JavaNode> toUpdate = new ArrayList<JavaNode>();
        node.addUpdateNodes(toUpdate);
        JNodeCache nodeCache = this.mainWindow.getCacheObject().getNodeCache();
        Set updatedTopClasses = toUpdate.stream().map(JavaNode::getTopParentClass).map(nodeCache::makeFrom).filter(Objects::nonNull).collect(Collectors.toSet());
        LOG.debug("Classes to update: {}", updatedTopClasses);
        if (updatedTopClasses.isEmpty()) {
            return;
        }
        this.mainWindow.getBackgroundExecutor().execute("Refreshing", () -> {
            this.mainWindow.getWrapper().reloadCodeData();
            UiUtils.uiRunAndWait(() -> this.refreshTabs(this.mainWindow.getTabbedPane(), updatedTopClasses));
            this.refreshClasses(updatedTopClasses);
        }, status -> {
            if (status == TaskStatus.CANCEL_BY_MEMORY) {
                this.mainWindow.showHeapUsageBar();
                UiUtils.errorMessage(this.mainWindow, NLS.str("message.memoryLow"));
            }
            node.reload(this.mainWindow);
        });
    }

    private void refreshClasses(Set<JClass> updatedTopClasses) {
        CacheObject cache = this.mainWindow.getCacheObject();
        if (updatedTopClasses.size() < 10) {
            LOG.debug("Classes to reload: {}", (Object)updatedTopClasses.size());
            for (JClass cls : updatedTopClasses) {
                try {
                    cls.reload(cache);
                }
                catch (Exception e) {
                    LOG.error("Failed to reload class: {}", (Object)cls.getFullName(), (Object)e);
                }
            }
        } else {
            LOG.debug("Classes to unload: {}", (Object)updatedTopClasses.size());
            for (JClass cls : updatedTopClasses) {
                try {
                    cls.unload(cache);
                }
                catch (Exception e) {
                    LOG.error("Failed to unload class: {}", (Object)cls.getFullName(), (Object)e);
                }
            }
        }
    }

    private void refreshTabs(TabbedPane tabbedPane, Set<JClass> updatedClasses) {
        for (ContentPanel tab : tabbedPane.getTabs()) {
            JClass rootClass = tab.getNode().getRootClass();
            if (!updatedClasses.remove(rootClass)) continue;
            ClassCodeContentPanel contentPanel = (ClassCodeContentPanel)tab;
            CodeArea codeArea = (CodeArea)contentPanel.getJavaCodePanel().getCodeArea();
            codeArea.refreshClass();
        }
    }
}

