/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.settings.ui.plugins;

import jadx.gui.settings.ui.plugins.PluginSettings;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.filedialog.FileDialogWrapper;
import jadx.gui.ui.filedialog.FileOpenMode;
import jadx.gui.utils.NLS;
import jadx.gui.utils.TextStandardActions;
import jadx.gui.utils.UiUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstallPluginDialog
extends JDialog {
    private static final Logger LOG = LoggerFactory.getLogger(InstallPluginDialog.class);
    private static final long serialVersionUID = 5304314264730563853L;
    private final MainWindow mainWindow;
    private final PluginSettings pluginsSettings;
    private JTextField locationFld;

    public InstallPluginDialog(MainWindow mainWindow, PluginSettings pluginsSettings) {
        super((Frame)mainWindow, NLS.str("preferences.plugins.install"));
        this.mainWindow = mainWindow;
        this.pluginsSettings = pluginsSettings;
        this.init();
    }

    private void init() {
        this.locationFld = new JTextField();
        this.locationFld.setAlignmentX(0.0f);
        this.locationFld.setColumns(50);
        TextStandardActions.attach(this.locationFld);
        this.locationFld.putClientProperty("JTextField.showClearButton", true);
        JLabel locationLbl = new JLabel(NLS.str("preferences.plugins.location_id_label"));
        locationLbl.setLabelFor(this.locationFld);
        JPanel locationPanel = new JPanel();
        locationPanel.setLayout(new BoxLayout(locationPanel, 2));
        locationPanel.add(locationLbl);
        locationPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        locationPanel.add(this.locationFld);
        JButton fileBtn = new JButton(NLS.str("preferences.plugins.plugin_jar"));
        fileBtn.addActionListener(ev -> this.openPluginJar());
        JLabel fileLbl = new JLabel(NLS.str("preferences.plugins.plugin_jar_label"));
        fileLbl.setLabelFor(fileBtn);
        JPanel filePanel = new JPanel();
        filePanel.setLayout(new BoxLayout(filePanel, 2));
        filePanel.add(fileLbl);
        filePanel.add(Box.createRigidArea(new Dimension(5, 0)));
        filePanel.add(fileBtn);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(locationPanel);
        mainPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        mainPanel.add(filePanel);
        JButton installBtn = new JButton(NLS.str("preferences.plugins.install_btn"));
        installBtn.addActionListener(ev -> this.install());
        JButton cancelBtn = new JButton(NLS.str("preferences.cancel"));
        cancelBtn.addActionListener(ev -> this.dispose());
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 2));
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(installBtn);
        buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPane.add(cancelBtn);
        this.getRootPane().setDefaultButton(installBtn);
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout(5, 5));
        contentPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        contentPanel.add((Component)mainPanel, "First");
        contentPanel.add((Component)buttonPane, "Last");
        this.getContentPane().add(contentPanel);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        UiUtils.addEscapeShortCutToDispose(this);
    }

    private void openPluginJar() {
        FileDialogWrapper fd = new FileDialogWrapper(this.mainWindow, FileOpenMode.CUSTOM_OPEN);
        fd.setTitle(NLS.str("preferences.plugins.plugin_jar"));
        fd.setFileExtList(Collections.singletonList("jar"));
        fd.setSelectionMode(0);
        List<Path> files = fd.show();
        if (files.size() == 1) {
            this.locationFld.setText("file:" + String.valueOf(files.get(0).toAbsolutePath()));
        }
    }

    private void install() {
        this.pluginsSettings.install(this.locationFld.getText());
        this.dispose();
    }
}

