/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.settings.ui.cache;

import jadx.api.plugins.utils.CommonFileUtils;
import jadx.gui.cache.manager.CacheEntry;
import java.nio.file.Paths;

final class TableRow {
    private final CacheEntry cacheEntry;
    private final String project;
    private String usage;
    private boolean selected = false;

    public TableRow(CacheEntry cacheEntry) {
        this.cacheEntry = cacheEntry;
        this.project = this.cutProjectName(cacheEntry.getProject());
        this.usage = "-";
    }

    private String cutProjectName(String project) {
        if (project.startsWith("tmp:")) {
            int hashStart = project.lastIndexOf(45);
            int endIdx = hashStart != -1 ? hashStart : project.length();
            return project.substring(4, endIdx) + " (Temp)";
        }
        return CommonFileUtils.removeFileExtension((String)Paths.get(project, new String[0]).getFileName().toString());
    }

    public CacheEntry getCacheEntry() {
        return this.cacheEntry;
    }

    public String getProject() {
        return this.project;
    }

    public String getUsage() {
        return this.usage;
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }
}

