/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.settings;

import jadx.core.utils.StringUtils;
import jadx.core.utils.files.FileUtils;
import jadx.gui.JadxGUI;
import jadx.gui.utils.files.JadxFiles;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.prefs.Preferences;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JadxSettingsStorage {
    private static final Logger LOG = LoggerFactory.getLogger(JadxSettingsStorage.class);
    private final Path configFile = JadxSettingsStorage.initConfigFile();

    @Nullable
    public synchronized String load() throws IOException {
        if (Files.exists(this.configFile, new LinkOption[0])) {
            return FileUtils.readFile((Path)this.configFile);
        }
        return null;
    }

    public synchronized void save(String jsonStr) throws IOException {
        FileUtils.writeFile((Path)this.configFile, (String)jsonStr);
    }

    private static Path initConfigFile() {
        Path confPath = JadxFiles.GUI_CONF;
        if (!Files.exists(confPath, new LinkOption[0])) {
            JadxSettingsStorage.copyFromPreferences(confPath);
        }
        LOG.debug("Using config: {}", (Object)confPath);
        return confPath;
    }

    private static void copyFromPreferences(Path confPath) {
        try {
            Preferences prefs = Preferences.userNodeForPackage(JadxGUI.class);
            String str = prefs.get("jadx.gui.settings", "");
            if (StringUtils.notEmpty((String)str)) {
                FileUtils.writeFile((Path)confPath, (String)str);
                LOG.warn("Settings moved from java preferences to config file: {}", (Object)confPath);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to load settings from preferences", (Throwable)e);
        }
    }
}

