/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.plugins.context;

import jadx.api.JadxDecompiler;
import jadx.api.JavaClass;
import jadx.api.JavaNode;
import jadx.api.gui.tree.ITreeNode;
import jadx.api.metadata.ICodeNodeRef;
import jadx.api.plugins.events.IJadxEvent;
import jadx.api.plugins.events.types.NodeRenamedByUser;
import jadx.api.plugins.gui.ISettingsGroup;
import jadx.api.plugins.gui.JadxGuiContext;
import jadx.api.plugins.gui.JadxGuiSettings;
import jadx.core.plugins.PluginContext;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.gui.events.types.JadxGuiEventsImpl;
import jadx.gui.plugins.context.CodePopupAction;
import jadx.gui.plugins.context.CommonGuiPluginsContext;
import jadx.gui.plugins.context.GuiSettingsContext;
import jadx.gui.plugins.context.TreePopupMenuEntry;
import jadx.gui.treemodel.JNode;
import jadx.gui.ui.codearea.AbstractCodeArea;
import jadx.gui.ui.codearea.AbstractCodeContentPanel;
import jadx.gui.ui.codearea.CodeArea;
import jadx.gui.ui.dialog.UsageDialog;
import jadx.gui.ui.panel.ContentPanel;
import jadx.gui.utils.IconsCache;
import jadx.gui.utils.UiUtils;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuiPluginContext
implements JadxGuiContext {
    private static final Logger LOG = LoggerFactory.getLogger(GuiPluginContext.class);
    private final CommonGuiPluginsContext commonContext;
    private final PluginContext pluginContext;
    @Nullable
    private ISettingsGroup customSettingsGroup;

    public GuiPluginContext(CommonGuiPluginsContext commonContext, PluginContext pluginContext) {
        this.commonContext = commonContext;
        this.pluginContext = pluginContext;
    }

    public CommonGuiPluginsContext getCommonContext() {
        return this.commonContext;
    }

    public PluginContext getPluginContext() {
        return this.pluginContext;
    }

    public JFrame getMainFrame() {
        return this.commonContext.getMainWindow();
    }

    public void uiRun(Runnable runnable) {
        UiUtils.uiRun(runnable);
    }

    public void addMenuAction(String name, Runnable action) {
        this.commonContext.addMenuAction(name, action);
    }

    public void addPopupMenuAction(String name, @Nullable Function<ICodeNodeRef, Boolean> enabled, @Nullable String keyBinding, Consumer<ICodeNodeRef> action) {
        this.commonContext.getCodePopupActionList().add(new CodePopupAction(name, enabled, keyBinding, action));
    }

    public void addTreePopupMenuEntry(String name, Predicate<ITreeNode> addPredicate, Consumer<ITreeNode> action) {
        this.commonContext.getTreePopupMenuEntries().add(new TreePopupMenuEntry(name, addPredicate, action));
    }

    public boolean registerGlobalKeyBinding(String id, String keyBinding, Runnable action) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(keyBinding);
        if (keyStroke == null) {
            throw new IllegalArgumentException("Failed to parse key binding: " + keyBinding);
        }
        JPanel mainPanel = (JPanel)this.commonContext.getMainWindow().getContentPane();
        Object prevBinding = mainPanel.getInputMap().get(keyStroke);
        if (prevBinding != null) {
            return false;
        }
        UiUtils.addKeyBinding((JComponent)mainPanel, keyStroke, id, action);
        return true;
    }

    public void copyToClipboard(String str) {
        UiUtils.copyToClipboard(str);
    }

    public JadxGuiSettings settings() {
        return new GuiSettingsContext(this);
    }

    void setCustomSettings(ISettingsGroup customSettingsGroup) {
        this.customSettingsGroup = customSettingsGroup;
    }

    @Nullable
    public ISettingsGroup getCustomSettingsGroup() {
        return this.customSettingsGroup;
    }

    @Nullable
    private CodeArea getCodeArea() {
        AbstractCodeArea codeArea;
        ContentPanel contentPane = this.commonContext.getMainWindow().getTabbedPane().getSelectedContentPanel();
        if (contentPane instanceof AbstractCodeContentPanel && (codeArea = ((AbstractCodeContentPanel)contentPane).getCodeArea()) instanceof CodeArea) {
            return (CodeArea)codeArea;
        }
        return null;
    }

    public ImageIcon getSVGIcon(String name) {
        try {
            return IconsCache.getSVGIcon(name);
        }
        catch (Exception e) {
            LOG.error("Failed to load icon: {}", (Object)name, (Object)e);
            return IconsCache.getSVGIcon("ui/error");
        }
    }

    public ICodeNodeRef getNodeUnderCaret() {
        JNode nodeUnderCaret;
        CodeArea codeArea = this.getCodeArea();
        if (codeArea != null && (nodeUnderCaret = codeArea.getNodeUnderCaret()) != null) {
            return nodeUnderCaret.getCodeNodeRef();
        }
        return null;
    }

    public ICodeNodeRef getNodeUnderMouse() {
        JNode nodeUnderMouse;
        CodeArea codeArea = this.getCodeArea();
        if (codeArea != null && (nodeUnderMouse = codeArea.getNodeUnderMouse()) != null) {
            return nodeUnderMouse.getCodeNodeRef();
        }
        return null;
    }

    public ICodeNodeRef getEnclosingNodeUnderCaret() {
        JNode nodeUnderMouse;
        CodeArea codeArea = this.getCodeArea();
        if (codeArea != null && (nodeUnderMouse = codeArea.getEnclosingNodeUnderCaret()) != null) {
            return nodeUnderMouse.getCodeNodeRef();
        }
        return null;
    }

    public ICodeNodeRef getEnclosingNodeUnderMouse() {
        JNode nodeUnderMouse;
        CodeArea codeArea = this.getCodeArea();
        if (codeArea != null && (nodeUnderMouse = codeArea.getEnclosingNodeUnderMouse()) != null) {
            return nodeUnderMouse.getCodeNodeRef();
        }
        return null;
    }

    public boolean open(ICodeNodeRef ref) {
        this.commonContext.getMainWindow().getTabsController().codeJump(this.getJNodeFromRef(ref));
        return true;
    }

    public void openUsageDialog(ICodeNodeRef ref) {
        UsageDialog.open(this.commonContext.getMainWindow(), this.getJNodeFromRef(ref));
    }

    private JNode getJNodeFromRef(ICodeNodeRef ref) {
        return this.commonContext.getMainWindow().getCacheObject().getNodeCache().makeFrom(ref);
    }

    public void reloadActiveTab() {
        UiUtils.uiRun(() -> {
            CodeArea codeArea = this.getCodeArea();
            if (codeArea != null) {
                codeArea.refreshClass();
            }
        });
    }

    public void reloadAllTabs() {
        UiUtils.uiRun(() -> {
            for (ContentPanel contentPane : this.commonContext.getMainWindow().getTabbedPane().getTabs()) {
                AbstractCodeArea codeArea;
                if (!(contentPane instanceof AbstractCodeContentPanel) || !((codeArea = ((AbstractCodeContentPanel)contentPane).getCodeArea()) instanceof CodeArea)) continue;
                ((CodeArea)codeArea).refreshClass();
            }
        });
    }

    public void applyNodeRename(ICodeNodeRef nodeRef) {
        JadxDecompiler decompiler = this.commonContext.getMainWindow().getWrapper().getDecompiler();
        JavaNode javaNode = decompiler.getJavaNodeByRef(nodeRef);
        if (javaNode == null) {
            throw new JadxRuntimeException("Failed to resolve node ref: " + String.valueOf(nodeRef));
        }
        String newName = javaNode instanceof JavaClass ? javaNode.getFullName() : javaNode.getName();
        JadxGuiEventsImpl events = this.commonContext.getMainWindow().events();
        events.send((IJadxEvent)new NodeRenamedByUser(nodeRef, "", newName));
    }
}

