/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.utils.ui;

import jadx.gui.utils.UiUtils;
import jadx.gui.utils.shortcut.Shortcut;
import java.awt.event.ActionEvent;
import java.util.function.Consumer;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;

public class ActionHandler
extends AbstractAction {
    private final Consumer<ActionEvent> consumer;

    public ActionHandler(Runnable action) {
        this.consumer = ev -> action.run();
    }

    public ActionHandler(Consumer<ActionEvent> consumer) {
        this.consumer = consumer;
    }

    public ActionHandler(String name, Runnable action) {
        this(action);
        this.setName(name);
    }

    public ActionHandler() {
        this.consumer = ev -> {};
    }

    public void setName(String name) {
        this.putValue("Name", name);
    }

    public ActionHandler withNameAndDesc(String name) {
        this.setNameAndDesc(name);
        return this;
    }

    public void setNameAndDesc(String name) {
        this.setName(name);
        this.setShortDescription(name);
    }

    public void setShortDescription(String desc) {
        this.putValue("ShortDescription", desc);
    }

    public void setIcon(Icon icon) {
        this.putValue("SmallIcon", icon);
    }

    public void setSelected(boolean selected) {
        this.putValue("SwingSelectedKey", selected);
    }

    public void setKeyBinding(KeyStroke keyStroke) {
        this.putValue("AcceleratorKey", keyStroke);
    }

    public void attachKeyBindingFor(JComponent component, KeyStroke keyStroke) {
        UiUtils.addKeyBinding(component, keyStroke, "run", this);
        this.setKeyBinding(keyStroke);
    }

    public void addKeyBindToDescription() {
        KeyStroke keyStroke = (KeyStroke)this.getValue("AcceleratorKey");
        if (keyStroke != null) {
            String keyText = Shortcut.keyboard(keyStroke.getKeyCode(), keyStroke.getModifiers()).toString();
            String desc = (String)this.getValue("ShortDescription");
            this.setShortDescription(desc + " (" + keyText + ")");
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.consumer.accept(e);
    }

    public JButton makeButton() {
        this.addKeyBindToDescription();
        return new JButton(this);
    }

    public JToggleButton makeToggleButton() {
        JToggleButton toggleButton = new JToggleButton(this);
        toggleButton.setText("");
        return toggleButton;
    }

    public JCheckBoxMenuItem makeCheckBoxMenuItem() {
        return new JCheckBoxMenuItem(this);
    }
}

