/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.utils.rx;

import io.reactivex.rxjava3.core.BackpressureStrategy;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableEmitter;
import io.reactivex.rxjava3.core.FlowableOnSubscribe;
import io.reactivex.rxjava3.disposables.Disposable;
import jadx.gui.utils.rx.CustomDisposable;
import jadx.gui.utils.ui.DocumentUpdateListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.function.Supplier;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;

public class RxUtils {
    public static Flowable<String> textFieldChanges(JTextField textField) {
        FlowableOnSubscribe source = emitter -> {
            DocumentUpdateListener listener = new DocumentUpdateListener(ev -> emitter.onNext((Object)textField.getText()));
            textField.getDocument().addDocumentListener(listener);
            emitter.setDisposable((Disposable)new CustomDisposable(() -> textField.getDocument().removeDocumentListener(listener)));
        };
        return Flowable.create((FlowableOnSubscribe)source, (BackpressureStrategy)BackpressureStrategy.LATEST).distinctUntilChanged();
    }

    public static Flowable<String> textFieldEnterPress(JTextField textField) {
        FlowableOnSubscribe source = emitter -> {
            KeyListener keyListener = RxUtils.enterKeyListener((FlowableEmitter<String>)emitter, textField::getText);
            textField.addKeyListener(keyListener);
            emitter.setDisposable((Disposable)new CustomDisposable(() -> textField.removeKeyListener(keyListener)));
        };
        return Flowable.create((FlowableOnSubscribe)source, (BackpressureStrategy)BackpressureStrategy.LATEST).distinctUntilChanged();
    }

    public static Flowable<String> spinnerChanges(JSpinner spinner) {
        FlowableOnSubscribe source = emitter -> {
            ChangeListener changeListener = e -> emitter.onNext((Object)String.valueOf(spinner.getValue()));
            spinner.addChangeListener(changeListener);
            emitter.setDisposable((Disposable)new CustomDisposable(() -> spinner.removeChangeListener(changeListener)));
        };
        return Flowable.create((FlowableOnSubscribe)source, (BackpressureStrategy)BackpressureStrategy.LATEST).distinctUntilChanged();
    }

    public static Flowable<String> spinnerEnterPress(JSpinner spinner) {
        FlowableOnSubscribe source = emitter -> {
            KeyListener keyListener = RxUtils.enterKeyListener((FlowableEmitter<String>)emitter, () -> String.valueOf(spinner.getValue()));
            spinner.addKeyListener(keyListener);
            emitter.setDisposable((Disposable)new CustomDisposable(() -> spinner.removeKeyListener(keyListener)));
        };
        return Flowable.create((FlowableOnSubscribe)source, (BackpressureStrategy)BackpressureStrategy.LATEST).distinctUntilChanged();
    }

    @NotNull
    private static KeyListener enterKeyListener(final FlowableEmitter<String> emitter, final Supplier<String> supplier) {
        return new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent ev) {
                if (ev.getKeyCode() == 10) {
                    emitter.onNext((Object)((String)supplier.get()));
                }
            }
        };
    }
}

