/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.utils;

import jadx.gui.JadxWrapper;
import jadx.gui.ui.dialog.SearchDialog;
import jadx.gui.utils.JNodeCache;
import jadx.gui.utils.pkgs.PackageHelper;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class CacheObject {
    private final JadxWrapper wrapper;
    private final JNodeCache jNodeCache;
    private final PackageHelper packageHelper;
    private String lastSearch;
    private Map<SearchDialog.SearchPreset, Set<SearchDialog.SearchOptions>> lastSearchOptions;
    private String lastSearchPackage;
    private int maxPkgLength;
    private volatile boolean fullDecompilationFinished;

    public CacheObject(JadxWrapper wrapper) {
        this.wrapper = wrapper;
        this.jNodeCache = new JNodeCache(wrapper);
        this.packageHelper = new PackageHelper(wrapper, this.jNodeCache);
        this.reset();
    }

    public void reset() {
        this.lastSearch = null;
        this.jNodeCache.reset();
        this.lastSearchOptions = new HashMap<SearchDialog.SearchPreset, Set<SearchDialog.SearchOptions>>();
        this.lastSearchPackage = null;
        this.fullDecompilationFinished = false;
    }

    @Nullable
    public String getLastSearch() {
        return this.lastSearch;
    }

    @Nullable
    public String getLastSearchPackage() {
        return this.lastSearchPackage;
    }

    public void setLastSearch(String lastSearch) {
        this.lastSearch = lastSearch;
    }

    public void setLastSearchPackage(String lastSearchPackage) {
        this.lastSearchPackage = lastSearchPackage;
    }

    public int getMaxPkgLength() {
        return this.maxPkgLength;
    }

    public void setMaxPkgLength(int maxPkgLength) {
        this.maxPkgLength = maxPkgLength;
    }

    public JNodeCache getNodeCache() {
        return this.jNodeCache;
    }

    public Map<SearchDialog.SearchPreset, Set<SearchDialog.SearchOptions>> getLastSearchOptions() {
        return this.lastSearchOptions;
    }

    public PackageHelper getPackageHelper() {
        return this.packageHelper;
    }

    public boolean isFullDecompilationFinished() {
        return this.fullDecompilationFinished;
    }

    public void setFullDecompilationFinished(boolean fullDecompilationFinished) {
        this.fullDecompilationFinished = fullDecompilationFinished;
    }
}

