/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.popupmenu;

import jadx.gui.JadxWrapper;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JPackage;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.dialog.ExcludePkgDialog;
import jadx.gui.ui.dialog.RenameDialog;
import jadx.gui.ui.dialog.SearchDialog;
import jadx.gui.ui.filedialog.FileDialogWrapper;
import jadx.gui.ui.filedialog.FileOpenMode;
import jadx.gui.ui.popupmenu.JClassExportType;
import jadx.gui.ui.popupmenu.JClassPopupMenu;
import jadx.gui.utils.NLS;
import jadx.gui.utils.pkgs.JRenamePackage;
import jadx.gui.utils.pkgs.PackageHelper;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JPackagePopupMenu
extends JPopupMenu {
    private static final long serialVersionUID = -7781009781149224131L;
    private static final Logger LOG = LoggerFactory.getLogger(JPackagePopupMenu.class);
    private final transient MainWindow mainWindow;

    public JPackagePopupMenu(MainWindow mainWindow, JPackage pkg) {
        this.mainWindow = mainWindow;
        this.add(this.makeExcludeItem(pkg));
        this.add(this.makeExcludeItem());
        this.add(this.makeRenameMenuItem(pkg));
        this.add(this.makeExportSubMenu(pkg));
        this.add(this.makeSearchItem(pkg));
    }

    private JMenuItem makeRenameMenuItem(JPackage pkg) {
        JMenu renameSubMenu = new JMenu(NLS.str("popup.rename"));
        PackageHelper packageHelper = this.mainWindow.getCacheObject().getPackageHelper();
        List<JRenamePackage> nodes = packageHelper.getRenameNodes(pkg);
        for (JRenamePackage node : nodes) {
            JMenuItem pkgPartItem = new JMenuItem(node.getTitle(), node.getIcon());
            pkgPartItem.addActionListener(e -> this.rename(node));
            ((Container)renameSubMenu).add(pkgPartItem);
        }
        return renameSubMenu;
    }

    private void rename(JRenamePackage pkg) {
        LOG.debug("Renaming package: {}", (Object)pkg);
        RenameDialog.rename(this.mainWindow, pkg);
    }

    private JMenuItem makeExcludeItem(JPackage pkg) {
        JCheckBoxMenuItem excludeItem = new JCheckBoxMenuItem(NLS.str("popup.exclude"));
        excludeItem.setSelected(!pkg.isEnabled());
        excludeItem.addItemListener(e -> {
            JadxWrapper wrapper = this.mainWindow.getWrapper();
            String fullName = pkg.getPkg().getFullName();
            if (excludeItem.isSelected()) {
                wrapper.addExcludedPackage(fullName);
            } else {
                wrapper.removeExcludedPackage(fullName);
            }
            this.mainWindow.reopen();
        });
        return excludeItem;
    }

    private JMenuItem makeExportSubMenu(JPackage pkg) {
        JMenu exportSubMenu = new JMenu(NLS.str("popup.export"));
        exportSubMenu.add(this.makeExportMenuItem(pkg, NLS.str("tabs.code"), JClassExportType.Code));
        exportSubMenu.add(this.makeExportMenuItem(pkg, NLS.str("tabs.smali"), JClassExportType.Smali));
        exportSubMenu.add(this.makeExportMenuItem(pkg, "Simple", JClassExportType.Simple));
        exportSubMenu.add(this.makeExportMenuItem(pkg, "Fallback", JClassExportType.Fallback));
        return exportSubMenu;
    }

    public JMenuItem makeExportMenuItem(JPackage pkg, String label, JClassExportType exportType) {
        JMenuItem exportMenuItem = new JMenuItem(label);
        exportMenuItem.addActionListener(event -> {
            FileDialogWrapper fileDialog = new FileDialogWrapper(this.mainWindow, FileOpenMode.EXPORT_NODE_FOLDER);
            List<Path> selectedPaths = fileDialog.show();
            if (selectedPaths.size() != 1) {
                return;
            }
            Path savePath = selectedPaths.get(0);
            JPackagePopupMenu.saveJPackage(pkg, savePath, exportType);
        });
        return exportMenuItem;
    }

    private static void saveJPackage(JPackage pkg, Path savePath, JClassExportType exportType) {
        Path subSavePath = savePath.resolve(pkg.getName());
        try {
            if (!Files.isDirectory(subSavePath, new LinkOption[0])) {
                Files.createDirectory(subSavePath, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        for (JClass jClass : pkg.getClasses()) {
            String fileName = jClass.getName() + "." + exportType.extension;
            JClassPopupMenu.saveJClass(jClass, subSavePath.resolve(fileName), exportType);
        }
        for (JPackage subPkg : pkg.getSubPackages()) {
            JPackagePopupMenu.saveJPackage(subPkg, subSavePath, exportType);
        }
    }

    private JMenuItem makeExcludeItem() {
        return new JMenuItem(new AbstractAction(NLS.str("popup.exclude_packages")){
            private static final long serialVersionUID = -1111111202104151028L;

            @Override
            public void actionPerformed(ActionEvent e) {
                new ExcludePkgDialog(JPackagePopupMenu.this.mainWindow).setVisible(true);
            }
        });
    }

    private JMenuItem makeSearchItem(JPackage pkg) {
        JMenuItem searchItem = new JMenuItem(NLS.str("menu.text_search"));
        searchItem.addActionListener(e -> {
            String fullName = pkg.getPkg().getFullName();
            LOG.debug("Searching package: {}", (Object)fullName);
            SearchDialog.searchPackage(this.mainWindow, fullName);
        });
        return searchItem;
    }
}

