/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.dialog;

import jadx.api.ICodeInfo;
import jadx.api.JavaClass;
import jadx.api.JavaMethod;
import jadx.api.JavaNode;
import jadx.api.utils.CodeUtils;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.visitors.prepare.CollectConstValues;
import jadx.gui.JadxWrapper;
import jadx.gui.jobs.TaskStatus;
import jadx.gui.treemodel.CodeNode;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JField;
import jadx.gui.treemodel.JMethod;
import jadx.gui.treemodel.JNode;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.cellrenders.PathHighlightTreeCellRenderer;
import jadx.gui.ui.dialog.CommonSearchDialog;
import jadx.gui.ui.panel.ProgressPanel;
import jadx.gui.ui.panel.SimpleCodePanel;
import jadx.gui.utils.JNodeCache;
import jadx.gui.utils.NLS;
import jadx.gui.utils.UiUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsageDialogPlus
extends CommonSearchDialog {
    private static final long serialVersionUID = -5105405789969134107L;
    private final JPanel mainPanel;
    private final JSplitPane splitPane;
    private final SimpleCodePanel simpleCodePanel;
    private final JTree usageTree;
    private final DefaultTreeModel treeModel;
    private final DefaultMutableTreeNode rootNode;
    private final ProgressPanel localProgressPanel;
    private final JLabel resultsInfoLabel;
    private final JLabel progressInfoLabel;
    private final JNode initialNode;
    private static final Logger LOG = LoggerFactory.getLogger(UsageDialogPlus.class);

    public static void open(MainWindow mainWindow, JNode node) {
        UsageDialogPlus usageDialog = new UsageDialogPlus(mainWindow, node);
        mainWindow.addLoadListener(loaded -> {
            if (!loaded) {
                usageDialog.dispose();
                return true;
            }
            return false;
        });
        usageDialog.setVisible(true);
        SwingUtilities.invokeLater(() -> {
            int width = usageDialog.splitPane.getWidth();
            if (width > 0) {
                usageDialog.splitPane.setDividerLocation((int)((double)width * 0.3));
            }
        });
    }

    private UsageDialogPlus(MainWindow mainWindow, JNode node) {
        super(mainWindow, NLS.str("usage_dialog_plus.title"));
        this.initialNode = node;
        this.progressPane = new ProgressPanel(mainWindow, false);
        this.warnLabel = new JLabel();
        this.warnLabel.setForeground(Color.RED);
        this.warnLabel.setVisible(false);
        this.resultsInfoLabel = new JLabel();
        this.progressInfoLabel = new JLabel();
        this.localProgressPanel = new ProgressPanel(mainWindow, false);
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.simpleCodePanel = new SimpleCodePanel(mainWindow);
        this.rootNode = new DefaultMutableTreeNode(node);
        this.treeModel = new DefaultTreeModel(this.rootNode);
        this.usageTree = new JTree(this.treeModel);
        this.usageTree.getSelectionModel().setSelectionMode(1);
        this.usageTree.setRootVisible(true);
        this.usageTree.setShowsRootHandles(true);
        this.usageTree.putClientProperty("JTree.lineStyle", "Horizontal");
        this.usageTree.setRowHeight(22);
        this.usageTree.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.usageTree.setFont(mainWindow.getSettings().getFont());
        this.usageTree.setCellRenderer(new PathHighlightTreeCellRenderer());
        this.usageTree.addTreeSelectionListener(e -> {
            DefaultMutableTreeNode node1 = (DefaultMutableTreeNode)this.usageTree.getLastSelectedPathComponent();
            if (node1 == null) {
                return;
            }
            Object nodeInfo = node1.getUserObject();
            if (nodeInfo instanceof CodeNode) {
                CodeNode codeNode = (CodeNode)nodeInfo;
                this.simpleCodePanel.showCode(codeNode, codeNode.makeDescString());
            } else if (nodeInfo instanceof JNode) {
                JNode jNode = (JNode)nodeInfo;
                this.simpleCodePanel.showCode(jNode, jNode.makeDescString());
            }
            this.updateResultsInfo(node1);
        });
        this.usageTree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                Object userObject;
                TreePath path = event.getPath();
                DefaultMutableTreeNode expandedNode = (DefaultMutableTreeNode)path.getLastPathComponent();
                if (expandedNode.getChildCount() == 0 && (userObject = expandedNode.getUserObject()) instanceof JNode) {
                    JNode nodeToUse = (JNode)userObject;
                    if (nodeToUse.getClass() == CodeNode.class) {
                        nodeToUse = UsageDialogPlus.this.getNodeFromCodeNode((CodeNode)nodeToUse);
                    }
                    if (nodeToUse != null) {
                        UsageDialogPlus.this.loadNodeUsages(nodeToUse, expandedNode);
                    }
                }
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        this.usageTree.addMouseListener(new MouseAdapter(){
            private long lastClickTime = 0L;
            private TreePath lastClickPath = null;

            @Override
            public void mouseClicked(MouseEvent e) {
                TreePath path = UsageDialogPlus.this.usageTree.getPathForLocation(e.getX(), e.getY());
                if (path == null) {
                    return;
                }
                UsageDialogPlus.this.usageTree.setSelectionPath(path);
                if (SwingUtilities.isRightMouseButton(e)) {
                    DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)path.getLastPathComponent();
                    Object userObject = selectedNode.getUserObject();
                    if (userObject instanceof JNode || userObject instanceof CodeNode) {
                        JNode nodeForMenu = userObject instanceof JNode ? (JNode)userObject : UsageDialogPlus.this.getNodeFromCodeNode((CodeNode)userObject);
                        UsageDialogPlus.this.showPopupMenu(e, nodeForMenu, path);
                    }
                    return;
                }
                if (SwingUtilities.isLeftMouseButton(e)) {
                    long clickTime = System.currentTimeMillis();
                    long doubleClickInterval = 300L;
                    DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)path.getLastPathComponent();
                    if (clickTime - this.lastClickTime < doubleClickInterval && path.equals(this.lastClickPath)) {
                        if (UsageDialogPlus.this.usageTree.isExpanded(path)) {
                            UsageDialogPlus.this.usageTree.collapsePath(path);
                        } else {
                            UsageDialogPlus.this.usageTree.expandPath(path);
                            if (selectedNode.getChildCount() == 0 && selectedNode.getUserObject() instanceof JNode) {
                                JNode nodeToUse = (JNode)selectedNode.getUserObject();
                                if (nodeToUse.getClass() == CodeNode.class) {
                                    nodeToUse = UsageDialogPlus.this.getNodeFromCodeNode((CodeNode)nodeToUse);
                                }
                                if (nodeToUse != null) {
                                    UsageDialogPlus.this.loadNodeUsages(nodeToUse, selectedNode);
                                }
                            }
                        }
                        UsageDialogPlus.this.updateResultsInfo(selectedNode);
                    } else {
                        if (!UsageDialogPlus.this.usageTree.isExpanded(path)) {
                            UsageDialogPlus.this.usageTree.expandPath(path);
                            if (selectedNode.getChildCount() == 0 && selectedNode.getUserObject() instanceof JNode) {
                                JNode nodeToUse = (JNode)selectedNode.getUserObject();
                                if (nodeToUse.getClass() == CodeNode.class) {
                                    nodeToUse = UsageDialogPlus.this.getNodeFromCodeNode((CodeNode)nodeToUse);
                                }
                                if (nodeToUse != null) {
                                    UsageDialogPlus.this.loadNodeUsages(nodeToUse, selectedNode);
                                }
                            }
                        }
                        UsageDialogPlus.this.updateResultsInfo(selectedNode);
                    }
                    this.lastClickTime = clickTime;
                    this.lastClickPath = path;
                }
            }
        });
        this.splitPane = new JSplitPane(1);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setContinuousLayout(true);
        this.splitPane.setResizeWeight(0.3);
        this.splitPane.setDividerSize(10);
        JScrollPane treeScrollPane = new JScrollPane(this.usageTree);
        treeScrollPane.setHorizontalScrollBarPolicy(30);
        treeScrollPane.setVerticalScrollBarPolicy(20);
        JPanel statusPanel = new JPanel(new FlowLayout(0));
        statusPanel.add(this.resultsInfoLabel);
        statusPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        statusPanel.add(this.progressInfoLabel);
        statusPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        statusPanel.add(this.localProgressPanel);
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.add((Component)treeScrollPane, "Center");
        leftPanel.add((Component)statusPanel, "South");
        this.splitPane.setLeftComponent(leftPanel);
        this.splitPane.setRightComponent(this.simpleCodePanel);
        this.mainPanel.add((Component)this.splitPane, "Center");
        this.initUI();
        this.registerInitOnOpen();
        this.loadWindowPos();
    }

    private void initUI() {
        this.initCommon();
        JPanel buttonPane = this.initButtonsPanel();
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout(5, 5));
        contentPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        contentPanel.add((Component)this.mainPanel, "Center");
        contentPanel.add((Component)buttonPane, "Last");
        this.getContentPane().add(contentPanel);
        this.pack();
        this.setSize(1300, 700);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int currentDividerLocation;
                double ratio;
                int width = UsageDialogPlus.this.splitPane.getWidth();
                if (width > 0 && ((ratio = (double)(currentDividerLocation = UsageDialogPlus.this.splitPane.getDividerLocation()) / (double)width) < 0.2 || ratio > 0.5)) {
                    UsageDialogPlus.this.splitPane.setDividerLocation((int)((double)width * 0.3));
                }
            }
        });
    }

    @Override
    protected void openInit() {
        this.prepareUsageData(this.initialNode);
        this.localProgressPanel.setIndeterminate(true);
        this.localProgressPanel.setVisible(true);
        this.progressInfoLabel.setText(NLS.str("search_dialog.tip_searching"));
        this.loadNodeUsages(this.initialNode, this.rootNode);
    }

    private void loadNodeUsages(JNode node, DefaultMutableTreeNode treeNode) {
        this.localProgressPanel.setIndeterminate(true);
        this.localProgressPanel.setVisible(true);
        this.progressInfoLabel.setText(NLS.str("search_dialog.tip_searching"));
        this.mainWindow.getBackgroundExecutor().execute(NLS.str("progress.load"), () -> this.collectUsageData(node, treeNode), status -> {
            if (status == TaskStatus.CANCEL_BY_MEMORY) {
                this.mainWindow.showHeapUsageBar();
                UiUtils.errorMessage(this, NLS.str("message.memoryLow"));
            }
            this.localProgressPanel.setVisible(false);
            this.progressInfoLabel.setText(NLS.str("usage_dialog_plus.search_complete"));
            this.updateResultsInfo(treeNode);
            if (treeNode == this.rootNode) {
                this.usageTree.expandPath(new TreePath(this.rootNode.getPath()));
            }
        });
    }

    private void updateResultsInfo(DefaultMutableTreeNode node) {
        if (node != null) {
            int childCount = node.getChildCount();
            this.resultsInfoLabel.setText(NLS.str("search_dialog.results_complete", childCount));
        }
    }

    private int getTotalChildCount(DefaultMutableTreeNode node) {
        int count = node.getChildCount();
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)e.nextElement();
            count += this.getTotalChildCount(child);
        }
        return count;
    }

    private void prepareUsageData(JNode node) {
        if (this.mainWindow.getSettings().isReplaceConsts() && node instanceof JField) {
            boolean constField;
            FieldNode fld = ((JField)node).getJavaField().getFieldNode();
            boolean bl = constField = CollectConstValues.getFieldConstValue((FieldNode)fld) != null;
            if (constField && !fld.getAccessFlags().isPrivate()) {
                this.mainWindow.requestFullDecompilation();
            }
        }
    }

    private void collectUsageData(JNode node, DefaultMutableTreeNode treeNode) {
        ArrayList usageList = new ArrayList();
        this.buildUsageQuery(node).forEach((searchNode, useNodes) -> useNodes.stream().map(JavaNode::getTopParentClass).distinct().forEach(u -> this.processUsage((JavaNode)searchNode, (JavaClass)u, usageList)));
        Collections.sort(usageList);
        SwingUtilities.invokeLater(() -> {
            for (CodeNode codeNode : usageList) {
                DefaultMutableTreeNode usageTreeNode = new DefaultMutableTreeNode(codeNode);
                this.treeModel.insertNodeInto(usageTreeNode, treeNode, treeNode.getChildCount());
            }
            this.treeModel.nodeStructureChanged(treeNode);
        });
    }

    private Map<JavaNode, List<? extends JavaNode>> buildUsageQuery(JNode node) {
        HashMap<JavaNode, List<? extends JavaNode>> map = new HashMap<JavaNode, List<? extends JavaNode>>();
        if (node instanceof JMethod) {
            JavaMethod javaMethod = ((JMethod)node).getJavaMethod();
            for (JavaMethod mth : this.getMethodWithOverrides(javaMethod)) {
                map.put((JavaNode)mth, mth.getUseIn());
            }
            return map;
        }
        if (node instanceof JClass) {
            JavaClass javaCls = ((JClass)node).getCls();
            map.put((JavaNode)javaCls, javaCls.getUseIn());
            for (JavaMethod javaMth : javaCls.getMethods()) {
                if (!javaMth.isConstructor()) continue;
                map.put((JavaNode)javaMth, javaMth.getUseIn());
            }
            return map;
        }
        if (node instanceof JField && this.mainWindow.getSettings().isReplaceConsts()) {
            boolean constField;
            FieldNode fld = ((JField)node).getJavaField().getFieldNode();
            boolean bl = constField = CollectConstValues.getFieldConstValue((FieldNode)fld) != null;
            if (constField && !fld.getAccessFlags().isPrivate()) {
                map.put((JavaNode)fld.getJavaNode(), this.mainWindow.getWrapper().getIncludedClasses());
                return map;
            }
        }
        JavaNode javaNode = node.getJavaNode();
        map.put(javaNode, javaNode.getUseIn());
        return map;
    }

    private List<JavaMethod> getMethodWithOverrides(JavaMethod javaMethod) {
        List relatedMethods = javaMethod.getOverrideRelatedMethods();
        if (!relatedMethods.isEmpty()) {
            return relatedMethods;
        }
        return Collections.singletonList(javaMethod);
    }

    private void processUsage(JavaNode searchNode, JavaClass topUseClass, List<CodeNode> usageList) {
        ICodeInfo codeInfo = topUseClass.getCodeInfo();
        List usePositions = topUseClass.getUsePlacesFor(codeInfo, searchNode);
        if (usePositions.isEmpty()) {
            return;
        }
        String code = codeInfo.getCodeStr();
        JadxWrapper wrapper = this.mainWindow.getWrapper();
        Iterator iterator = usePositions.iterator();
        while (iterator.hasNext()) {
            int pos = (Integer)iterator.next();
            String line = CodeUtils.getLineForPos((String)code, (int)pos);
            if (line.startsWith("import ")) continue;
            JNodeCache nodeCache = this.getNodeCache();
            JavaNode enclosingNode = wrapper.getEnclosingNode(codeInfo, pos);
            JClass rootJCls = nodeCache.makeFrom(topUseClass);
            JClass usageJNode = enclosingNode == null ? rootJCls : nodeCache.makeFrom(enclosingNode);
            CodeNode codeNode = new CodeNode(rootJCls, usageJNode, line.trim(), pos);
            usageList.add(codeNode);
        }
    }

    private JNode getNodeFromCodeNode(CodeNode codeNode) {
        if (codeNode != null) {
            try {
                JavaNode javaNode = codeNode.getJavaNode();
                JNodeCache nodeCache = this.getNodeCache();
                JNode node = nodeCache.makeFrom(javaNode);
                if (node == null) {
                    node = codeNode.getJParent();
                }
                if (node != null) {
                    LOG.debug("Converted CodeNode to {} of type {}", (Object)node.getName(), (Object)node.getClass().getSimpleName());
                } else {
                    LOG.debug("Failed to convert CodeNode: {}", (Object)codeNode.getName());
                }
                return node;
            }
            catch (Exception e) {
                LOG.error("Error converting CodeNode to JNode", (Throwable)e);
            }
        }
        return null;
    }

    private void showPopupMenu(MouseEvent e, JNode node, TreePath path) {
        if (node == null) {
            return;
        }
        JPopupMenu popup = new JPopupMenu();
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)path.getLastPathComponent();
        JMenuItem expandItem = new JMenuItem(NLS.str("usage_dialog_plus.expand_usages"));
        expandItem.addActionListener(evt -> {
            if (treeNode.getChildCount() == 0) {
                JNode nodeToUse = node;
                if (node.getClass() == CodeNode.class) {
                    nodeToUse = this.getNodeFromCodeNode((CodeNode)node);
                }
                if (nodeToUse != null) {
                    this.loadNodeUsages(nodeToUse, treeNode);
                }
            }
            this.usageTree.expandPath(path);
        });
        JMenuItem jumpToItem = new JMenuItem(NLS.str("usage_dialog_plus.jump_to"));
        jumpToItem.addActionListener(evt -> this.openItem(node));
        JMenuItem copyPathItem = new JMenuItem(NLS.str("usage_dialog_plus.copy_path"));
        copyPathItem.addActionListener(evt -> this.copyUsagePath(path));
        popup.add(expandItem);
        popup.addSeparator();
        popup.add(jumpToItem);
        popup.add(copyPathItem);
        popup.show(e.getComponent(), e.getX(), e.getY());
    }

    private void copyUsagePath(TreePath path) {
        if (path != null) {
            StringBuilder pathBuilder = new StringBuilder();
            Object[] nodes = path.getPath();
            for (int i = nodes.length - 1; i >= 0; --i) {
                DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)nodes[i];
                Object userObject = treeNode.getUserObject();
                if (i < nodes.length - 1) {
                    pathBuilder.append("\n");
                    int indentLevel = nodes.length - 1 - i;
                    for (int j = 0; j < indentLevel; ++j) {
                        pathBuilder.append(" ");
                    }
                    pathBuilder.append("-> ");
                }
                if (userObject instanceof JNode) {
                    pathBuilder.append(((JNode)userObject).getJavaNode().getCodeNodeRef().toString());
                    continue;
                }
                if (!(userObject instanceof CodeNode)) continue;
                CodeNode codeNode = (CodeNode)userObject;
                pathBuilder.append(codeNode.getJavaNode().getCodeNodeRef().toString());
            }
            UiUtils.copyToClipboard(pathBuilder.toString());
        }
    }

    @Override
    @NotNull
    protected JPanel initButtonsPanel() {
        this.progressPane = new ProgressPanel(this.mainWindow, false);
        JButton cancelButton = new JButton(NLS.str("search_dialog.cancel"));
        cancelButton.addActionListener(event -> this.dispose());
        JButton openBtn = new JButton(NLS.str("search_dialog.open"));
        openBtn.addActionListener(event -> this.openSelectedItem());
        this.getRootPane().setDefaultButton(openBtn);
        JCheckBox cbKeepOpen = new JCheckBox(NLS.str("search_dialog.keep_open"));
        cbKeepOpen.setSelected(this.mainWindow.getSettings().getKeepCommonDialogOpen());
        cbKeepOpen.addActionListener(e -> {
            this.mainWindow.getSettings().setKeepCommonDialogOpen(cbKeepOpen.isSelected());
            this.mainWindow.getSettings().sync();
        });
        cbKeepOpen.setAlignmentY(0.5f);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 2));
        buttonPane.add(cbKeepOpen);
        buttonPane.add(Box.createRigidArea(new Dimension(15, 0)));
        buttonPane.add(this.progressPane);
        buttonPane.add(Box.createRigidArea(new Dimension(5, 0)));
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(openBtn);
        buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPane.add(cancelButton);
        return buttonPane;
    }

    @Override
    protected void openSelectedItem() {
        JNode node = this.getSelectedNode();
        if (node == null) {
            return;
        }
        this.openItem(node);
    }

    @Override
    protected void loadFinished() {
    }

    @Override
    protected void loadStart() {
    }

    @Nullable
    private JNode getSelectedNode() {
        try {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.usageTree.getLastSelectedPathComponent();
            if (node == null) {
                return null;
            }
            Object userObject = node.getUserObject();
            if (userObject instanceof JNode) {
                return (JNode)userObject;
            }
            if (userObject instanceof CodeNode) {
                CodeNode codeNode = (CodeNode)userObject;
                return this.getNodeFromCodeNode(codeNode);
            }
            return null;
        }
        catch (Exception e) {
            LOG.error("Failed to get selected node", (Throwable)e);
            return null;
        }
    }
}

