/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.dialog;

import jadx.api.JavaMethod;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.cellrenders.MethodsListRenderer;
import jadx.gui.ui.dialog.CommonDialog;
import jadx.gui.utils.NLS;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class MethodsDialog
extends CommonDialog {
    private JList<JavaMethod> methodList;
    private final Consumer<List<JavaMethod>> listConsumer;

    public MethodsDialog(MainWindow mainWindow, List<JavaMethod> methods, Consumer<List<JavaMethod>> listConsumer) {
        super(mainWindow);
        this.listConsumer = listConsumer;
        this.initUI(methods);
        this.setVisible(true);
    }

    private void initUI(List<JavaMethod> methods) {
        this.setTitle(NLS.str("methods_dialog.title"));
        DefaultListModel<JavaMethod> defaultListModel = new DefaultListModel<JavaMethod>();
        defaultListModel.addAll(methods);
        this.methodList = new JList();
        this.methodList.setModel(defaultListModel);
        this.methodList.setSelectionMode(2);
        this.methodList.setCellRenderer(new MethodsListRenderer());
        this.methodList.setSelectionModel(new DefaultListSelectionModel(){

            @Override
            public void setSelectionInterval(int index0, int index1) {
                if (super.isSelectedIndex(index0)) {
                    super.removeSelectionInterval(index0, index1);
                } else {
                    super.addSelectionInterval(index0, index1);
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.methodList);
        JPanel buttonPane = this.initButtonsPanel();
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout(5, 5));
        contentPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        contentPanel.add((Component)scrollPane, "Center");
        contentPanel.add((Component)buttonPane, "Last");
        this.getContentPane().add(contentPanel);
        this.pack();
        this.setSize(500, 300);
        this.setLocationRelativeTo(null);
        this.setDefaultCloseOperation(2);
    }

    protected JPanel initButtonsPanel() {
        JButton cancelButton = new JButton(NLS.str("common_dialog.cancel"));
        cancelButton.addActionListener(event -> this.dispose());
        JButton okBtn = new JButton(NLS.str("common_dialog.ok"));
        okBtn.addActionListener(event -> this.generateForSelected());
        this.getRootPane().setDefaultButton(okBtn);
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 2));
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(okBtn);
        buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPane.add(cancelButton);
        return buttonPane;
    }

    private void generateForSelected() {
        List<JavaMethod> selectedMethods = this.methodList.getSelectedValuesList();
        if (!selectedMethods.isEmpty()) {
            this.listConsumer.accept(selectedMethods);
        }
        this.dispose();
    }
}

