/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.codearea;

import java.util.ArrayList;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.folding.Fold;
import org.fife.ui.rsyntaxtextarea.folding.FoldParser;
import org.fife.ui.rsyntaxtextarea.folding.FoldParserManager;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmaliFoldParser
implements FoldParser {
    private static final Logger LOG = LoggerFactory.getLogger(SmaliFoldParser.class);
    private static final Pattern CLASS_LINE_PATTERN = Pattern.compile("^\\.class\\b", 8);
    private static final Pattern ENDMETHOD_LINE_PATTERN = Pattern.compile("^\\.end method\\b", 8);
    private static final Pattern STARTMETHOD_LINE_PATTERN = Pattern.compile("^\\.method\\b", 8);

    public static void register() {
        FoldParserManager.get().addFoldParserMapping("text/smali", (FoldParser)new SmaliFoldParser());
    }

    private SmaliFoldParser() {
    }

    public List<Fold> getFolds(RSyntaxTextArea textArea) {
        ArrayList<Fold> classFolds = new ArrayList<Fold>();
        String text = textArea.getText();
        List<Integer> classStartOffsets = this.getClassStartOffsets(text);
        NavigableSet<Integer> startMethodStartOffsets = this.getStartMethodStartOffsets(text);
        NavigableSet<Integer> endMethodEndOffsets = this.getEndMethodEndOffsets(text);
        for (int i = 0; i < classStartOffsets.size(); ++i) {
            Fold classFold;
            int startOffset = classStartOffsets.get(i);
            int classLimit = i < classStartOffsets.size() - 1 ? classStartOffsets.get(i + 1).intValue() : text.length();
            Integer endOffset = endMethodEndOffsets.floor(classLimit);
            if (endOffset == null || (classFold = SmaliFoldParser.createFold(textArea, startOffset, endOffset)) == null) continue;
            classFolds.add(classFold);
            Integer startMethodStartOffset = startMethodStartOffsets.ceiling(startOffset);
            while (startMethodStartOffset != null && startMethodStartOffset < endOffset) {
                Integer endMethodEndOffset = endMethodEndOffsets.ceiling(startMethodStartOffset);
                if (endMethodEndOffset != null) {
                    SmaliFoldParser.addFold(classFold, startMethodStartOffset, endMethodEndOffset);
                }
                startMethodStartOffset = startMethodStartOffsets.ceiling(endMethodEndOffset);
            }
        }
        return classFolds;
    }

    @Nullable
    private static Fold createFold(RSyntaxTextArea textArea, int startOffset, int endOffset) {
        try {
            Fold fold = new Fold(0, textArea, startOffset);
            fold.setEndOffset(endOffset);
            return fold;
        }
        catch (Exception e) {
            LOG.error("Failed to create code fold", (Throwable)e);
            return null;
        }
    }

    private static void addFold(Fold parent, int startOffset, int endOffset) {
        try {
            Fold fold = parent.createChild(0, startOffset);
            fold.setEndOffset(endOffset);
        }
        catch (Exception e) {
            LOG.error("Failed to add code fold", (Throwable)e);
        }
    }

    private List<Integer> getClassStartOffsets(String text) {
        ArrayList<Integer> startOffsets = new ArrayList<Integer>();
        Matcher matcher = CLASS_LINE_PATTERN.matcher(text);
        while (matcher.find()) {
            int startOffset = matcher.start();
            startOffsets.add(startOffset);
        }
        return startOffsets;
    }

    private NavigableSet<Integer> getStartMethodStartOffsets(String text) {
        TreeSet<Integer> startOffsets = new TreeSet<Integer>();
        Matcher matcher = STARTMETHOD_LINE_PATTERN.matcher(text);
        while (matcher.find()) {
            int startOffset = matcher.start();
            startOffsets.add(startOffset);
        }
        return startOffsets;
    }

    private NavigableSet<Integer> getEndMethodEndOffsets(String text) {
        TreeSet<Integer> endOffsets = new TreeSet<Integer>();
        Matcher matcher = ENDMETHOD_LINE_PATTERN.matcher(text);
        while (matcher.find()) {
            int endOffset = matcher.end();
            endOffsets.add(endOffset);
        }
        return endOffsets;
    }
}

