/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.action;

import jadx.api.JavaClass;
import jadx.api.JavaField;
import jadx.api.JavaMethod;
import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.PrimitiveType;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.gui.settings.XposedCodegenLanguage;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JField;
import jadx.gui.treemodel.JMethod;
import jadx.gui.treemodel.JNode;
import jadx.gui.ui.action.ActionModel;
import jadx.gui.ui.action.JNodeAction;
import jadx.gui.ui.codearea.CodeArea;
import jadx.gui.utils.NLS;
import jadx.gui.utils.UiUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u0014\u0010\u001a\u001a\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001f"}, d2={"Ljadx/gui/ui/action/XposedAction;", "Ljadx/gui/ui/action/JNodeAction;", "codeArea", "Ljadx/gui/ui/codearea/CodeArea;", "<init>", "(Ljadx/gui/ui/codearea/CodeArea;)V", "runAction", "", "node", "Ljadx/gui/treemodel/JNode;", "isActionEnabled", "", "generateXposedSnippet", "", "generateMethodSnippet", "jMethod", "Ljadx/gui/treemodel/JMethod;", "fixTypeContent", "type", "Ljadx/core/dex/instructions/args/ArgType;", "generateClassSnippet", "jClass", "Ljadx/gui/treemodel/JClass;", "generateFieldSnippet", "jField", "Ljadx/gui/treemodel/JField;", "language", "Ljadx/gui/settings/XposedCodegenLanguage;", "getLanguage", "()Ljadx/gui/settings/XposedCodegenLanguage;", "Companion", "jadx-gui"})
@SourceDebugExtension(value={"SMAP\nXposedAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 XposedAction.kt\njadx/gui/ui/action/XposedAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,162:1\n1563#2:163\n1634#2,3:164\n*S KotlinDebug\n*F\n+ 1 XposedAction.kt\njadx/gui/ui/action/XposedAction\n*L\n54#1:163\n54#1:164,3\n*E\n"})
public final class XposedAction
extends JNodeAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG;
    private static final long serialVersionUID = 2641585141624592578L;
    @NotNull
    private static final Map<String, String> PRIMITIVE_TYPE_MAPPING;

    public XposedAction(@NotNull CodeArea codeArea) {
        Intrinsics.checkNotNullParameter((Object)((Object)codeArea), (String)"codeArea");
        super(ActionModel.XPOSED_COPY, codeArea);
    }

    @Override
    public void runAction(@NotNull JNode node) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        try {
            String xposedSnippet = this.generateXposedSnippet(node);
            LOG.info("Xposed snippet:\n{}", (Object)xposedSnippet);
            UiUtils.copyToClipboard(xposedSnippet);
        }
        catch (Exception e) {
            LOG.error("Failed to generate Xposed code snippet", (Throwable)e);
            JOptionPane.showMessageDialog(this.getCodeArea().getMainWindow(), e.getLocalizedMessage(), NLS.str("error_dialog.title"), 0);
        }
    }

    @Override
    public boolean isActionEnabled(@Nullable JNode node) {
        return node instanceof JMethod || node instanceof JClass || node instanceof JField;
    }

    private final String generateXposedSnippet(JNode node) {
        String string;
        JNode jNode = node;
        if (jNode instanceof JMethod) {
            string = this.generateMethodSnippet((JMethod)node);
        } else if (jNode instanceof JClass) {
            string = this.generateClassSnippet((JClass)node);
        } else if (jNode instanceof JField) {
            string = this.generateFieldSnippet((JField)node);
        } else {
            throw new JadxRuntimeException("Unsupported node type: " + node.getClass());
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final String generateMethodSnippet(JMethod jMethod) {
        String string;
        void $this$mapTo$iv$iv;
        JavaMethod javaMethod = jMethod.getJavaMethod();
        MethodNode methodNode = javaMethod.getMethodNode();
        MethodInfo methodInfo = methodNode.getMethodInfo();
        String xposedMethod = null;
        List list = methodInfo.getArgumentsTypes();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getArgumentsTypes(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            ArgType argType = (ArgType)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.fixTypeContent((ArgType)p0));
        }
        List args = (List)destination$iv$iv;
        String rawClassName = javaMethod.getDeclaringClass().getRawName();
        if (methodNode.isConstructor()) {
            xposedMethod = "findAndHookConstructor";
        } else {
            xposedMethod = "findAndHookMethod";
            args = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)("\"" + methodInfo.getName() + "\"")), (Iterable)args);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.getLanguage().ordinal()]) {
            case 1: {
                string = "XposedHelpers.%s(\"%s\", classLoader, %s, new XC_MethodHook() {\n    @Override\n    protected void beforeHookedMethod(MethodHookParam param) throws Throwable {\n        super.beforeHookedMethod(param);\n    }\n    @Override\n    protected void afterHookedMethod(MethodHookParam param) throws Throwable {\n        super.afterHookedMethod(param);\n    }\n});";
                break;
            }
            case 2: {
                string = "XposedHelpers.%s(\"%s\", classLoader, %s, object : XC_MethodHook() {\n    override fun beforeHookedMethod(param: MethodHookParam) {\n        super.beforeHookedMethod(param)\n    }\n\n    override fun afterHookedMethod(param: MethodHookParam) {\n        super.afterHookedMethod(param)\n    }\n})";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String template = string;
        Object[] objectArray = new Object[]{xposedMethod, rawClassName, CollectionsKt.joinToString$default((Iterable)args, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)};
        String string2 = String.format(template, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    private final String fixTypeContent(ArgType type) {
        Object object;
        block18: {
            block20: {
                block19: {
                    block17: {
                        if (!type.isGeneric()) break block17;
                        object = "\"" + type.getObject() + "\"";
                        break block18;
                    }
                    if (!type.isGenericType() || !type.isObject() || !type.isTypeKnown()) break block19;
                    object = "java.lang.Object";
                    break block18;
                }
                if (!type.isPrimitive()) break block20;
                switch (WhenMappings.$EnumSwitchMapping$0[this.getLanguage().ordinal()]) {
                    case 1: {
                        object = type + ".class";
                        break block18;
                    }
                    case 2: {
                        PrimitiveType primitiveType = type.getPrimitiveType();
                        switch (primitiveType == null ? -1 : WhenMappings.$EnumSwitchMapping$1[primitiveType.ordinal()]) {
                            case 1: {
                                object = "Boolean::class.javaPrimitiveType";
                                break block18;
                            }
                            case 2: {
                                object = "Char::class.javaPrimitiveType";
                                break block18;
                            }
                            case 3: {
                                object = "Byte::class.javaPrimitiveType";
                                break block18;
                            }
                            case 4: {
                                object = "Short::class.javaPrimitiveType";
                                break block18;
                            }
                            case 5: {
                                object = "Int::class.javaPrimitiveType";
                                break block18;
                            }
                            case 6: {
                                object = "Float::class.javaPrimitiveType";
                                break block18;
                            }
                            case 7: {
                                object = "Long::class.javaPrimitiveType";
                                break block18;
                            }
                            case 8: {
                                object = "Double::class.javaPrimitiveType";
                                break block18;
                            }
                            case 9: {
                                object = "Any::class.java";
                                break block18;
                            }
                            case 10: {
                                object = "Array::class.java";
                                break block18;
                            }
                            case 11: {
                                object = "Void::class.javaPrimitiveType";
                                break block18;
                            }
                            default: {
                                throw new JadxRuntimeException("Unknown or null primitive type: " + type);
                            }
                        }
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            object = "\"" + type + "\"";
        }
        return object;
    }

    private final String generateClassSnippet(JClass jClass) {
        String string;
        JavaClass javaClass = jClass.getCls();
        String rawClassName = javaClass.getRawName();
        String className = javaClass.getName();
        switch (WhenMappings.$EnumSwitchMapping$0[this.getLanguage().ordinal()]) {
            case 1: {
                string = "Class<?> %sClass = classLoader.loadClass(\"%s\");";
                break;
            }
            case 2: {
                string = "val %sClass = classLoader.loadClass(\"%s\")";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String template = string;
        Object[] objectArray = new Object[]{className, rawClassName};
        String string2 = String.format(template, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    private final String generateFieldSnippet(JField jField) {
        String string;
        JavaField javaField = jField.getJavaField();
        String string2 = javaField.getAccessFlags().isStatic() ? "Static" : "";
        String string3 = javaField.getFieldNode().getType().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(...)");
        String type = PRIMITIVE_TYPE_MAPPING.getOrDefault(string3, "Object");
        String xposedMethod = "XposedHelpers.get" + string2 + type + "Field";
        switch (WhenMappings.$EnumSwitchMapping$0[this.getLanguage().ordinal()]) {
            case 1: {
                string = "%s(/*runtimeObject*/, \"%s\");";
                break;
            }
            case 2: {
                string = "%s(/*runtimeObject*/, \"%s\")";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String template = string;
        Object[] objectArray = new Object[]{xposedMethod, javaField.getFieldNode().getFieldInfo().getName()};
        String string4 = String.format(template, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(...)");
        return string4;
    }

    private final XposedCodegenLanguage getLanguage() {
        XposedCodegenLanguage xposedCodegenLanguage = this.getCodeArea().getMainWindow().getSettings().getXposedCodegenLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)xposedCodegenLanguage), (String)"getXposedCodegenLanguage(...)");
        return xposedCodegenLanguage;
    }

    static {
        Logger logger = LoggerFactory.getLogger(XposedAction.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOG = logger;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"int", (Object)"Int"), TuplesKt.to((Object)"byte", (Object)"Byte"), TuplesKt.to((Object)"short", (Object)"Short"), TuplesKt.to((Object)"long", (Object)"Long"), TuplesKt.to((Object)"float", (Object)"Float"), TuplesKt.to((Object)"double", (Object)"Double"), TuplesKt.to((Object)"char", (Object)"Char"), TuplesKt.to((Object)"boolean", (Object)"Boolean")};
        PRIMITIVE_TYPE_MAPPING = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Ljadx/gui/ui/action/XposedAction$Companion;", "", "<init>", "()V", "LOG", "Lorg/slf4j/Logger;", "serialVersionUID", "", "PRIMITIVE_TYPE_MAPPING", "", "", "jadx-gui"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[XposedCodegenLanguage.values().length];
            try {
                nArray[XposedCodegenLanguage.JAVA.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[XposedCodegenLanguage.KOTLIN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[PrimitiveType.values().length];
            try {
                nArray[PrimitiveType.BOOLEAN.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.CHAR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.BYTE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.SHORT.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.INT.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.FLOAT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.LONG.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.DOUBLE.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.OBJECT.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.ARRAY.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrimitiveType.VOID.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

