/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.treemodel;

import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JNode;
import jadx.gui.ui.MainWindow;
import jadx.gui.utils.Icons;
import jadx.gui.utils.NLS;
import jadx.gui.utils.ui.SimpleMenuItem;
import java.nio.file.Path;
import javax.swing.Icon;
import javax.swing.JPopupMenu;

public class JInputFile
extends JNode {
    private final Path filePath;

    public JInputFile(Path filePath) {
        this.filePath = filePath;
    }

    @Override
    public JPopupMenu onTreePopupMenu(MainWindow mainWindow) {
        JPopupMenu menu = new JPopupMenu();
        menu.add(new SimpleMenuItem(NLS.str("popup.add_files"), mainWindow::addFiles));
        menu.add(new SimpleMenuItem(NLS.str("popup.remove"), () -> mainWindow.removeInput(this.filePath)));
        menu.add(new SimpleMenuItem(NLS.str("popup.rename"), () -> mainWindow.renameInput(this.filePath)));
        return menu;
    }

    @Override
    public JClass getJParent() {
        return null;
    }

    public Icon getIcon() {
        return Icons.FILE;
    }

    @Override
    public String makeString() {
        return this.filePath.getFileName().toString();
    }

    @Override
    public String getTooltip() {
        return this.filePath.normalize().toAbsolutePath().toString();
    }
}

