/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.settings.ui;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import jadx.api.CommentsLevel;
import jadx.api.DecompilationMode;
import jadx.api.JadxArgs;
import jadx.api.JadxDecompiler;
import jadx.api.args.GeneratedRenamesMappingFileMode;
import jadx.api.args.IntegerFormat;
import jadx.api.args.ResourceNameSource;
import jadx.api.args.UseSourceNameAsClassNameAlias;
import jadx.api.plugins.events.JadxEvents;
import jadx.api.plugins.events.types.ReloadSettingsWindow;
import jadx.api.plugins.gui.ISettingsGroup;
import jadx.core.utils.GsonUtils;
import jadx.core.utils.StringUtils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.gui.settings.JadxSettings;
import jadx.gui.settings.JadxSettingsAdapter;
import jadx.gui.settings.JadxUpdateChannel;
import jadx.gui.settings.LineNumbersMode;
import jadx.gui.settings.XposedCodegenLanguage;
import jadx.gui.settings.ui.SettingsGroup;
import jadx.gui.settings.ui.SettingsTree;
import jadx.gui.settings.ui.cache.CacheSettingsGroup;
import jadx.gui.settings.ui.font.JadxFontDialog;
import jadx.gui.settings.ui.plugins.PluginSettings;
import jadx.gui.settings.ui.shortcut.ShortcutsSettingsGroup;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.codearea.theme.EditorThemeManager;
import jadx.gui.ui.codearea.theme.ThemeIdAndName;
import jadx.gui.ui.tab.dnd.TabDndGhostType;
import jadx.gui.utils.FontUtils;
import jadx.gui.utils.LafManager;
import jadx.gui.utils.LangLocale;
import jadx.gui.utils.NLS;
import jadx.gui.utils.UiUtils;
import jadx.gui.utils.ui.ActionHandler;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JadxSettingsWindow
extends JDialog {
    private static final long serialVersionUID = -1804570470377354148L;
    private static final Logger LOG = LoggerFactory.getLogger(JadxSettingsWindow.class);
    private final transient MainWindow mainWindow;
    private final transient JadxSettings settings;
    private final transient String startSettings;
    private final transient String startSettingsHash;
    private final transient LangLocale prevLang;
    private final transient Consumer<ReloadSettingsWindow> reloadListener;
    private transient boolean needReload = false;
    private transient SettingsTree tree;
    private List<ISettingsGroup> groups;
    private JPanel wrapGroupPanel;

    public JadxSettingsWindow(MainWindow mainWindow, JadxSettings settings) {
        this.mainWindow = mainWindow;
        this.settings = settings;
        this.startSettings = JadxSettingsAdapter.makeString(settings);
        this.startSettingsHash = this.calcSettingsHash();
        this.prevLang = settings.getLangLocale();
        this.initUI();
        this.setTitle(NLS.str("preferences.title"));
        this.setDefaultCloseOperation(2);
        this.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
        this.pack();
        UiUtils.setWindowIcons(this);
        this.setLocationRelativeTo(null);
        if (!mainWindow.getSettings().loadWindowPos(this)) {
            this.setSize(700, 800);
        }
        this.reloadListener = ev -> UiUtils.uiRun(this::reloadUI);
        mainWindow.events().global().addListener(JadxEvents.RELOAD_SETTINGS_WINDOW, this.reloadListener);
    }

    private void reloadUI() {
        int[] selection = this.tree.getSelectionRows();
        this.closeGroups(false);
        this.getContentPane().removeAll();
        this.initUI();
        UiUtils.uiRun(() -> {
            this.tree.setSelectionRows(selection);
            SwingUtilities.updateComponentTreeUI(this);
        });
    }

    private void initUI() {
        this.wrapGroupPanel = new JPanel(new BorderLayout(10, 10));
        this.groups = new ArrayList<ISettingsGroup>();
        this.groups.add(this.makeDecompilationGroup());
        this.groups.add(this.makeDeobfuscationGroup());
        this.groups.add(this.makeRenameGroup());
        this.groups.add(new CacheSettingsGroup(this));
        this.groups.add(this.makeAppearanceGroup());
        this.groups.add(new ShortcutsSettingsGroup(this, this.settings));
        this.groups.add(this.makeProjectGroup());
        this.groups.add(new PluginSettings(this.mainWindow, this.settings).build());
        this.groups.add(this.makeOtherGroup());
        this.tree = new SettingsTree(this);
        this.tree.init(this.groups);
        this.tree.setFocusable(true);
        JScrollPane leftPane = new JScrollPane(this.tree);
        leftPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 3, 3));
        JScrollPane rightPane = new JScrollPane(this.wrapGroupPanel);
        rightPane.getVerticalScrollBar().setUnitIncrement(16);
        rightPane.setHorizontalScrollBarPolicy(30);
        rightPane.setBorder(BorderFactory.createEmptyBorder(10, 3, 3, 10));
        JSplitPane splitPane = new JSplitPane();
        splitPane.setResizeWeight(0.2);
        splitPane.setLeftComponent(leftPane);
        splitPane.setRightComponent(rightPane);
        Container contentPane = this.getContentPane();
        contentPane.add((Component)splitPane, "Center");
        contentPane.add((Component)this.buildButtonsPane(), "Last");
        KeyStroke strokeEsc = KeyStroke.getKeyStroke("ESCAPE");
        InputMap inputMap = this.getRootPane().getInputMap(2);
        inputMap.put(strokeEsc, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", new ActionHandler(this::cancel));
    }

    private JPanel buildButtonsPane() {
        JButton saveBtn = new JButton(NLS.str("preferences.save"));
        saveBtn.addActionListener(event -> this.save());
        JButton cancelButton = new JButton(NLS.str("preferences.cancel"));
        cancelButton.addActionListener(event -> this.cancel());
        JButton resetBtn = new JButton(NLS.str("preferences.reset"));
        resetBtn.addActionListener(event -> this.reset());
        JButton copyBtn = new JButton(NLS.str("preferences.copy"));
        copyBtn.addActionListener(event -> this.copySettings());
        JPanel buttonPane = new JPanel();
        buttonPane.setLayout(new BoxLayout(buttonPane, 2));
        buttonPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        buttonPane.add(resetBtn);
        buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPane.add(copyBtn);
        buttonPane.add(Box.createHorizontalGlue());
        buttonPane.add(saveBtn);
        buttonPane.add(Box.createRigidArea(new Dimension(10, 0)));
        buttonPane.add(cancelButton);
        this.getRootPane().setDefaultButton(saveBtn);
        return buttonPane;
    }

    public void activatePage(String location) {
        if (location.endsWith(".class")) {
            String clsName = StringUtils.removeSuffix((String)location, (String)".class");
            for (ISettingsGroup group : this.groups) {
                String groupCls = group.getClass().getSimpleName();
                if (!groupCls.equals(clsName)) continue;
                this.selectGroup(group);
                return;
            }
            throw new JadxRuntimeException("No setting group class: " + location);
        }
        for (ISettingsGroup group : this.groups) {
            if (!group.getTitle().equals(location)) continue;
            this.selectGroup(group);
            return;
        }
        throw new JadxRuntimeException("No setting group with title: " + location);
    }

    public void selectGroup(ISettingsGroup group) {
        this.tree.selectGroup(group);
    }

    public void activateGroup(@Nullable ISettingsGroup group) {
        this.wrapGroupPanel.removeAll();
        if (group != null) {
            this.wrapGroupPanel.add(group.buildComponent());
        }
        this.wrapGroupPanel.updateUI();
    }

    private static void enableComponents(Container container, boolean enable) {
        for (Component component : container.getComponents()) {
            if (component instanceof Container) {
                JadxSettingsWindow.enableComponents((Container)component, enable);
            }
            component.setEnabled(enable);
        }
    }

    private SettingsGroup makeDeobfuscationGroup() {
        JCheckBox deobfOn = new JCheckBox();
        deobfOn.setSelected(this.settings.isDeobfuscationOn());
        deobfOn.addItemListener(e -> {
            this.settings.setDeobfuscationOn(e.getStateChange() == 1);
            this.needReload();
        });
        SpinnerNumberModel minLenModel = new SpinnerNumberModel(this.settings.getDeobfuscationMinLength(), 0, Integer.MAX_VALUE, 1);
        JSpinner minLenSpinner = new JSpinner(minLenModel);
        minLenSpinner.addChangeListener(e -> {
            this.settings.setDeobfuscationMinLength((Integer)minLenSpinner.getValue());
            this.needReload();
        });
        SpinnerNumberModel maxLenModel = new SpinnerNumberModel(this.settings.getDeobfuscationMaxLength(), 0, Integer.MAX_VALUE, 1);
        JSpinner maxLenSpinner = new JSpinner(maxLenModel);
        maxLenSpinner.addChangeListener(e -> {
            this.settings.setDeobfuscationMaxLength((Integer)maxLenSpinner.getValue());
            this.needReload();
        });
        JComboBox<ResourceNameSource> resNamesSource = new JComboBox<ResourceNameSource>(ResourceNameSource.values());
        resNamesSource.setSelectedItem(this.settings.getResourceNameSource());
        resNamesSource.addActionListener(e -> {
            this.settings.setResourceNameSource((ResourceNameSource)resNamesSource.getSelectedItem());
            this.needReload();
        });
        JCheckBox useHeaders = new JCheckBox();
        useHeaders.setSelected(this.settings.isUseHeadersForDetectResourceExtensions());
        useHeaders.addItemListener(e -> {
            this.settings.setUseHeadersForDetectResourceExtension(e.getStateChange() == 1);
            this.needReload();
        });
        JComboBox<GeneratedRenamesMappingFileMode> generatedRenamesMappingFileModeCB = new JComboBox<GeneratedRenamesMappingFileMode>(GeneratedRenamesMappingFileMode.values());
        generatedRenamesMappingFileModeCB.setSelectedItem(this.settings.getGeneratedRenamesMappingFileMode());
        generatedRenamesMappingFileModeCB.addActionListener(e -> {
            GeneratedRenamesMappingFileMode newValue = (GeneratedRenamesMappingFileMode)generatedRenamesMappingFileModeCB.getSelectedItem();
            if (newValue != this.settings.getGeneratedRenamesMappingFileMode()) {
                this.settings.setGeneratedRenamesMappingFileMode(newValue);
                this.needReload();
            }
        });
        JButton editWhitelistedEntities = new JButton(NLS.str("preferences.excludedPackages.button"));
        editWhitelistedEntities.addActionListener(event -> {
            String prevWhitelistedEntities = this.settings.getDeobfuscationWhitelistStr();
            String result = JOptionPane.showInputDialog(this, NLS.str("preferences.deobfuscation_whitelist.editDialog"), prevWhitelistedEntities);
            if (result != null) {
                this.settings.setDeobfuscationWhitelistStr(result);
                if (!prevWhitelistedEntities.equals(result)) {
                    this.needReload();
                }
            }
        });
        SettingsGroup deobfGroup = new SettingsGroup(NLS.str("preferences.deobfuscation"));
        deobfGroup.addRow(NLS.str("preferences.deobfuscation_on"), deobfOn);
        deobfGroup.addRow(NLS.str("preferences.deobfuscation_min_len"), minLenSpinner);
        deobfGroup.addRow(NLS.str("preferences.deobfuscation_max_len"), maxLenSpinner);
        deobfGroup.addRow(NLS.str("preferences.deobfuscation_res_name_source"), resNamesSource);
        deobfGroup.addRow(NLS.str("preferences.deobfuscation_res_use_headers"), useHeaders);
        deobfGroup.addRow(NLS.str("preferences.generated_renames_mapping_file_mode"), generatedRenamesMappingFileModeCB);
        deobfGroup.addRow(NLS.str("preferences.deobfuscation_whitelist"), NLS.str("preferences.deobfuscation_whitelist.tooltip"), editWhitelistedEntities);
        deobfGroup.end();
        List<JComponent> connectedComponents = Arrays.asList(minLenSpinner, maxLenSpinner);
        deobfOn.addItemListener(e -> this.enableComponentList(connectedComponents, e.getStateChange() == 1));
        this.enableComponentList(connectedComponents, this.settings.isDeobfuscationOn());
        return deobfGroup;
    }

    private SettingsGroup makeRenameGroup() {
        JCheckBox renameCaseSensitive = new JCheckBox();
        renameCaseSensitive.setSelected(this.settings.isRenameCaseSensitive());
        renameCaseSensitive.addItemListener(e -> {
            this.settings.updateRenameFlag(JadxArgs.RenameEnum.CASE, e.getStateChange() == 1);
            this.needReload();
        });
        JCheckBox renameValid = new JCheckBox();
        renameValid.setSelected(this.settings.isRenameValid());
        renameValid.addItemListener(e -> {
            this.settings.updateRenameFlag(JadxArgs.RenameEnum.VALID, e.getStateChange() == 1);
            this.needReload();
        });
        JCheckBox renamePrintable = new JCheckBox();
        renamePrintable.setSelected(this.settings.isRenamePrintable());
        renamePrintable.addItemListener(e -> {
            this.settings.updateRenameFlag(JadxArgs.RenameEnum.PRINTABLE, e.getStateChange() == 1);
            this.needReload();
        });
        JComboBox<UseSourceNameAsClassNameAlias> useSourceNameAsClassNameAlias = new JComboBox<UseSourceNameAsClassNameAlias>(UseSourceNameAsClassNameAlias.values());
        useSourceNameAsClassNameAlias.setSelectedItem(this.settings.getUseSourceNameAsClassNameAlias());
        useSourceNameAsClassNameAlias.addActionListener(e -> {
            this.settings.setUseSourceNameAsClassNameAlias((UseSourceNameAsClassNameAlias)useSourceNameAsClassNameAlias.getSelectedItem());
            this.needReload();
        });
        JSpinner repeatLimit = new JSpinner(new SpinnerNumberModel(this.settings.getSourceNameRepeatLimit(), 1, Integer.MAX_VALUE, 1));
        repeatLimit.addChangeListener(e -> {
            this.settings.setSourceNameRepeatLimit((Integer)repeatLimit.getValue());
            this.needReload();
        });
        SettingsGroup group = new SettingsGroup(NLS.str("preferences.rename"));
        group.addRow(NLS.str("preferences.rename_case"), renameCaseSensitive);
        group.addRow(NLS.str("preferences.rename_valid"), renameValid);
        group.addRow(NLS.str("preferences.rename_printable"), renamePrintable);
        group.addRow(NLS.str("preferences.rename_use_source_name_as_class_name_alias"), useSourceNameAsClassNameAlias);
        group.addRow(NLS.str("preferences.rename_source_name_repeat_limit"), repeatLimit);
        return group;
    }

    private void enableComponentList(Collection<JComponent> connectedComponents, boolean enabled) {
        connectedComponents.forEach(comp -> comp.setEnabled(enabled));
    }

    private SettingsGroup makeProjectGroup() {
        JComboBox<JadxSettings.SAVEOPTION> dropdown = new JComboBox<JadxSettings.SAVEOPTION>(JadxSettings.SAVEOPTION.values());
        dropdown.setSelectedItem((Object)this.settings.getSaveOption());
        dropdown.addActionListener(e -> {
            this.settings.setSaveOption((JadxSettings.SAVEOPTION)((Object)((Object)dropdown.getSelectedItem())));
            this.needReload();
        });
        SettingsGroup group = new SettingsGroup(NLS.str("preferences.project"));
        group.addRow(NLS.str("preferences.saveOption"), dropdown);
        return group;
    }

    private SettingsGroup makeAppearanceGroup() {
        JComboBox<LangLocale> languageCbx = new JComboBox<LangLocale>(NLS.getLangLocales());
        for (LangLocale locale : NLS.getLangLocales()) {
            if (!locale.equals(this.settings.getLangLocale())) continue;
            languageCbx.setSelectedItem(locale);
            break;
        }
        languageCbx.addActionListener(e -> this.settings.setLangLocale((LangLocale)languageCbx.getSelectedItem()));
        JButton fontBtn = new JButton(NLS.str("preferences.select_font"));
        JButton smaliFontBtn = new JButton(NLS.str("preferences.select_smali_font"));
        EditorThemeManager editorThemeManager = this.mainWindow.getEditorThemeManager();
        JComboBox<ThemeIdAndName> themesCbx = new JComboBox<ThemeIdAndName>(editorThemeManager.getThemeIdNameArray());
        themesCbx.setSelectedItem(editorThemeManager.getCurrentThemeIdName());
        themesCbx.addActionListener(evt -> {
            ThemeIdAndName selected = (ThemeIdAndName)themesCbx.getSelectedItem();
            if (selected != null) {
                this.settings.setEditorTheme(selected.getId());
                this.mainWindow.loadSettings();
            }
        });
        JComboBox<String> lafCbx = new JComboBox<String>(LafManager.getThemes());
        lafCbx.setSelectedItem(this.settings.getLafTheme());
        lafCbx.addActionListener(e -> {
            this.settings.setLafTheme((String)lafCbx.getSelectedItem());
            this.mainWindow.loadSettings();
        });
        SettingsGroup group = new SettingsGroup(NLS.str("preferences.appearance"));
        group.addRow(NLS.str("preferences.language"), languageCbx);
        group.addRow(NLS.str("preferences.laf_theme"), lafCbx);
        group.addRow(NLS.str("preferences.theme"), themesCbx);
        final JLabel fontLabel = group.addRow(this.getFontLabelStr(), fontBtn);
        final JLabel smaliFontLabel = group.addRow(this.getSmaliFontLabelStr(), smaliFontBtn);
        fontBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Font font = new JadxFontDialog(JadxSettingsWindow.this, NLS.str("preferences.font")).select(JadxSettingsWindow.this.settings.getFont(), false);
                if (font != null) {
                    LOG.debug("Selected Font: {}", (Object)font);
                    JadxSettingsWindow.this.settings.setFont(font);
                    JadxSettingsWindow.this.mainWindow.loadSettings();
                    fontLabel.setText(JadxSettingsWindow.this.getFontLabelStr());
                }
            }
        });
        smaliFontBtn.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Font font = new JadxFontDialog(JadxSettingsWindow.this, NLS.str("preferences.smali_font")).select(JadxSettingsWindow.this.settings.getSmaliFont(), true);
                if (font != null) {
                    LOG.debug("Selected Font: {} for smali", (Object)font);
                    JadxSettingsWindow.this.settings.setSmaliFont(font);
                    JadxSettingsWindow.this.mainWindow.loadSettings();
                    smaliFontLabel.setText(JadxSettingsWindow.this.getSmaliFontLabelStr());
                }
            }
        });
        JComboBox<TabDndGhostType> tabDndGhostTypeCbx = new JComboBox<TabDndGhostType>(TabDndGhostType.values());
        tabDndGhostTypeCbx.setSelectedItem((Object)this.settings.getTabDndGhostType());
        tabDndGhostTypeCbx.addActionListener(e -> {
            this.settings.setTabDndGhostType((TabDndGhostType)((Object)((Object)tabDndGhostTypeCbx.getSelectedItem())));
            this.mainWindow.loadSettings();
        });
        group.addRow(NLS.str("preferences.tab_dnd_appearance"), tabDndGhostTypeCbx);
        return group;
    }

    private String getFontLabelStr() {
        Font font = this.settings.getFont();
        String fontStyleName = FontUtils.convertFontStyleToString(font.getStyle());
        return NLS.str("preferences.font") + ": " + font.getFontName() + " " + fontStyleName + " " + font.getSize();
    }

    private String getSmaliFontLabelStr() {
        Font font = this.settings.getSmaliFont();
        String fontStyleName = FontUtils.convertFontStyleToString(font.getStyle());
        return NLS.str("preferences.smali_font") + ": " + font.getFontName() + " " + fontStyleName + " " + font.getSize();
    }

    private SettingsGroup makeDecompilationGroup() {
        JCheckBox useDx = new JCheckBox();
        useDx.setSelected(this.settings.isUseDx());
        useDx.addItemListener(e -> {
            this.settings.setUseDx(e.getStateChange() == 1);
            this.needReload();
        });
        JComboBox<DecompilationMode> decompilationModeComboBox = new JComboBox<DecompilationMode>(DecompilationMode.values());
        decompilationModeComboBox.setSelectedItem(this.settings.getDecompilationMode());
        decompilationModeComboBox.addActionListener(e -> {
            this.settings.setDecompilationMode((DecompilationMode)decompilationModeComboBox.getSelectedItem());
            this.needReload();
        });
        JCheckBox showInconsistentCode = new JCheckBox();
        showInconsistentCode.setSelected(this.settings.isShowInconsistentCode());
        showInconsistentCode.addItemListener(e -> {
            this.settings.setShowInconsistentCode(e.getStateChange() == 1);
            this.needReload();
        });
        JCheckBox resourceDecode = new JCheckBox();
        resourceDecode.setSelected(this.settings.isSkipResources());
        resourceDecode.addItemListener(e -> {
            this.settings.setSkipResources(e.getStateChange() == 1);
            this.needReload();
        });
        int threadsCountValue = this.settings.getThreadsCount();
        int threadsCountMax = Math.max(2, Math.max(threadsCountValue, Runtime.getRuntime().availableProcessors() * 2));
        SpinnerNumberModel spinnerModel = new SpinnerNumberModel(threadsCountValue, 1, threadsCountMax, 1);
        JSpinner threadsCount = new JSpinner(spinnerModel);
        threadsCount.addChangeListener(e -> {
            this.settings.setThreadsCount((Integer)threadsCount.getValue());
            this.needReload();
        });
        JButton editExcludedPackages = new JButton(NLS.str("preferences.excludedPackages.button"));
        editExcludedPackages.addActionListener(event -> {
            String oldExcludedPackages = this.settings.getExcludedPackages();
            String result = JOptionPane.showInputDialog(this, NLS.str("preferences.excludedPackages.editDialog"), this.settings.getExcludedPackages());
            if (result != null) {
                this.settings.setExcludedPackages(result);
                if (!oldExcludedPackages.equals(result)) {
                    this.needReload();
                }
            }
        });
        JCheckBox autoStartJobs = new JCheckBox();
        autoStartJobs.setSelected(this.settings.isAutoStartJobs());
        autoStartJobs.addItemListener(e -> this.settings.setAutoStartJobs(e.getStateChange() == 1));
        JCheckBox escapeUnicode = new JCheckBox();
        escapeUnicode.setSelected(this.settings.isEscapeUnicode());
        escapeUnicode.addItemListener(e -> {
            this.settings.setEscapeUnicode(e.getStateChange() == 1);
            this.needReload();
        });
        JCheckBox replaceConsts = new JCheckBox();
        replaceConsts.setSelected(this.settings.isReplaceConsts());
        replaceConsts.addItemListener(e -> {
            this.settings.setReplaceConsts(e.getStateChange() == 1);
            this.needReload();
        });
        JCheckBox respectBytecodeAccessModifiers = new JCheckBox();
        respectBytecodeAccessModifiers.setSelected(this.settings.isRespectBytecodeAccessModifiers());
        respectBytecodeAccessModifiers.addItemListener(e -> {
            this.settings.setRespectBytecodeAccessModifiers(e.getStateChange() == 1);
            this.needReload();
        });
        JCheckBox useImports = new JCheckBox();
        useImports.setSelected(this.settings.isUseImports());
        useImports.addItemListener(e -> {
            this.settings.setUseImports(e.getStateChange() == 1);
            this.needReload();
        });
        JCheckBox useDebugInfo = new JCheckBox();
        useDebugInfo.setSelected(this.settings.isDebugInfo());
        useDebugInfo.addItemListener(e -> {
            this.settings.setDebugInfo(e.getStateChange() == 1);
            this.needReload();
        });
        JCheckBox inlineAnonymous = new JCheckBox();
        inlineAnonymous.setSelected(this.settings.isInlineAnonymousClasses());
        inlineAnonymous.addItemListener(e -> {
            this.settings.setInlineAnonymousClasses(e.getStateChange() == 1);
            this.needReload();
        });
        JCheckBox inlineMethods = new JCheckBox();
        inlineMethods.setSelected(this.settings.isInlineMethods());
        inlineMethods.addItemListener(e -> {
            this.settings.setInlineMethods(e.getStateChange() == 1);
            this.needReload();
        });
        JCheckBox inlineKotlinLambdas = new JCheckBox();
        inlineKotlinLambdas.setSelected(this.settings.isAllowInlineKotlinLambda());
        inlineKotlinLambdas.addItemListener(e -> {
            this.settings.setAllowInlineKotlinLambda(e.getStateChange() == 1);
            this.needReload();
        });
        JCheckBox moveInnerClasses = new JCheckBox();
        moveInnerClasses.setSelected(this.settings.isMoveInnerClasses());
        moveInnerClasses.addItemListener(e -> {
            this.settings.setMoveInnerClasses(e.getStateChange() == 1);
            this.needReload();
        });
        JCheckBox extractFinally = new JCheckBox();
        extractFinally.setSelected(this.settings.isExtractFinally());
        extractFinally.addItemListener(e -> {
            this.settings.setExtractFinally(e.getStateChange() == 1);
            this.needReload();
        });
        JCheckBox restoreSwitchOverString = new JCheckBox();
        restoreSwitchOverString.setSelected(this.settings.isRestoreSwitchOverString());
        restoreSwitchOverString.addItemListener(e -> {
            this.settings.setRestoreSwitchOverString(e.getStateChange() == 1);
            this.needReload();
        });
        JCheckBox fsCaseSensitive = new JCheckBox();
        fsCaseSensitive.setSelected(this.settings.isFsCaseSensitive());
        fsCaseSensitive.addItemListener(e -> {
            this.settings.setFsCaseSensitive(e.getStateChange() == 1);
            this.needReload();
        });
        JComboBox<JadxArgs.UseKotlinMethodsForVarNames> kotlinRenameVars = new JComboBox<JadxArgs.UseKotlinMethodsForVarNames>(JadxArgs.UseKotlinMethodsForVarNames.values());
        kotlinRenameVars.setSelectedItem(this.settings.getUseKotlinMethodsForVarNames());
        kotlinRenameVars.addActionListener(e -> {
            this.settings.setUseKotlinMethodsForVarNames((JadxArgs.UseKotlinMethodsForVarNames)kotlinRenameVars.getSelectedItem());
            this.needReload();
        });
        JComboBox<CommentsLevel> commentsLevel = new JComboBox<CommentsLevel>(CommentsLevel.values());
        commentsLevel.setSelectedItem(this.settings.getCommentsLevel());
        commentsLevel.addActionListener(e -> {
            this.settings.setCommentsLevel((CommentsLevel)commentsLevel.getSelectedItem());
            this.needReload();
        });
        JComboBox<IntegerFormat> integerFormat = new JComboBox<IntegerFormat>(IntegerFormat.values());
        integerFormat.setSelectedItem(this.settings.getIntegerFormat());
        integerFormat.addActionListener(e -> {
            this.settings.setIntegerFormat((IntegerFormat)integerFormat.getSelectedItem());
            this.needReload();
        });
        SettingsGroup other = new SettingsGroup(NLS.str("preferences.decompile"));
        other.addRow(NLS.str("preferences.threads"), threadsCount);
        other.addRow(NLS.str("preferences.excludedPackages"), NLS.str("preferences.excludedPackages.tooltip"), editExcludedPackages);
        other.addRow(NLS.str("preferences.start_jobs"), autoStartJobs);
        other.addRow(NLS.str("preferences.decompilationMode"), decompilationModeComboBox);
        other.addRow(NLS.str("preferences.showInconsistentCode"), showInconsistentCode);
        other.addRow(NLS.str("preferences.escapeUnicode"), escapeUnicode);
        other.addRow(NLS.str("preferences.replaceConsts"), replaceConsts);
        other.addRow(NLS.str("preferences.respectBytecodeAccessModifiers"), respectBytecodeAccessModifiers);
        other.addRow(NLS.str("preferences.useImports"), useImports);
        other.addRow(NLS.str("preferences.useDebugInfo"), useDebugInfo);
        other.addRow(NLS.str("preferences.inlineAnonymous"), inlineAnonymous);
        other.addRow(NLS.str("preferences.inlineMethods"), inlineMethods);
        other.addRow(NLS.str("preferences.inlineKotlinLambdas"), inlineKotlinLambdas);
        other.addRow(NLS.str("preferences.moveInnerClasses"), moveInnerClasses);
        other.addRow(NLS.str("preferences.extractFinally"), extractFinally);
        other.addRow(NLS.str("preferences.restoreSwitchOverString"), restoreSwitchOverString);
        other.addRow(NLS.str("preferences.fsCaseSensitive"), fsCaseSensitive);
        other.addRow(NLS.str("preferences.useDx"), useDx);
        other.addRow(NLS.str("preferences.skipResourcesDecode"), resourceDecode);
        other.addRow(NLS.str("preferences.useKotlinMethodsForVarNames"), kotlinRenameVars);
        other.addRow(NLS.str("preferences.commentsLevel"), commentsLevel);
        other.addRow(NLS.str("preferences.integerFormat"), integerFormat);
        return other;
    }

    private SettingsGroup makeOtherGroup() {
        JComboBox<LineNumbersMode> lineNumbersMode = new JComboBox<LineNumbersMode>(LineNumbersMode.values());
        lineNumbersMode.setSelectedItem((Object)this.settings.getLineNumbersMode());
        lineNumbersMode.addActionListener(e -> {
            this.settings.setLineNumbersMode((LineNumbersMode)((Object)((Object)lineNumbersMode.getSelectedItem())));
            this.mainWindow.loadSettings();
        });
        JCheckBox jumpOnDoubleClick = new JCheckBox();
        jumpOnDoubleClick.setSelected(this.settings.isJumpOnDoubleClick());
        jumpOnDoubleClick.addItemListener(e -> this.settings.setJumpOnDoubleClick(e.getStateChange() == 1));
        JSpinner resultsPerPage = new JSpinner(new SpinnerNumberModel(this.settings.getSearchResultsPerPage(), 0, Integer.MAX_VALUE, 1));
        resultsPerPage.addChangeListener(ev -> this.settings.setSearchResultsPerPage((Integer)resultsPerPage.getValue()));
        JCheckBox useAltFileDialog = new JCheckBox();
        useAltFileDialog.setSelected(this.settings.isUseAlternativeFileDialog());
        useAltFileDialog.addItemListener(e -> this.settings.setUseAlternativeFileDialog(e.getStateChange() == 1));
        JCheckBox update = new JCheckBox();
        update.setSelected(this.settings.isCheckForUpdates());
        update.addItemListener(e -> this.settings.setCheckForUpdates(e.getStateChange() == 1));
        JCheckBox disableTooltipOnHover = new JCheckBox();
        disableTooltipOnHover.setSelected(this.settings.isDisableTooltipOnHover());
        disableTooltipOnHover.addItemListener(e -> this.settings.setDisableTooltipOnHover(e.getStateChange() == 1));
        JCheckBox cfg = new JCheckBox();
        cfg.setSelected(this.settings.isCfgOutput());
        cfg.addItemListener(e -> {
            this.settings.setCfgOutput(e.getStateChange() == 1);
            this.needReload();
        });
        JCheckBox rawCfg = new JCheckBox();
        rawCfg.setSelected(this.settings.isRawCfgOutput());
        rawCfg.addItemListener(e -> {
            this.settings.setRawCfgOutput(e.getStateChange() == 1);
            this.needReload();
        });
        JComboBox<XposedCodegenLanguage> xposedCodegenLanguage = new JComboBox<XposedCodegenLanguage>((XposedCodegenLanguage[])XposedCodegenLanguage.getEntries().toArray((Object[])new XposedCodegenLanguage[0]));
        xposedCodegenLanguage.setSelectedItem((Object)this.settings.getXposedCodegenLanguage());
        xposedCodegenLanguage.addActionListener(e -> {
            this.settings.setXposedCodegenLanguage((XposedCodegenLanguage)((Object)((Object)xposedCodegenLanguage.getSelectedItem())));
            this.mainWindow.loadSettings();
        });
        JComboBox<JadxUpdateChannel> updateChannel = new JComboBox<JadxUpdateChannel>((JadxUpdateChannel[])JadxUpdateChannel.getEntries().toArray((Object[])new JadxUpdateChannel[0]));
        updateChannel.setSelectedItem((Object)this.settings.getJadxUpdateChannel());
        updateChannel.addActionListener(e -> {
            this.settings.setJadxUpdateChannel((JadxUpdateChannel)((Object)((Object)updateChannel.getSelectedItem())));
            this.mainWindow.loadSettings();
        });
        SettingsGroup group = new SettingsGroup(NLS.str("preferences.other"));
        group.addRow(NLS.str("preferences.lineNumbersMode"), lineNumbersMode);
        group.addRow(NLS.str("preferences.jumpOnDoubleClick"), jumpOnDoubleClick);
        group.addRow(NLS.str("preferences.disable_tooltip_on_hover"), disableTooltipOnHover);
        group.addRow(NLS.str("preferences.search_results_per_page"), resultsPerPage);
        group.addRow(NLS.str("preferences.useAlternativeFileDialog"), useAltFileDialog);
        group.addRow(NLS.str("preferences.cfg"), cfg);
        group.addRow(NLS.str("preferences.raw_cfg"), rawCfg);
        group.addRow(NLS.str("preferences.xposed_codegen_language"), xposedCodegenLanguage);
        group.addRow(NLS.str("preferences.check_for_updates"), update);
        group.addRow(NLS.str("preferences.update_channel"), updateChannel);
        return group;
    }

    private void closeGroups(boolean save) {
        for (ISettingsGroup group : this.groups) {
            group.close(save);
        }
    }

    private void save() {
        this.closeGroups(true);
        this.settings.sync();
        JadxSettingsWindow.enableComponents(this, false);
        SwingUtilities.invokeLater(() -> {
            if (this.shouldReload()) {
                this.mainWindow.getShortcutsController().loadSettings();
                this.mainWindow.reopen();
            }
            if (!this.settings.getLangLocale().equals(this.prevLang)) {
                JOptionPane.showMessageDialog(this, NLS.str("msg.language_changed", this.settings.getLangLocale()), NLS.str("msg.language_changed_title", this.settings.getLangLocale()), 1);
            }
            this.dispose();
        });
    }

    private void cancel() {
        this.closeGroups(false);
        JadxSettingsAdapter.fill(this.settings, this.startSettings);
        this.mainWindow.loadSettings();
        this.dispose();
    }

    private void reset() {
        int res = JOptionPane.showConfirmDialog(this, NLS.str("preferences.reset_message"), NLS.str("preferences.reset_title"), 0);
        if (res == 0) {
            String defaults = JadxSettingsAdapter.makeString(JadxSettings.makeDefault());
            JadxSettingsAdapter.fill(this.settings, defaults);
            this.mainWindow.loadSettings();
            this.needReload();
            this.getContentPane().removeAll();
            this.initUI();
            this.pack();
            this.repaint();
        }
    }

    private void copySettings() {
        JsonObject settingsJson = JadxSettingsAdapter.makeJsonObject(this.settings);
        settingsJson.remove("windowPos");
        settingsJson.remove("mainWindowExtendedState");
        settingsJson.remove("lastSaveProjectPath");
        settingsJson.remove("lastOpenFilePath");
        settingsJson.remove("lastSaveFilePath");
        settingsJson.remove("recentProjects");
        String settingsText = GsonUtils.buildGson().toJson((JsonElement)settingsJson);
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        StringSelection selection = new StringSelection(settingsText);
        clipboard.setContents(selection, selection);
        JOptionPane.showMessageDialog(this, NLS.str("preferences.copy_message"));
    }

    public void needReload() {
        this.needReload = true;
    }

    private boolean shouldReload() {
        return this.needReload || !this.startSettingsHash.equals(this.calcSettingsHash());
    }

    private String calcSettingsHash() {
        JadxDecompiler decompiler = this.mainWindow.getWrapper().getCurrentDecompiler().orElse(null);
        return this.settings.toJadxArgs().makeCodeArgsHash(decompiler);
    }

    public MainWindow getMainWindow() {
        return this.mainWindow;
    }

    @Override
    public void dispose() {
        this.mainWindow.events().global().removeListener(JadxEvents.RELOAD_SETTINGS_WINDOW, this.reloadListener);
        this.settings.saveWindowPos(this);
        super.dispose();
    }
}

