/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.settings;

import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import jadx.core.utils.GsonUtils;
import jadx.gui.settings.JadxSettings;
import jadx.gui.settings.JadxSettingsStorage;
import jadx.gui.utils.PathTypeAdapter;
import jadx.gui.utils.RectangleTypeAdapter;
import java.awt.Rectangle;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JadxSettingsAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(JadxSettingsAdapter.class);
    private static final JadxSettingsStorage STORAGE = new JadxSettingsStorage();
    private static final ExclusionStrategy EXCLUDE_FIELDS = new ExclusionStrategy(){

        public boolean shouldSkipField(FieldAttributes f) {
            return JadxSettings.SKIP_FIELDS.contains(f.getName()) || f.hasModifier(1) || f.hasModifier(128) || f.hasModifier(8) || f.getAnnotation(GsonExclude.class) != null;
        }

        public boolean shouldSkipClass(Class<?> clazz) {
            return false;
        }
    };
    private static final Gson GSON = JadxSettingsAdapter.makeGsonBuilder().create();

    private JadxSettingsAdapter() {
    }

    public static JadxSettings load() {
        try {
            JadxSettings settings = JadxSettingsAdapter.fromString(STORAGE.load());
            if (settings == null) {
                LOG.debug("Created new settings.");
                settings = JadxSettings.makeDefault();
            } else {
                settings.fixOnLoad();
            }
            return settings;
        }
        catch (Exception e) {
            LOG.error("Error load settings. Settings will reset", (Throwable)e);
            return new JadxSettings();
        }
    }

    public static void store(JadxSettings settings) {
        try {
            STORAGE.save(JadxSettingsAdapter.makeString(settings));
        }
        catch (Exception e) {
            LOG.error("Error store settings", (Throwable)e);
        }
    }

    public static JadxSettings fromString(String jsonSettings) {
        if (jsonSettings == null) {
            return null;
        }
        return (JadxSettings)((Object)GSON.fromJson(jsonSettings, JadxSettings.class));
    }

    public static String makeString(JadxSettings settings) {
        return GSON.toJson((Object)settings);
    }

    public static JsonObject makeJsonObject(JadxSettings settings) {
        return GSON.toJsonTree((Object)settings).getAsJsonObject();
    }

    public static void fill(JadxSettings settings, String jsonStr) {
        GsonUtils.fillObjectFromJsonString((GsonBuilder)JadxSettingsAdapter.makeGsonBuilder(), (Object)((Object)settings), (String)jsonStr);
    }

    private static GsonBuilder makeGsonBuilder() {
        return GsonUtils.defaultGsonBuilder().setExclusionStrategies(new ExclusionStrategy[]{EXCLUDE_FIELDS}).registerTypeHierarchyAdapter(Path.class, PathTypeAdapter.singleton()).registerTypeHierarchyAdapter(Rectangle.class, RectangleTypeAdapter.singleton());
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface GsonExclude {
    }
}

