/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.plugins.context;

import jadx.api.metadata.ICodeNodeRef;
import jadx.gui.treemodel.JNode;
import jadx.gui.ui.action.JNodeAction;
import jadx.gui.ui.codearea.CodeArea;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.Nullable;

public class CodePopupAction {
    private final String name;
    private final Function<ICodeNodeRef, Boolean> enabledCheck;
    private final String keyBinding;
    private final Consumer<ICodeNodeRef> action;

    public CodePopupAction(String name, Function<ICodeNodeRef, Boolean> enabled, String keyBinding, Consumer<ICodeNodeRef> action) {
        this.name = name;
        this.enabledCheck = enabled;
        this.keyBinding = keyBinding;
        this.action = action;
    }

    public JNodeAction buildAction(CodeArea codeArea) {
        return new NodeAction(this, codeArea);
    }

    private static class NodeAction
    extends JNodeAction {
        private final CodePopupAction data;

        public NodeAction(CodePopupAction data, CodeArea codeArea) {
            super(data.name, codeArea);
            this.setName(data.name);
            this.setShortcutComponent((JComponent)((Object)codeArea));
            if (data.keyBinding != null) {
                KeyStroke key = KeyStroke.getKeyStroke(data.keyBinding);
                if (key == null) {
                    throw new IllegalArgumentException("Failed to parse key stroke: " + data.keyBinding);
                }
                this.setKeyBinding(key);
            }
            this.data = data;
        }

        @Override
        public boolean isActionEnabled(@Nullable JNode node) {
            if (node == null) {
                return false;
            }
            ICodeNodeRef codeNode = node.getCodeNodeRef();
            if (codeNode == null) {
                return false;
            }
            return this.data.enabledCheck.apply(codeNode);
        }

        @Override
        public void runAction(JNode node) {
            Runnable r = () -> this.data.action.accept(node.getCodeNodeRef());
            this.getCodeArea().getMainWindow().getBackgroundExecutor().execute(this.data.name, r);
        }
    }
}

