/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.utils.rx;

import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import io.reactivex.FlowableOnSubscribe;
import io.reactivex.disposables.Disposable;
import java.util.concurrent.TimeUnit;

public class DebounceUpdate {
    private FlowableEmitter<Boolean> emitter;
    private final Disposable disposable;

    public DebounceUpdate(int timeMs, Runnable action) {
        FlowableOnSubscribe source = emitter -> {
            this.emitter = emitter;
        };
        this.disposable = Flowable.create((FlowableOnSubscribe)source, (BackpressureStrategy)BackpressureStrategy.LATEST).debounce((long)timeMs, TimeUnit.MILLISECONDS).subscribe(v -> action.run());
    }

    public void requestUpdate() {
        this.emitter.onNext((Object)Boolean.TRUE);
    }

    public void dispose() {
        this.disposable.dispose();
    }
}

