/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.tab;

import jadx.core.utils.ListUtils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JEditableNode;
import jadx.gui.treemodel.JNode;
import jadx.gui.ui.panel.ContentPanel;
import jadx.gui.ui.tab.TabBlueprint;
import jadx.gui.ui.tab.TabbedPane;
import jadx.gui.ui.tab.TabsController;
import jadx.gui.ui.tab.dnd.TabDndGestureListener;
import jadx.gui.utils.Icons;
import jadx.gui.utils.NLS;
import jadx.gui.utils.OverlayIcon;
import jadx.gui.utils.UiUtils;
import jadx.gui.utils.ui.NodeLabel;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Point;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragSource;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicButtonUI;

public class TabComponent
extends JPanel {
    private static final long serialVersionUID = -8147035487543610321L;
    private final TabbedPane tabbedPane;
    private final TabsController tabsController;
    private final ContentPanel contentPanel;
    private OverlayIcon icon;
    private JLabel label;
    private JButton pinBtn;
    private JButton closeBtn;

    public TabComponent(TabbedPane tabbedPane, ContentPanel contentPanel) {
        this.tabbedPane = tabbedPane;
        this.tabsController = tabbedPane.getMainWindow().getTabsController();
        this.contentPanel = contentPanel;
        this.init();
    }

    public void loadSettings() {
        this.label.setFont(this.getLabelFont());
        if (this.tabbedPane.getDnd() != null) {
            this.tabbedPane.getDnd().loadSettings();
        }
    }

    private Font getLabelFont() {
        return this.tabsController.getMainWindow().getSettings().getFont().deriveFont(1);
    }

    private void init() {
        this.setLayout(new FlowLayout(0, 0, 0));
        this.setOpaque(false);
        final JNode node = this.getNode();
        this.icon = new OverlayIcon(node.getIcon());
        this.label = new NodeLabel(this.buildTabTitle(node), node.disableHtml());
        this.label.setFont(this.getLabelFont());
        String toolTip = this.contentPanel.getTabTooltip();
        if (toolTip != null) {
            this.setToolTipText(toolTip);
        }
        this.label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        this.label.setIcon(this.icon);
        this.updateBookmarkIcon();
        if (node instanceof JEditableNode) {
            ((JEditableNode)node).addChangeListener(c -> this.label.setText(this.buildTabTitle(node)));
        }
        this.pinBtn = new JButton();
        this.pinBtn.setIcon(Icons.PIN);
        this.pinBtn.setRolloverIcon(Icons.PIN_HOVERED);
        this.pinBtn.setRolloverEnabled(true);
        this.pinBtn.setOpaque(false);
        this.pinBtn.setUI(new BasicButtonUI());
        this.pinBtn.setContentAreaFilled(false);
        this.pinBtn.setBorder(null);
        this.pinBtn.setBorderPainted(false);
        this.pinBtn.addActionListener(e -> this.togglePin());
        this.closeBtn = new JButton();
        this.closeBtn.setIcon(Icons.CLOSE_INACTIVE);
        this.closeBtn.setRolloverIcon(Icons.CLOSE);
        this.closeBtn.setRolloverEnabled(true);
        this.closeBtn.setOpaque(false);
        this.closeBtn.setUI(new BasicButtonUI());
        this.closeBtn.setContentAreaFilled(false);
        this.closeBtn.setFocusable(false);
        this.closeBtn.setBorder(null);
        this.closeBtn.setBorderPainted(false);
        this.closeBtn.addActionListener(e -> this.tabsController.closeTab(node, true));
        MouseAdapter clickAdapter = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SwingUtilities.isMiddleMouseButton(e)) {
                    TabComponent.this.tabsController.closeTab(node, true);
                } else if (SwingUtilities.isRightMouseButton(e)) {
                    JPopupMenu menu = TabComponent.this.createTabPopupMenu();
                    menu.show(e.getComponent(), e.getX(), e.getY());
                } else if (SwingUtilities.isLeftMouseButton(e)) {
                    TabComponent.this.tabsController.selectTab(node);
                }
            }
        };
        this.addMouseListener(clickAdapter);
        this.addListenerForDnd();
        this.add(this.label);
        this.updateCloseOrPinButton();
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
    }

    public void updateCloseOrPinButton() {
        if (this.getBlueprint().isPinned()) {
            if (this.closeBtn.isShowing()) {
                this.remove(this.closeBtn);
            }
            if (!this.pinBtn.isShowing()) {
                this.add(this.pinBtn);
            }
        } else {
            if (this.pinBtn.isShowing()) {
                this.remove(this.pinBtn);
            }
            if (!this.closeBtn.isShowing()) {
                this.add(this.closeBtn);
            }
        }
    }

    public void updateBookmarkIcon() {
        this.icon.clear();
        if (this.getBlueprint().isBookmarked()) {
            this.icon.add(Icons.BOOKMARK_OVERLAY_DARK);
        }
        this.label.repaint();
    }

    private void togglePin() {
        boolean pinned = !this.getBlueprint().isPinned();
        this.tabsController.setTabPinned(this.getNode(), pinned);
        if (pinned) {
            this.tabsController.setTabPositionFirst(this.getNode());
        }
    }

    private void toggleBookmark() {
        boolean bookmarked = !this.getBlueprint().isBookmarked();
        this.tabsController.setTabBookmarked(this.getNode(), bookmarked);
    }

    private void addListenerForDnd() {
        if (this.tabbedPane.getDnd() == null) {
            return;
        }
        final TabComponent comp = this;
        TabDndGestureListener dgl = new TabDndGestureListener(this.tabbedPane.getDnd()){

            @Override
            protected Point getDragOrigin(DragGestureEvent e) {
                return SwingUtilities.convertPoint(comp, e.getDragOrigin(), TabComponent.this.tabbedPane);
            }
        };
        DragSource.getDefaultDragSource().createDefaultDragGestureRecognizer(this, 3, dgl);
    }

    private String buildTabTitle(JNode node) {
        String tabTitle = node.getRootClass() != null ? node.getRootClass().getName() : node.makeLongStringHtml();
        if (node instanceof JEditableNode && ((JEditableNode)node).isChanged()) {
            return "*" + tabTitle;
        }
        return tabTitle;
    }

    private JPopupMenu createTabPopupMenu() {
        JPopupMenu menu = new JPopupMenu();
        String nodeFullName = this.getNodeFullName(this.contentPanel);
        if (nodeFullName != null) {
            JMenuItem copyRootClassName = new JMenuItem(NLS.str("tabs.copy_class_name"));
            copyRootClassName.addActionListener(actionEvent -> UiUtils.setClipboardString(nodeFullName));
            menu.add(copyRootClassName);
            menu.addSeparator();
        }
        if (this.getBlueprint().supportsQuickTabs()) {
            String pinTitle = this.getBlueprint().isPinned() ? NLS.str("tabs.unpin") : NLS.str("tabs.pin");
            JMenuItem pinTab = new JMenuItem(pinTitle);
            pinTab.addActionListener(e -> this.togglePin());
            menu.add(pinTab);
            JMenuItem unpinAll = new JMenuItem(NLS.str("tabs.unpin_all"));
            unpinAll.addActionListener(e -> this.tabsController.unpinAllTabs());
            menu.add(unpinAll);
            String bookmarkTitle = this.getBlueprint().isBookmarked() ? NLS.str("tabs.unbookmark") : NLS.str("tabs.bookmark");
            JMenuItem bookmarkTab = new JMenuItem(bookmarkTitle);
            bookmarkTab.addActionListener(e -> this.toggleBookmark());
            menu.add(bookmarkTab);
            JMenuItem unbookmarkAll = new JMenuItem(NLS.str("tabs.unbookmark_all"));
            unbookmarkAll.addActionListener(e -> this.tabsController.unbookmarkAllTabs());
            menu.add(unbookmarkAll);
        }
        JMenuItem closeTab = new JMenuItem(NLS.str("tabs.close"));
        closeTab.addActionListener(e -> this.tabsController.closeTab(this.getNode(), true));
        if (this.getBlueprint().isPinned()) {
            closeTab.setEnabled(false);
        }
        menu.add(closeTab);
        List<TabBlueprint> tabs = this.tabsController.getOpenTabs();
        if (tabs.size() > 1) {
            JMenuItem closeOther = new JMenuItem(NLS.str("tabs.closeOthers"));
            closeOther.addActionListener(e -> {
                JNode currentNode = this.getNode();
                for (TabBlueprint tab : tabs) {
                    if (tab.getNode() == currentNode) continue;
                    this.tabsController.closeTab(tab, true);
                }
            });
            menu.add(closeOther);
            JMenuItem closeAll = new JMenuItem(NLS.str("tabs.closeAll"));
            closeAll.addActionListener(e -> this.tabsController.closeAllTabs(true));
            menu.add(closeAll);
            List<ContentPanel> contentPanels = this.tabbedPane.getTabs();
            if (this.contentPanel != ListUtils.last(contentPanels)) {
                JMenuItem closeAllRight = new JMenuItem(NLS.str("tabs.closeAllRight"));
                closeAllRight.addActionListener(e -> {
                    boolean pastCurrentPanel = false;
                    for (ContentPanel panel : contentPanels) {
                        if (!pastCurrentPanel) {
                            if (panel != this.contentPanel) continue;
                            pastCurrentPanel = true;
                            continue;
                        }
                        this.tabsController.closeTab(panel.getNode(), true);
                    }
                });
                menu.add(closeAllRight);
            }
            menu.addSeparator();
            TabBlueprint selectedTab = this.tabsController.getSelectedTab();
            for (TabBlueprint tab : tabs) {
                if (tab == selectedTab) continue;
                JNode node = tab.getNode();
                String clsName = node.makeLongString();
                JMenuItem item = new JMenuItem(clsName);
                item.addActionListener(e -> this.tabsController.codeJump(node));
                item.setIcon(node.getIcon());
                menu.add(item);
            }
        }
        return menu;
    }

    private String getNodeFullName(ContentPanel contentPanel) {
        JNode node = contentPanel.getNode();
        JClass jClass = node.getRootClass();
        if (jClass != null) {
            return jClass.getFullName();
        }
        return node.getName();
    }

    public ContentPanel getContentPanel() {
        return this.contentPanel;
    }

    public TabBlueprint getBlueprint() {
        TabBlueprint blueprint = this.tabsController.getTabByNode(this.contentPanel.getNode());
        if (blueprint == null) {
            throw new JadxRuntimeException("TabComponent does not have a corresponding TabBlueprint");
        }
        return blueprint;
    }

    public JNode getNode() {
        return this.contentPanel.getNode();
    }
}

