/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui.codearea;

import jadx.api.ICodeInfo;
import jadx.api.ResourceFile;
import jadx.api.ResourcesLoader;
import jadx.core.utils.exceptions.JadxException;
import jadx.gui.treemodel.JNode;
import jadx.gui.treemodel.JResource;
import jadx.gui.ui.codearea.AbstractCodeArea;
import jadx.gui.ui.codearea.HexAreaConfiguration;
import jadx.gui.ui.codearea.HexConfigurationPanel;
import jadx.gui.ui.codearea.HexPreviewPanel;
import jadx.gui.ui.panel.ContentPanel;
import jadx.gui.utils.UiUtils;
import java.awt.BorderLayout;
import java.awt.Font;
import java.nio.charset.StandardCharsets;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.apache.commons.lang3.StringUtils;
import org.fife.ui.rsyntaxtextarea.Theme;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HexArea
extends AbstractCodeArea {
    private static final Logger LOG = LoggerFactory.getLogger(HexArea.class);
    private static final byte[] HEX_ARRAY = "0123456789ABCDEF".getBytes(StandardCharsets.US_ASCII);
    private final HexAreaConfiguration config;
    private final JNode binaryNode;
    private final HexPreviewPanel hexPreviewPanel;
    private HexConfigurationPanel hexConfigurationPanel;
    private byte[] bytes;

    public HexArea(ContentPanel contentPanel, JNode node) {
        super(contentPanel, node);
        this.binaryNode = node;
        this.config = new HexAreaConfiguration();
        this.hexPreviewPanel = new HexPreviewPanel(this.config);
        this.initView();
        this.applyTheme();
    }

    @Override
    @NotNull
    public ICodeInfo getCodeInfo() {
        return ICodeInfo.EMPTY;
    }

    @Override
    public void load() {
        byte[] bytes = null;
        if (this.binaryNode instanceof JResource) {
            JResource jResource = (JResource)this.binaryNode;
            try {
                bytes = (byte[])ResourcesLoader.decodeStream((ResourceFile)jResource.getResFile(), (size, is) -> is.readAllBytes());
            }
            catch (JadxException e) {
                LOG.error("Failed to directly load resource binary data {}: {}", (Object)jResource.getName(), (Object)e.getMessage());
            }
        }
        if (bytes == null) {
            bytes = this.binaryNode.getCodeInfo().getCodeStr().getBytes(StandardCharsets.UTF_8);
        }
        this.setBytes(bytes);
        if (this.getBytes().length > 0) {
            this.setCaretPosition(2);
        } else {
            this.setCaretPosition(0);
        }
        this.setLoaded();
    }

    @Override
    public void refresh() {
    }

    @Override
    public void loadSettings() {
        super.loadSettings();
        this.applyTheme();
    }

    private void applyTheme() {
        Font font = this.getContentPanel().getMainWindow().getSettings().getSmaliFont();
        this.setFont(font);
        Theme theme = this.contentPanel.getMainWindow().getEditorTheme();
        if (this.hexPreviewPanel != null) {
            this.hexPreviewPanel.applyTheme(theme, font);
        }
    }

    private void initView() {
        this.addCaretListener(new HexCaretListener());
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.hexPreviewPanel.setFont(this.getFont());
        this.add(this.hexPreviewPanel, "East");
    }

    private void setBytes(byte[] bytes) {
        String text;
        this.bytes = bytes;
        if (bytes.length > 0) {
            byte[] hexChars = new byte[bytes.length * 4 - 2];
            for (int j = 0; j < bytes.length; ++j) {
                int v = bytes[j] & 0xFF;
                hexChars[j * 4] = HEX_ARRAY[v >>> 4];
                hexChars[j * 4 + 1] = HEX_ARRAY[v & 0xF];
                if (j == bytes.length - 1) continue;
                hexChars[j * 4 + 2] = 32;
                hexChars[j * 4 + 3] = (byte)(j % this.config.bytesPerLine == this.config.bytesPerLine - 1 ? 10 : 32);
            }
            text = new String(hexChars, StandardCharsets.UTF_8);
        } else {
            text = "";
        }
        this.setText(text);
        this.hexPreviewPanel.setBytes(bytes);
        this.hexConfigurationPanel.setBytes(bytes);
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void setConfigurationPanel(HexConfigurationPanel hexConfigurationPanel) {
        this.hexConfigurationPanel = hexConfigurationPanel;
    }

    public void copyAsStyledText() {
        String text = this.getSelectedText();
        if (text != null && !StringUtils.isEmpty((CharSequence)text)) {
            text = text.replace(" ", "").replace("\n", "");
            UiUtils.copyToClipboard(text);
        }
    }

    public HexAreaConfiguration getConfiguration() {
        return this.config;
    }

    private class HexCaretListener
    implements CaretListener {
        private boolean isListening = true;
        private int previousCaretDot = -1;

        private HexCaretListener() {
        }

        @Override
        public void caretUpdate(CaretEvent caretEvent) {
            int dot = caretEvent.getDot();
            int mark = caretEvent.getMark();
            if (!this.isListening) {
                return;
            }
            if (dot % 2 == 1) {
                if (this.previousCaretDot > dot) {
                    if (mark == dot) {
                        --mark;
                    }
                    --dot;
                } else {
                    if (mark == dot) {
                        ++mark;
                    }
                    ++dot;
                }
                this.isListening = false;
                HexArea.this.setCaretPosition(mark);
                HexArea.this.moveCaretPosition(dot);
                this.isListening = true;
            }
            if (this.previousCaretDot != dot) {
                this.onTextCursorMoved(dot, mark);
            }
            this.previousCaretDot = dot;
        }

        private void onTextCursorMoved(int dot, int mark) {
            HexArea.this.hexConfigurationPanel.setOffset(dot / 4);
            int startIndex = Math.min(dot, mark);
            int endIndex = Math.max(dot, mark);
            int startOffset = startIndex / 4;
            int endOffset = endIndex / 4;
            if (startIndex % 4 == 2 && endIndex == startIndex + 2) {
                HexArea.this.hexPreviewPanel.clearHighlights();
                return;
            }
            if (startOffset < endOffset && startIndex % 4 == 2) {
                ++startOffset;
            }
            if (endOffset > startOffset && endIndex % 4 == 0) {
                --endOffset;
            }
            HexArea.this.hexPreviewPanel.highlightBytes(startOffset, endOffset);
        }
    }
}

