/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.treemodel;

import jadx.api.ICodeInfo;
import jadx.api.ResourceFile;
import jadx.api.ResourceType;
import jadx.api.ResourcesLoader;
import jadx.api.impl.SimpleCodeInfo;
import jadx.core.utils.ListUtils;
import jadx.core.utils.Utils;
import jadx.core.xmlgen.ResContainer;
import jadx.gui.jobs.IBackgroundTask;
import jadx.gui.jobs.SimpleTask;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JLoadableNode;
import jadx.gui.treemodel.TextNode;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.codearea.BinaryContentPanel;
import jadx.gui.ui.codearea.CodeContentPanel;
import jadx.gui.ui.panel.ContentPanel;
import jadx.gui.ui.panel.ImagePanel;
import jadx.gui.ui.popupmenu.JResourcePopupMenu;
import jadx.gui.ui.tab.TabbedPane;
import jadx.gui.utils.Icons;
import jadx.gui.utils.NLS;
import jadx.gui.utils.UiUtils;
import jadx.gui.utils.res.ResTableHelper;
import java.io.InputStream;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import org.jetbrains.annotations.Nullable;

public class JResource
extends JLoadableNode {
    private static final long serialVersionUID = -201018424302612434L;
    private static final ImageIcon ROOT_ICON = UiUtils.openSvgIcon("nodes/resourcesRoot");
    private static final ImageIcon ARSC_ICON = UiUtils.openSvgIcon("nodes/resourceBundle");
    private static final ImageIcon XML_ICON = UiUtils.openSvgIcon("nodes/xml");
    private static final ImageIcon IMAGE_ICON = UiUtils.openSvgIcon("nodes/ImagesFileType");
    private static final ImageIcon SO_ICON = UiUtils.openSvgIcon("nodes/binaryFile");
    private static final ImageIcon MANIFEST_ICON = UiUtils.openSvgIcon("nodes/manifest");
    private static final ImageIcon JAVA_ICON = UiUtils.openSvgIcon("nodes/java");
    private static final ImageIcon UNKNOWN_ICON = UiUtils.openSvgIcon("nodes/unknown");
    public static final Comparator<JResource> RESOURCES_COMPARATOR = Comparator.comparingInt(r -> r.type.ordinal()).thenComparing(JResource::getName, String.CASE_INSENSITIVE_ORDER);
    private final transient String name;
    private final transient String shortName;
    private final transient JResType type;
    private final transient ResourceFile resFile;
    private volatile transient boolean loaded;
    private transient List<JResource> subNodes = Collections.emptyList();
    private transient ICodeInfo content;
    private static final Map<String, String> EXTENSION_TO_FILE_SYNTAX = Utils.newConstStringMap((String[])new String[]{"java", "text/java", "js", "text/javascript", "ts", "text/typescript", "json", "text/json", "css", "text/css", "less", "text/less", "html", "text/html", "xml", "text/xml", "yaml", "text/yaml", "properties", "text/properties", "ini", "text/ini", "sql", "text/sql"});

    public JResource(ResourceFile resFile, String name, JResType type) {
        this(resFile, name, name, type);
    }

    public JResource(ResourceFile resFile, String name, String shortName, JResType type) {
        this.resFile = resFile;
        this.name = name;
        this.shortName = shortName;
        this.type = type;
        this.loaded = false;
    }

    public final void update() {
        this.removeAllChildren();
        if (Utils.isEmpty(this.subNodes)) {
            if (this.type == JResType.DIR || this.type == JResType.ROOT || this.resFile.getType() == ResourceType.ARSC) {
                this.add(new TextNode(NLS.str("tree.loading")));
            }
        } else {
            for (JResource res : this.subNodes) {
                res.update();
                this.add(res);
            }
        }
    }

    @Override
    public synchronized void loadNode() {
        this.getCodeInfo();
        this.update();
    }

    @Override
    public synchronized IBackgroundTask getLoadTask() {
        return new SimpleTask(NLS.str("progress.load"), this::getCodeInfo, this::update);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public JResType getType() {
        return this.type;
    }

    public List<JResource> getSubNodes() {
        return this.subNodes;
    }

    public void addSubNode(JResource node) {
        this.subNodes = ListUtils.safeAdd(this.subNodes, (Object)node);
    }

    public void sortSubNodes() {
        JResource.sortResNodes(this.subNodes);
    }

    private static void sortResNodes(List<JResource> nodes) {
        if (Utils.notEmpty(nodes)) {
            nodes.forEach(JResource::sortSubNodes);
            nodes.sort(RESOURCES_COMPARATOR);
        }
    }

    @Override
    @Nullable
    public ContentPanel getContentPanel(TabbedPane tabbedPane) {
        if (this.resFile == null) {
            return null;
        }
        if (this.resFile.getType() == ResourceType.IMG) {
            return new ImagePanel(tabbedPane, this);
        }
        if (this.resFile.getType() == ResourceType.LIB) {
            return new BinaryContentPanel(tabbedPane, this, false);
        }
        if (this.getSyntaxByExtension(this.resFile.getDeobfName()) == null) {
            return new BinaryContentPanel(tabbedPane, this);
        }
        return new CodeContentPanel(tabbedPane, this);
    }

    @Override
    public JPopupMenu onTreePopupMenu(MainWindow mainWindow) {
        return new JResourcePopupMenu(mainWindow, this);
    }

    @Override
    public synchronized ICodeInfo getCodeInfo() {
        ICodeInfo codeInfo;
        if (this.loaded) {
            return this.content;
        }
        this.content = codeInfo = this.loadContent();
        this.loaded = true;
        return codeInfo;
    }

    private ICodeInfo loadContent() {
        if (this.resFile == null || this.type != JResType.FILE) {
            return ICodeInfo.EMPTY;
        }
        if (!JResource.isSupportedForView(this.resFile.getType())) {
            return ICodeInfo.EMPTY;
        }
        ResContainer rc = this.resFile.loadContent();
        if (rc == null) {
            return ICodeInfo.EMPTY;
        }
        if (rc.getDataType() == ResContainer.DataType.RES_TABLE) {
            ICodeInfo codeInfo = this.loadCurrentSingleRes(rc);
            List<JResource> nodes = ResTableHelper.buildTree(rc);
            JResource.sortResNodes(nodes);
            this.subNodes = nodes;
            return codeInfo;
        }
        return this.loadCurrentSingleRes(rc);
    }

    private ICodeInfo loadCurrentSingleRes(ResContainer rc) {
        switch (rc.getDataType()) {
            case TEXT: 
            case RES_TABLE: {
                return rc.getText();
            }
            case RES_LINK: {
                try {
                    return (ICodeInfo)ResourcesLoader.decodeStream((ResourceFile)rc.getResLink(), (size, is) -> {
                        if (size > 0xA00000L) {
                            return new SimpleCodeInfo("File too large for view");
                        }
                        return ResourcesLoader.loadToCodeWriter((InputStream)is);
                    });
                }
                catch (Exception e) {
                    return new SimpleCodeInfo("Failed to load resource file:\n" + Utils.getStackTrace((Throwable)e));
                }
            }
        }
        return new SimpleCodeInfo("Unexpected resource type: " + rc);
    }

    @Override
    public String getSyntaxName() {
        if (this.resFile == null) {
            return null;
        }
        switch (this.resFile.getType()) {
            case CODE: {
                return super.getSyntaxName();
            }
            case MANIFEST: 
            case XML: 
            case ARSC: {
                return "text/xml";
            }
        }
        String syntax = this.getSyntaxByExtension(this.resFile.getDeobfName());
        if (syntax != null) {
            return syntax;
        }
        return super.getSyntaxName();
    }

    private String getSyntaxByExtension(String name) {
        int dot = name.lastIndexOf(46);
        if (dot == -1) {
            return null;
        }
        String ext = name.substring(dot + 1);
        return EXTENSION_TO_FILE_SYNTAX.get(ext);
    }

    @Override
    public Icon getIcon() {
        switch (this.type) {
            case ROOT: {
                return ROOT_ICON;
            }
            case DIR: {
                return Icons.FOLDER;
            }
            case FILE: {
                ResourceType resType = this.resFile.getType();
                switch (resType) {
                    case MANIFEST: {
                        return MANIFEST_ICON;
                    }
                    case ARSC: {
                        return ARSC_ICON;
                    }
                    case XML: {
                        return XML_ICON;
                    }
                    case IMG: {
                        return IMAGE_ICON;
                    }
                    case LIB: {
                        return SO_ICON;
                    }
                    case CODE: {
                        return JAVA_ICON;
                    }
                    case UNKNOWN: {
                        return UNKNOWN_ICON;
                    }
                }
                return UNKNOWN_ICON;
            }
        }
        return Icons.FILE;
    }

    public static boolean isSupportedForView(ResourceType type) {
        switch (type) {
            case CODE: 
            case FONT: 
            case MEDIA: {
                return false;
            }
            case MANIFEST: 
            case XML: 
            case ARSC: 
            case IMG: 
            case LIB: 
            case UNKNOWN: {
                return true;
            }
        }
        return true;
    }

    public ResourceFile getResFile() {
        return this.resFile;
    }

    @Override
    public JClass getJParent() {
        return null;
    }

    @Override
    public String makeString() {
        return this.shortName;
    }

    @Override
    public String makeLongString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.name.equals(((JResource)o).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static enum JResType {
        ROOT,
        DIR,
        FILE;

    }
}

