/*
 * Decompiled with CFR 0.152.
 */
package jadx.cli;

import jadx.api.ICodeCache;
import jadx.api.JadxArgs;
import jadx.api.JadxDecompiler;
import jadx.api.impl.AnnotatedCodeWriter;
import jadx.api.impl.NoOpCodeCache;
import jadx.api.impl.SimpleCodeWriter;
import jadx.api.plugins.loader.JadxPluginLoader;
import jadx.api.usage.IUsageInfoCache;
import jadx.api.usage.impl.EmptyUsageInfoCache;
import jadx.cli.JadxAppCommon;
import jadx.cli.JadxCLIArgs;
import jadx.cli.LogHelper;
import jadx.cli.SingleClassMode;
import jadx.cli.config.JadxConfigAdapter;
import jadx.cli.plugins.JadxFilesGetter;
import jadx.core.plugins.files.IJadxFilesGetter;
import jadx.core.utils.exceptions.JadxArgsValidateException;
import jadx.plugins.tools.JadxExternalPluginsLoader;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JadxCLI {
    private static final Logger LOG = LoggerFactory.getLogger(JadxCLI.class);

    public static void main(String[] args) {
        int result = 1;
        try {
            result = JadxCLI.execute(args);
        }
        finally {
            System.exit(result);
        }
    }

    public static int execute(String[] args) {
        return JadxCLI.execute(args, null);
    }

    public static int execute(String[] args, @Nullable Consumer<JadxArgs> argsMod) {
        try {
            JadxCLIArgs cliArgs = JadxCLIArgs.processArgs(args, new JadxCLIArgs(), new JadxConfigAdapter<JadxCLIArgs>(JadxCLIArgs.class, "cli"));
            if (cliArgs == null) {
                return 0;
            }
            JadxArgs jadxArgs = JadxCLI.buildArgs(cliArgs);
            if (argsMod != null) {
                argsMod.accept(jadxArgs);
            }
            return JadxCLI.runSave(jadxArgs, cliArgs);
        }
        catch (JadxArgsValidateException e) {
            LOG.error("Incorrect arguments: {}", (Object)e.getMessage());
            return 1;
        }
        catch (Throwable e) {
            LOG.error("Process error:", e);
            return 1;
        }
    }

    private static JadxArgs buildArgs(JadxCLIArgs cliArgs) {
        JadxArgs jadxArgs = cliArgs.toJadxArgs();
        jadxArgs.setCodeCache((ICodeCache)new NoOpCodeCache());
        jadxArgs.setUsageInfoCache((IUsageInfoCache)new EmptyUsageInfoCache());
        jadxArgs.setPluginLoader((JadxPluginLoader)new JadxExternalPluginsLoader());
        jadxArgs.setFilesGetter((IJadxFilesGetter)JadxFilesGetter.INSTANCE);
        JadxCLI.initCodeWriterProvider(jadxArgs);
        JadxAppCommon.applyEnvVars(jadxArgs);
        return jadxArgs;
    }

    private static int runSave(JadxArgs jadxArgs, JadxCLIArgs cliArgs) {
        try (JadxDecompiler jadx = new JadxDecompiler(jadxArgs);){
            int errorsCount;
            jadx.load();
            if (JadxCLI.checkForErrors(jadx)) {
                int n = 2;
                return n;
            }
            if (!SingleClassMode.process(jadx, cliArgs)) {
                JadxCLI.save(jadx);
            }
            if ((errorsCount = jadx.getErrorsCount()) != 0) {
                jadx.printErrorsReport();
                LOG.error("finished with errors, count: {}", (Object)errorsCount);
                int n = 3;
                return n;
            }
            LOG.info("done");
            int n = 0;
            return n;
        }
    }

    private static void initCodeWriterProvider(JadxArgs jadxArgs) {
        switch (jadxArgs.getOutputFormat()) {
            case JAVA: {
                jadxArgs.setCodeWriterProvider(SimpleCodeWriter::new);
                break;
            }
            case JSON: {
                jadxArgs.setCodeWriterProvider(AnnotatedCodeWriter::new);
            }
        }
    }

    private static boolean checkForErrors(JadxDecompiler jadx) {
        int errorsCount;
        if (jadx.getRoot().getClasses().isEmpty()) {
            if (jadx.getArgs().isSkipResources()) {
                LOG.error("Load failed! No classes for decompile!");
                return true;
            }
            if (!jadx.getArgs().isSkipSources()) {
                LOG.warn("No classes to decompile; decoding resources only");
                jadx.getArgs().setSkipSources(true);
            }
        }
        if ((errorsCount = jadx.getErrorsCount()) > 0) {
            LOG.error("Loading finished with errors! Count: {}", (Object)errorsCount);
        }
        return false;
    }

    private static void save(JadxDecompiler jadx) {
        if (LogHelper.getLogLevel() == LogHelper.LogLevelEnum.QUIET) {
            jadx.save();
        } else {
            LOG.info("processing ...");
            jadx.save(500, (done, total) -> {
                int progress = (int)((double)done * 100.0 / (double)total);
                System.out.printf("INFO  - progress: %d of %d (%d%%)\r", done, total, progress);
            });
            System.out.print("                                                             \r");
        }
    }
}

